/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PyAbstractClassInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Visitor
    extends PyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
        }

        @Override
        public void visitPyClass(@NotNull PyClass pyClass) {
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (this.isAbstract(pyClass) || PyProtocolsKt.isProtocol(pyClass, this.myTypeEvalContext)) {
                return;
            }
            List toImplement = ContainerUtil.filter(PyPsiRefactoringUtil.getAllSuperAbstractMethods(pyClass, this.myTypeEvalContext), function -> PyKnownDecoratorUtil.hasAbstractDecorator(function, this.myTypeEvalContext));
            ASTNode nameNode = pyClass.getNameNode();
            if (!toImplement.isEmpty() && nameNode != null) {
                SmartList quickFixes = new SmartList();
                LocalQuickFix qf = PythonUiService.getInstance().createPyImplementMethodsQuickFix(pyClass, toImplement);
                if (qf != null) {
                    quickFixes.add((Object)qf);
                }
                quickFixes.add((Object)new SetABCMetaAsMetaclassQuickFix());
                if (LanguageLevel.forElement(pyClass).isPy3K()) {
                    quickFixes.add((Object)new AddABCToSuperclassesQuickFix());
                }
                this.registerProblem(nameNode.getPsi(), PyPsiBundle.message("INSP.abstract.class.class.must.implement.all.abstract.methods", pyClass.getName()), (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private boolean isAbstract(@NotNull PyClass pyClass) {
            PyClassLikeType metaClass;
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((metaClass = pyClass.getMetaClassType(false, this.myTypeEvalContext)) != null && "ABCMeta".equals(metaClass.getName())) {
                return true;
            }
            for (PyClassLikeType superClassType : pyClass.getSuperClassTypes(this.myTypeEvalContext)) {
                if (superClassType == null || !"abc.ABC".equals(superClassType.getClassQName())) continue;
                return true;
            }
            for (PyFunction method : pyClass.getMethods()) {
                if (!PyKnownDecoratorUtil.hasAbstractDecorator(method, this.myTypeEvalContext)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAbstract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class SetABCMetaAsMetaclassQuickFix
        extends PsiUpdateModCommandQuickFix {
            private SetABCMetaAsMetaclassQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = PyPsiBundle.message("INSP.abstract.class.set.as.metaclass", "abc.ABCMeta");
                if (string == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                PyClass cls;
                if (project2 == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(3);
                }
                if ((cls = PyUtil.as(element.getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass abcMetaClass = PyPsiFacade.getInstance(project2).createClassByQName("abc.ABCMeta", cls);
                if (abcMetaClass == null) {
                    return;
                }
                TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile());
                PyPsiRefactoringUtil.addMetaClassIfNotExist(cls, abcMetaClass, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }

        private static class AddABCToSuperclassesQuickFix
        extends PsiUpdateModCommandQuickFix {
            private AddABCToSuperclassesQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = PyPsiBundle.message("INSP.abstract.class.add.to.superclasses", "abc.ABC");
                if (string == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                PyClass cls;
                if (project2 == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(3);
                }
                if ((cls = PyUtil.as(element.getParent(), PyClass.class)) == null) {
                    return;
                }
                PyClass abcClass = PyPsiFacade.getInstance(project2).createClassByQName("abc.ABC", cls);
                if (abcClass == null) {
                    return;
                }
                PyPsiRefactoringUtil.addSuperclasses(project2, cls, abcClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

