/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class PyDebugValueExecutionService {
    @Nullable
    private ExecutorService myAsyncValuesExecutorService = Executors.newFixedThreadPool(PyDebugValue.AVAILABLE_PROCESSORS, ConcurrencyUtil.newNamedThreadFactory((String)"PyDebug Async Executor"));
    @NotNull
    private final List<PyFrameAccessor> myFrameAccessors = new ArrayList<PyFrameAccessor>();
    @NotNull
    private final List<List<Future>> mySubmittedTasks = new ArrayList<List<Future>>();

    public static PyDebugValueExecutionService getInstance(Project project2) {
        return (PyDebugValueExecutionService)project2.getService(PyDebugValueExecutionService.class);
    }

    private PyDebugValueExecutionService() {
    }

    public synchronized void sessionStarted(@NotNull PyFrameAccessor frameAccessor) {
        if (frameAccessor == null) {
            PyDebugValueExecutionService.$$$reportNull$$$0(0);
        }
        if (this.myAsyncValuesExecutorService == null) {
            this.myAsyncValuesExecutorService = Executors.newFixedThreadPool(PyDebugValue.AVAILABLE_PROCESSORS, ConcurrencyUtil.newNamedThreadFactory((String)"PyDebug Async Executor"));
        }
        if (!this.myFrameAccessors.contains(frameAccessor)) {
            this.myFrameAccessors.add(frameAccessor);
            this.mySubmittedTasks.add(new ArrayList());
        }
    }

    public synchronized void submitTask(@NotNull PyFrameAccessor frameAccessor, @NotNull Runnable task2) {
        Future<?> future;
        if (frameAccessor == null) {
            PyDebugValueExecutionService.$$$reportNull$$$0(1);
        }
        if (task2 == null) {
            PyDebugValueExecutionService.$$$reportNull$$$0(2);
        }
        Future<?> future2 = future = this.myAsyncValuesExecutorService != null ? this.myAsyncValuesExecutorService.submit(task2) : null;
        if (!this.myFrameAccessors.contains(frameAccessor)) {
            this.myFrameAccessors.add(frameAccessor);
            this.mySubmittedTasks.add(new ArrayList());
        }
        int i = this.myFrameAccessors.indexOf(frameAccessor);
        this.mySubmittedTasks.get(i).add(future);
    }

    public synchronized void cancelSubmittedTasks(@NotNull PyFrameAccessor frameAccessor) {
        int i;
        if (frameAccessor == null) {
            PyDebugValueExecutionService.$$$reportNull$$$0(3);
        }
        if ((i = this.myFrameAccessors.indexOf(frameAccessor)) != -1) {
            List<Future> submittedTasks = this.mySubmittedTasks.get(i);
            for (Future task2 : submittedTasks) {
                if (task2.isDone()) continue;
                task2.cancel(true);
            }
            submittedTasks.clear();
        }
    }

    public synchronized void sessionStopped(@NotNull PyFrameAccessor frameAccessor) {
        int i;
        if (frameAccessor == null) {
            PyDebugValueExecutionService.$$$reportNull$$$0(4);
        }
        if ((i = this.myFrameAccessors.indexOf(frameAccessor)) != -1) {
            this.myFrameAccessors.remove(i);
            this.mySubmittedTasks.remove(i);
        }
        if (this.myFrameAccessors.size() == 0 && this.myAsyncValuesExecutorService != null) {
            this.myAsyncValuesExecutorService.shutdownNow();
            this.myAsyncValuesExecutorService = null;
        }
    }

    @TestOnly
    public synchronized void shutDownNow(long timeout) throws InterruptedException {
        if (this.myAsyncValuesExecutorService != null) {
            this.myAsyncValuesExecutorService.shutdownNow();
            this.myAsyncValuesExecutorService.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugValueExecutionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sessionStarted";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelSubmittedTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "sessionStopped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

