/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.featuresTrainer.ift;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.python.featuresTrainer.ift.PythonLessonsBundle;
import com.intellij.python.featuresTrainer.ift.PythonLessonsUtil;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.steps.ProjectSpecificSettingsStep;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.lang.LangSupport;
import training.ui.OnboardingFeedbackFormKt;
import training.util.LessonEndInfo;
import training.util.OnboardingFeedbackData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\n\u0010\u0012\u001a\u00020\b*\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/featuresTrainer/ift/PythonLessonsUtil;", "", "()V", "isPython3Installed", "", "project", "Lcom/intellij/openapi/project/Project;", "prepareFeedbackDataForOnboardingLesson", "", "configPropertyName", "", "reportTitle", "feedbackReportId", "primaryLanguage", "Ltraining/lang/LangSupport;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "usedInterpreterAtStart", "showWarningIfPython3NotFound", "Ltraining/dsl/LessonContext;", "intellij.python.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nPythonLessonsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonLessonsUtil.kt\ncom/intellij/python/featuresTrainer/ift/PythonLessonsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1603#2,9:113\n1855#2:122\n1856#2:124\n1612#2:125\n1#3:123\n*S KotlinDebug\n*F\n+ 1 PythonLessonsUtil.kt\ncom/intellij/python/featuresTrainer/ift/PythonLessonsUtil\n*L\n68#1:113,9\n68#1:122\n68#1:124\n68#1:125\n68#1:123\n*E\n"})
public final class PythonLessonsUtil {
    @NotNull
    public static final PythonLessonsUtil INSTANCE = new PythonLessonsUtil();

    private PythonLessonsUtil() {
    }

    public final boolean isPython3Installed(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Sdk sdk2 = PySdkExtKt.getPythonSdk(project2);
        if (sdk2 == null) {
            return false;
        }
        Sdk sdk3 = sdk2;
        Object object = PythonSdkFlavor.getFlavor(sdk3);
        return object != null && (object = ((PythonSdkFlavor)object).getLanguageLevel(sdk3)) != null ? ((LanguageLevel)((Object)object)).isPy3K() : false;
    }

    public final void showWarningIfPython3NotFound(@NotNull LessonContext $this$showWarningIfPython3NotFound) {
        Intrinsics.checkNotNullParameter((Object)$this$showWarningIfPython3NotFound, (String)"<this>");
        $this$showWarningIfPython3NotFound.task((Function1)showWarningIfPython3NotFound.1.INSTANCE);
    }

    public final void prepareFeedbackDataForOnboardingLesson(@NotNull Project project2, @NotNull String configPropertyName, @NotNull String reportTitle, @NotNull String feedbackReportId, @NotNull LangSupport primaryLanguage, @NotNull LessonEndInfo lessonEndInfo, @NotNull String usedInterpreterAtStart) {
        Object usedInterpreter;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configPropertyName, (String)"configPropertyName");
        Intrinsics.checkNotNullParameter((Object)reportTitle, (String)"reportTitle");
        Intrinsics.checkNotNullParameter((Object)feedbackReportId, (String)"feedbackReportId");
        Intrinsics.checkNotNullParameter((Object)primaryLanguage, (String)"primaryLanguage");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        Intrinsics.checkNotNullParameter((Object)usedInterpreterAtStart, (String)"usedInterpreterAtStart");
        if (!OnboardingFeedbackFormKt.shouldCollectFeedbackResults()) {
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean(configPropertyName, false)) {
            return;
        }
        Sdk[] sdkArray = PyConfigurableInterpreterList.getInstance(null).getModel().getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getSdks(...)");
        Sdk[] sdkArray2 = sdkArray;
        List allExistingSdks = CollectionsKt.listOf((Object[])Arrays.copyOf(sdkArray2, sdkArray2.length));
        List<Sdk> list = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValidPythonSdks(...)");
        List<Sdk> existingSdks = list;
        CompletableFuture<List<String>> interpreterVersions = new CompletableFuture<List<String>>();
        ApplicationManager.getApplication().executeOnPooledThread(() -> PythonLessonsUtil.prepareFeedbackDataForOnboardingLesson$lambda$1(existingSdks, interpreterVersions));
        Object object = PySdkExtKt.getPythonSdk(project2);
        if (object == null || (object = object.getVersionString()) == null) {
            object = "none";
        }
        String startInterpreter = Intrinsics.areEqual((Object)usedInterpreterAtStart, (Object)(usedInterpreter = object)) ? "same" : usedInterpreterAtStart;
        primaryLanguage.setOnboardingFeedbackData(new OnboardingFeedbackData(feedbackReportId, reportTitle, lessonEndInfo, interpreterVersions, (String)usedInterpreter, startInterpreter, configPropertyName){
            @NotNull
            private final String feedbackReportId;
            private final int additionalFeedbackFormatVersion;
            @NotNull
            private final Lazy interpreters$delegate;
            @NotNull
            private final Function1<JsonObjectBuilder, Unit> addAdditionalSystemData;
            @NotNull
            private final Function1<Panel, Unit> addRowsForUserAgreement;
            final /* synthetic */ String $configPropertyName;
            {
                this.$configPropertyName = $configPropertyName;
                super($reportTitle, $lessonEndInfo);
                this.feedbackReportId = $feedbackReportId;
                this.additionalFeedbackFormatVersion = 1;
                this.interpreters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>($interpreterVersions){
                    final /* synthetic */ CompletableFuture<List<String>> $interpreterVersions;
                    {
                        this.$interpreterVersions = $interpreterVersions;
                        super(0);
                    }

                    @Nullable
                    public final List<String> invoke() {
                        return this.$interpreterVersions.isDone() ? this.$interpreterVersions.get() : null;
                    }
                }));
                this.addAdditionalSystemData = (Function1)new Function1<JsonObjectBuilder, Unit>($usedInterpreter, $startInterpreter, this){
                    final /* synthetic */ String $usedInterpreter;
                    final /* synthetic */ String $startInterpreter;
                    final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;
                    {
                        this.$usedInterpreter = $usedInterpreter;
                        this.$startInterpreter = $startInterpreter;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull JsonObjectBuilder $this$null) {
                        JsonArrayBuilder builder$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        JsonElementBuildersKt.put((JsonObjectBuilder)$this$null, (String)"current_interpreter", (String)this.$usedInterpreter);
                        JsonElementBuildersKt.put((JsonObjectBuilder)$this$null, (String)"start_interpreter", (String)this.$startInterpreter);
                        prepareFeedbackDataForOnboardingLesson.2 var2_2 = this.this$0;
                        boolean $i$f$buildJsonArray = false;
                        JsonArrayBuilder jsonArrayBuilder = builder$iv = new JsonArrayBuilder();
                        String string = "found_interpreters";
                        JsonObjectBuilder jsonObjectBuilder = $this$null;
                        boolean bl = false;
                        List list = var2_2.getInterpreters();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        for (String i : list) {
                            void $this$invoke_u24lambda_u240;
                            $this$invoke_u24lambda_u240.add((JsonElement)JsonElementKt.JsonPrimitive((String)i));
                        }
                        Unit unit = Unit.INSTANCE;
                        jsonObjectBuilder.put(string, (JsonElement)builder$iv.build());
                    }
                };
                this.addRowsForUserAgreement = (Function1)new Function1<Panel, Unit>(this, $usedInterpreter, $startInterpreter){
                    final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;
                    final /* synthetic */ String $usedInterpreter;
                    final /* synthetic */ String $startInterpreter;
                    {
                        this.this$0 = $receiver;
                        this.$usedInterpreter = $usedInterpreter;
                        this.$startInterpreter = $startInterpreter;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.found.interpreters", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ prepareFeedbackDataForOnboardingLesson.2 this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                List<String> list = this.this$0.getInterpreters();
                                String interpreters2 = list != null ? list.toString() : null;
                                String string = interpreters2;
                                if (string == null) {
                                    string = PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.no.interpreters", new Object[0]);
                                }
                                $this$row.label(string);
                            }
                        });
                        $this$null.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.used.interpreter", new Object[0]), (Function1)new Function1<Row, Unit>(this.$usedInterpreter){
                            final /* synthetic */ String $usedInterpreter;
                            {
                                this.$usedInterpreter = $usedInterpreter;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.$usedInterpreter);
                            }
                        });
                        $this$null.row(PythonLessonsBundle.INSTANCE.message("python.onboarding.feedback.system.start.interpreter", new Object[0]), (Function1)new Function1<Row, Unit>(this.$startInterpreter){
                            final /* synthetic */ String $startInterpreter;
                            {
                                this.$startInterpreter = $startInterpreter;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.label(this.$startInterpreter);
                            }
                        });
                    }
                };
            }

            @NotNull
            public String getFeedbackReportId() {
                return this.feedbackReportId;
            }

            public int getAdditionalFeedbackFormatVersion() {
                return this.additionalFeedbackFormatVersion;
            }

            @Nullable
            public final List<String> getInterpreters() {
                Lazy lazy = this.interpreters$delegate;
                return (List)lazy.getValue();
            }

            @NotNull
            public Function1<JsonObjectBuilder, Unit> getAddAdditionalSystemData() {
                return this.addAdditionalSystemData;
            }

            @NotNull
            public Function1<Panel, Unit> getAddRowsForUserAgreement() {
                return this.addRowsForUserAgreement;
            }

            public void feedbackHasBeenProposed() {
                PropertiesComponent.getInstance().setValue(this.$configPropertyName, true, false);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void prepareFeedbackDataForOnboardingLesson$lambda$1(List $existingSdks, CompletableFuture $interpreterVersions) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$existingSdks, (String)"$existingSdks");
        Intrinsics.checkNotNullParameter((Object)$interpreterVersions, (String)"$interpreterVersions");
        UserDataHolderBase context = new UserDataHolderBase();
        List<Sdk> baseSdks = PySdkExtKt.findBaseSdks($existingSdks, null, (UserDataHolder)context);
        Iterable iterable = baseSdks;
        CompletableFuture completableFuture = $interpreterVersions;
        boolean $i$f$mapNotNull = false;
        void var6_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl2 = false;
            if (it.getSdkType().getVersionString(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        completableFuture.complete(CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv))));
    }
}

