/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.java.psi.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;

public final class PyJavaImportCandidateProvider
implements PyImportCandidateProvider {
    @Override
    public void addImportCandidates(PsiReference reference, String name2, AutoImportQuickFix quickFix) {
        PsiClass[] classesByName;
        PsiElement element = reference.getElement();
        Project project2 = element.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        GlobalSearchScope scope = module == null ? ProjectScope.getAllScope((Project)project2) : module.getModuleWithDependenciesAndLibrariesScope(false);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        for (PsiClass psiClass : classesByName = cache.getClassesByName(name2, scope)) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) continue;
            QualifiedName packageQName = QualifiedName.fromDottedString((String)qualifiedName).removeLastComponent();
            quickFix.addImport((PsiNamedElement)psiClass, (PsiFileSystemItem)psiClass.getContainingFile(), packageQName);
        }
    }
}

