/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.documentation;

import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.PsiDocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import com.intellij.python.community.impl.huggingFace.HuggingFaceUtil;
import com.intellij.python.community.impl.huggingFace.annotation.HuggingFaceIdentifierPsiElement;
import com.intellij.python.community.impl.huggingFace.documentation.HuggingFaceDocumentationTarget;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/community/impl/huggingFace/documentation/HuggingFaceDocumentationTargetProvider;", "Lcom/intellij/platform/backend/documentation/PsiDocumentationTargetProvider;", "()V", "documentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "documentationTargets", "", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceDocumentationTargetProvider
implements PsiDocumentationTargetProvider {
    @NotNull
    public List<DocumentationTarget> documentationTargets(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List documentationTargets = new ArrayList();
        PsiElement psiElement = element;
        if (psiElement instanceof PyTargetExpression) {
            PyExpression referencedElement = ((PyTargetExpression)element).findAssignedValue();
            if (referencedElement instanceof PyStringLiteralExpression) {
                String string = ((PyStringLiteralExpression)referencedElement).getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
                if (HuggingFaceUtil.INSTANCE.isHuggingFaceEntity(string)) {
                    documentationTargets.add(new HuggingFaceDocumentationTarget(element));
                }
            }
        } else if (psiElement instanceof HuggingFaceIdentifierPsiElement) {
            documentationTargets.add(new HuggingFaceDocumentationTarget(element));
        } else if (psiElement instanceof PyStringLiteralExpression) {
            String string = ((PyStringLiteralExpression)element).getStringValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
            if (HuggingFaceUtil.INSTANCE.isHuggingFaceEntity(string)) {
                documentationTargets.add(new HuggingFaceDocumentationTarget(element));
            }
        }
        return documentationTargets;
    }

    @Nullable
    public DocumentationTarget documentationTarget(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<DocumentationTarget> targets = this.documentationTargets(element, originalElement);
        return (DocumentationTarget)CollectionsKt.firstOrNull(targets);
    }
}

