/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.terminal.TerminalColorPalette;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0014R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ui/BlockTerminalColorPalette;", "Lcom/intellij/terminal/TerminalColorPalette;", "()V", "colorKeys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getColorsScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "defaultBackground", "Lcom/jediterm/core/Color;", "getDefaultBackground", "()Lcom/jediterm/core/Color;", "defaultForeground", "getDefaultForeground", "getAnsiColorKey", "value", "", "getAttributesByColorIndex", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "index", "intellij.terminal"})
public final class BlockTerminalColorPalette
extends TerminalColorPalette {
    @NotNull
    private final TextAttributesKey[] colorKeys = BlockTerminalColors.INSTANCE.getKEYS();

    private final EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return editorColorsScheme;
    }

    @NotNull
    public com.jediterm.core.Color getDefaultForeground() {
        Color foregroundColor = this.getColorsScheme().getColor(BlockTerminalColors.DEFAULT_FOREGROUND);
        Color color = foregroundColor;
        if (color == null) {
            Color color2 = this.getColorsScheme().getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @NotNull
    public com.jediterm.core.Color getDefaultBackground() {
        Color backgroundColor = this.getColorsScheme().getColor(BlockTerminalColors.DEFAULT_BACKGROUND);
        Color color = backgroundColor;
        if (color == null) {
            Color color2 = this.getColorsScheme().getDefaultBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        }
        com.jediterm.core.Color color3 = AwtTransformers.fromAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    @Nullable
    protected TextAttributes getAttributesByColorIndex(int index) {
        TextAttributesKey textAttributesKey = this.getAnsiColorKey(index);
        if (textAttributesKey == null) {
            return null;
        }
        TextAttributesKey key = textAttributesKey;
        return this.getColorsScheme().getAttributes(key);
    }

    private final TextAttributesKey getAnsiColorKey(int value) {
        return (0 <= value ? value < this.colorKeys.length : false) ? this.colorKeys[value] : null;
    }
}

