/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion.powershell;

import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.completion.DataProviderCommand;
import org.jetbrains.plugins.terminal.exp.completion.powershell.CompletionResult;
import org.jetbrains.plugins.terminal.exp.completion.powershell.GetShellCompletionsCommand;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/powershell/GetShellCompletionsCommand;", "Lorg/jetbrains/plugins/terminal/exp/completion/DataProviderCommand;", "Lorg/jetbrains/plugins/terminal/exp/completion/powershell/CompletionResult;", "command", "", "caretPosition", "", "(Ljava/lang/String;I)V", "defaultResult", "getDefaultResult", "()Lorg/jetbrains/plugins/terminal/exp/completion/powershell/CompletionResult;", "functionName", "getFunctionName", "()Ljava/lang/String;", "parameters", "", "getParameters", "()Ljava/util/List;", "isAvailable", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "parseResult", "result", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nGetShellCompletionsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetShellCompletionsCommand.kt\norg/jetbrains/plugins/terminal/exp/completion/powershell/GetShellCompletionsCommand\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n96#2:100\n11#3:101\n*S KotlinDebug\n*F\n+ 1 GetShellCompletionsCommand.kt\norg/jetbrains/plugins/terminal/exp/completion/powershell/GetShellCompletionsCommand\n*L\n34#1:100\n44#1:101\n*E\n"})
public final class GetShellCompletionsCommand
implements DataProviderCommand<CompletionResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String functionName;
    @NotNull
    private final List<String> parameters;
    @Nullable
    private final CompletionResult defaultResult;
    @NotNull
    private static final Logger LOG;

    public GetShellCompletionsCommand(@NotNull String command, int caretPosition) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.functionName = "__JetBrainsIntellijGetCompletions";
        Object[] objectArray = new String[]{command, String.valueOf(caretPosition)};
        this.parameters = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public CompletionResult getDefaultResult() {
        return this.defaultResult;
    }

    @Override
    public boolean isAvailable(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return session2.getShellIntegration().getShellType() == ShellType.POWERSHELL;
    }

    @Override
    @Nullable
    public CompletionResult parseResult(@NotNull String result2) {
        CompletionResult completionResult2;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (((CharSequence)result2).length() == 0) {
            return null;
        }
        Json json2 = JsonKt.Json$default(null, (Function1)parseResult.json.1.INSTANCE, (int)1, null);
        try {
            Json this_$iv = json2;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            completionResult2 = (CompletionResult)this_$iv.decodeFromString((DeserializationStrategy)CompletionResult.Companion.serializer(), result2);
        }
        catch (Throwable t) {
            LOG.error("Failed to parse completions: " + result2, t);
            return null;
        }
        CompletionResult completionResult3 = completionResult2;
        return completionResult3;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GetShellCompletionsCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/powershell/GetShellCompletionsCommand$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

