/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"NEW_TERMINAL_OUTPUT_CAPACITY_KB", "", "buildAndSortHighlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,343:1\n1045#2:344\n11#3:345\n11#3:346\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModelKt\n*L\n297#1:344\n303#1:345\n306#1:346\n*E\n"})
public final class TerminalOutputModelKt {
    @NotNull
    public static final String NEW_TERMINAL_OUTPUT_CAPACITY_KB = "new.terminal.output.capacity.kb";

    private static final List<HighlightingInfo> buildAndSortHighlightings(Document document, List<HighlightingInfo> highlightings) {
        Iterable $this$sortedBy$iv = highlightings;
        boolean $i$f$sortedBy = false;
        List sortedHighlightings = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HighlightingInfo it = (HighlightingInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (HighlightingInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        int documentLength = document.getTextLength();
        List result2 = new ArrayList(sortedHighlightings.size() * 2 + 1);
        int startOffset = 0;
        for (HighlightingInfo highlighting : sortedHighlightings) {
            boolean $i$f$logger;
            if (highlighting.getStartOffset() < 0 || highlighting.getEndOffset() > documentLength) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings range should be within document");
            }
            if (startOffset > highlighting.getStartOffset()) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings should not overlap");
            }
            if (startOffset < highlighting.getStartOffset()) {
                result2.add(new HighlightingInfo(startOffset, highlighting.getStartOffset(), EmptyTextAttributesProvider.INSTANCE));
            }
            result2.add(highlighting);
            startOffset = highlighting.getEndOffset();
        }
        if (startOffset < documentLength) {
            result2.add(new HighlightingInfo(startOffset, documentLength, EmptyTextAttributesProvider.INSTANCE));
        }
        return result2;
    }

    public static final /* synthetic */ List access$buildAndSortHighlightings(Document document, List highlightings) {
        return TerminalOutputModelKt.buildAndSortHighlightings(document, highlightings);
    }
}

