/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J+\u0010'\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00122\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\fH\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0011\u0010\"\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;Lcom/intellij/openapi/editor/RangeMarker;)V", "getCommand", "()Ljava/lang/String;", "commandStartOffset", "", "getCommandStartOffset", "()I", "endOffset", "getEndOffset", "isFinalized", "", "()Z", "outputStartOffset", "getOutputStartOffset", "getPrompt", "()Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "getRange", "()Lcom/intellij/openapi/editor/RangeMarker;", "startOffset", "getStartOffset", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "withCommand", "getWithCommand", "withPrompt", "getWithPrompt", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "intellij.terminal"})
public final class CommandBlock {
    @Nullable
    private final String command;
    @Nullable
    private final PromptRenderingInfo prompt;
    @NotNull
    private final RangeMarker range;
    private final boolean withPrompt;
    private final boolean withCommand;

    public CommandBlock(@Nullable String command, @Nullable PromptRenderingInfo prompt, @NotNull RangeMarker range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.command = command;
        this.prompt = prompt;
        this.range = range;
        PromptRenderingInfo promptRenderingInfo = this.prompt;
        CharSequence charSequence = promptRenderingInfo != null ? promptRenderingInfo.getText() : null;
        this.withPrompt = !(charSequence == null || charSequence.length() == 0);
        charSequence = this.command;
        this.withCommand = !(charSequence == null || charSequence.length() == 0);
    }

    @Nullable
    public final String getCommand() {
        return this.command;
    }

    @Nullable
    public final PromptRenderingInfo getPrompt() {
        return this.prompt;
    }

    @NotNull
    public final RangeMarker getRange() {
        return this.range;
    }

    public final int getStartOffset() {
        return this.range.getStartOffset();
    }

    public final int getEndOffset() {
        return this.range.getEndOffset();
    }

    public final int getCommandStartOffset() {
        int n;
        int n2 = this.range.getStartOffset();
        if (this.withPrompt) {
            PromptRenderingInfo promptRenderingInfo = this.prompt;
            Intrinsics.checkNotNull((Object)promptRenderingInfo);
            n = promptRenderingInfo.getText().length() + 1;
        } else {
            n = 0;
        }
        return n2 + n;
    }

    public final int getOutputStartOffset() {
        int n;
        int n2 = this.getCommandStartOffset();
        if (this.withCommand) {
            String string = this.command;
            Intrinsics.checkNotNull((Object)string);
            n = string.length() + 1;
        } else {
            n = 0;
        }
        return n2 + n;
    }

    @NotNull
    public final TextRange getTextRange() {
        TextRange textRange = this.range.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    public final boolean getWithPrompt() {
        return this.withPrompt;
    }

    public final boolean getWithCommand() {
        return this.withCommand;
    }

    public final boolean isFinalized() {
        return !this.range.isGreedyToRight();
    }

    @Nullable
    public final String component1() {
        return this.command;
    }

    @Nullable
    public final PromptRenderingInfo component2() {
        return this.prompt;
    }

    @NotNull
    public final RangeMarker component3() {
        return this.range;
    }

    @NotNull
    public final CommandBlock copy(@Nullable String command, @Nullable PromptRenderingInfo prompt, @NotNull RangeMarker range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new CommandBlock(command, prompt, range);
    }

    public static /* synthetic */ CommandBlock copy$default(CommandBlock commandBlock, String string, PromptRenderingInfo promptRenderingInfo, RangeMarker rangeMarker, int n, Object object) {
        if ((n & 1) != 0) {
            string = commandBlock.command;
        }
        if ((n & 2) != 0) {
            promptRenderingInfo = commandBlock.prompt;
        }
        if ((n & 4) != 0) {
            rangeMarker = commandBlock.range;
        }
        return commandBlock.copy(string, promptRenderingInfo, rangeMarker);
    }

    @NotNull
    public String toString() {
        return "CommandBlock(command=" + this.command + ", prompt=" + this.prompt + ", range=" + this.range + ")";
    }

    public int hashCode() {
        int result2 = this.command == null ? 0 : this.command.hashCode();
        result2 = result2 * 31 + (this.prompt == null ? 0 : this.prompt.hashCode());
        result2 = result2 * 31 + this.range.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandBlock)) {
            return false;
        }
        CommandBlock commandBlock = (CommandBlock)other;
        if (!Intrinsics.areEqual((Object)this.command, (Object)commandBlock.command)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prompt, (Object)commandBlock.prompt)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.range, (Object)commandBlock.range);
    }
}

