/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.pty.PtyProcessTtyConnector;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import com.pty4j.unix.UnixPtyProcess;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.shell_integration.CommandBlockIntegration;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellType;
import org.jetbrains.plugins.terminal.util.TerminalEnvironment;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    private static final String ZDOTDIR = "ZDOTDIR";
    private static final String IJ_ZSH_DIR = "JETBRAINS_INTELLIJ_ZSH_DIR";
    private static final String IJ_COMMAND_END_MARKER = "JETBRAINS_INTELLIJ_COMMAND_END_MARKER";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final String LOGIN_CLI_OPTION = "--login";
    private static final List<String> LOGIN_CLI_OPTIONS = List.of("--login", "-l");
    private static final String INTERACTIVE_CLI_OPTION = "-i";
    private static final String BASH_NAME = "bash";
    private static final String SH_NAME = "sh";
    private static final String ZSH_NAME = "zsh";
    private static final String FISH_NAME = "fish";
    protected final Charset myDefaultCharset;
    private final ThreadLocal<ShellStartupOptions> myStartupOptionsThreadLocal = new ThreadLocal();

    public LocalTerminalDirectRunner(Project project) {
        super(project);
        this.myDefaultCharset = StandardCharsets.UTF_8;
    }

    @Nullable
    private static String findRCFile(@NotNull String shellName) {
        String rcfile;
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        switch (shellName) {
            case "bash": 
            case "sh": {
                String string = "shell-integrations/bash/bash-integration.bash";
                break;
            }
            case "zsh": {
                String string = "shell-integrations/zsh/.zshenv";
                break;
            }
            case "fish": {
                String string = "shell-integrations/fish/fish-integration.fish";
                break;
            }
            default: {
                String string = rcfile = null;
            }
        }
        if (rcfile == null && LocalTerminalDirectRunner.isPowerShell(shellName)) {
            rcfile = "shell-integrations/powershell/powershell-integration.ps1";
        }
        if (rcfile != null) {
            try {
                return LocalTerminalDirectRunner.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean isPowerShell(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        return shellName.equalsIgnoreCase("powershell") || shellName.equalsIgnoreCase("powershell.exe") || shellName.equalsIgnoreCase("pwsh") || shellName.equalsIgnoreCase("pwsh.exe");
    }

    @NotNull
    private static String findAbsolutePath(@NotNull String relativePath) throws IOException {
        File result2;
        Object jarPath;
        if (relativePath == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        if (((String)(jarPath = PathUtil.getJarPathForClass(LocalTerminalDirectRunner.class))).endsWith(".jar")) {
            File jarFile = new File((String)jarPath);
            if (!jarFile.isFile()) {
                throw new IOException("Broken installation: " + (String)jarPath + " is not a file");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            result2 = new File(pluginBaseDir, relativePath);
        } else {
            String srcDir;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isInternal() && new File(srcDir = ((String)(jarPath = StringUtil.trimEnd((String)((String)jarPath).replace('\\', '/'), (char)'/') + "/")).replace("/out/classes/production/intellij.terminal/", "/community/plugins/terminal/resources/")).isDirectory()) {
                jarPath = srcDir;
            }
            result2 = new File((String)jarPath, relativePath);
        }
        if (!result2.isFile()) {
            throw new IOException("Cannot find " + relativePath + ": " + result2.getAbsolutePath() + " is not a file");
        }
        String string = result2.getAbsolutePath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    @NotNull
    private Map<String, String> getTerminalEnvironment(@NotNull Map<String, String> baseEnvs, @NotNull String workingDir) {
        if (baseEnvs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(4);
        }
        if (workingDir == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(5);
        }
        Map envs = SystemInfo.isWindows ? CollectionFactory.createCaseInsensitiveStringMap() : new HashMap();
        EnvironmentVariablesData envData = TerminalProjectOptionsProvider.getInstance(this.myProject).getEnvData();
        if (envData.isPassParentEnvs()) {
            envs.putAll(System.getenv());
            EnvironmentRestorer.restoreOverriddenVars((Map)envs);
        } else {
            LOG.info("No parent environment passed");
        }
        envs.putAll(baseEnvs);
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        envs.put("TERM_SESSION_ID", UUID.randomUUID().toString());
        TerminalEnvironment.INSTANCE.setCharacterEncoding(envs);
        if (TrustedProjects.isTrusted((Project)this.myProject)) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
            for (Map.Entry env : envData.getEnvs().entrySet()) {
                envs.put((String)env.getKey(), macroManager.expandPath((String)env.getValue()));
            }
            if (WslPath.isWslUncPath((String)workingDir)) {
                LocalTerminalDirectRunner.setupWslEnv(envData.getEnvs(), envs);
            }
        }
        Map map2 = envs;
        if (map2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(6);
        }
        return map2;
    }

    private static void setupWslEnv(@NotNull Map<String, String> userEnvs, @NotNull Map<String, String> resultEnvs) {
        String wslEnv;
        if (userEnvs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(7);
        }
        if (resultEnvs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(8);
        }
        if ((wslEnv = userEnvs.keySet().stream().map(name -> name + "/u").collect(Collectors.joining(":"))).isEmpty()) {
            return;
        }
        String prevValue = userEnvs.get("WSLENV");
        if (prevValue == null) {
            prevValue = System.getenv("WSLENV");
        }
        String newWslEnv = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ":" + wslEnv : wslEnv;
        resultEnvs.put("WSLENV", newWslEnv);
    }

    @Override
    @NotNull
    public ShellStartupOptions configureStartupOptions(@NotNull ShellStartupOptions baseOptions) {
        if (baseOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(9);
        }
        String workingDir = this.getWorkingDirectory(baseOptions.getWorkingDirectory());
        Map<String, String> envs = this.getTerminalEnvironment(baseOptions.getEnvVariables(), workingDir);
        List<String> initialCommand = this.doGetInitialCommand(baseOptions, envs);
        TerminalWidget widget = baseOptions.getWidget();
        if (widget != null) {
            widget.setShellCommand(initialCommand);
        }
        ShellStartupOptions updatedOptions = baseOptions.builder().shellCommand(initialCommand).workingDirectory(workingDir).envVariables(envs).build();
        if (this.enableShellIntegration()) {
            updatedOptions = this.injectShellIntegration(updatedOptions);
        }
        return this.applyTerminalCustomizers(updatedOptions);
    }

    @NotNull
    private ShellStartupOptions applyTerminalCustomizers(@NotNull ShellStartupOptions options) {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(10);
        }
        String[] command = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command = customizer.customizeCommandAndEnvironment(this.myProject, options.getWorkingDirectory(), command, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        ShellStartupOptions shellStartupOptions2 = options.builder().shellCommand(Arrays.asList(command)).envVariables(envs).build();
        if (shellStartupOptions2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(11);
        }
        return shellStartupOptions2;
    }

    @Override
    @NotNull
    public PtyProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        PtyProcess ptyProcess;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(12);
        }
        String[] command = ArrayUtil.toStringArray(options.getShellCommand());
        Map<String, String> envs = options.getEnvVariables();
        TermSize initialTermSize = options.getInitialTermSize();
        String workingDir = options.getWorkingDirectory();
        if (workingDir == null) {
            throw new IllegalStateException("Working directory must not be null, startup options: " + options);
        }
        ShellIntegration shellIntegration = options.getShellIntegration();
        boolean isBlockTerminal = this.isBlockTerminalEnabled() && shellIntegration != null && shellIntegration.getCommandBlockIntegration() != null;
        TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, command, isBlockTerminal);
        try {
            long startNano = System.nanoTime();
            PtyProcessBuilder builder = new PtyProcessBuilder(command).setEnvironment(envs).setDirectory(workingDir).setInitialColumns(initialTermSize != null ? Integer.valueOf(initialTermSize.getColumns()) : null).setInitialRows(initialTermSize != null ? Integer.valueOf(initialTermSize.getRows()) : null).setUseWinConPty(LocalPtyOptions.shouldUseWinConPty());
            PtyProcess process = builder.start();
            LOG.info("Started " + process.getClass().getName() + " in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms from " + LocalTerminalDirectRunner.stringifyProcessInfo(command, workingDir, initialTermSize, envs, !LOG.isDebugEnabled()));
            ptyProcess = process;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to start " + LocalTerminalDirectRunner.stringifyProcessInfo(command, workingDir, initialTermSize, envs, false), e);
        }
        if (ptyProcess == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(13);
        }
        return ptyProcess;
    }

    @Nullable
    private static ShellTerminalWidget getShellTerminalWidget(@Nullable ShellStartupOptions options) {
        TerminalWidget widget = options != null ? options.getWidget() : null;
        return widget != null ? ShellTerminalWidget.asShellJediTermWidget(widget) : null;
    }

    protected boolean enableShellIntegration() {
        return TerminalOptionsProvider.getInstance().getShellIntegration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> doGetInitialCommand(@NotNull ShellStartupOptions options, @NotNull Map<String, String> envs) {
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(14);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(15);
        }
        this.myStartupOptionsThreadLocal.set(options);
        List<String> list = this.getInitialCommand(envs);
        List<String> list2 = list;
        if (list2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(16);
        }
        return list2;
        finally {
            this.myStartupOptionsThreadLocal.remove();
        }
    }

    @NotNull
    public static List<String> convertShellPathToCommand(@NotNull String shellPath2) {
        ArrayList<String> shellCommand2;
        String shellExe;
        if (shellPath2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(17);
        }
        if ((shellExe = (String)ContainerUtil.getFirstItem(shellCommand2 = LocalTerminalDirectRunner.isAbsoluteFilePathAndExists(shellPath2) ? List.of(shellPath2) : ParametersListUtil.parse((String)shellPath2, (boolean)false, (!SystemInfo.isWindows ? 1 : 0) != 0))) == null) {
            ArrayList<String> arrayList = shellCommand2;
            if (arrayList == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        String shellName = PathUtil.getFileName((String)shellExe);
        if (!LocalTerminalDirectRunner.containsLoginOrInteractiveOption((List<String>)shellCommand2)) {
            shellCommand2 = new ArrayList<String>(shellCommand2);
            if (LocalTerminalDirectRunner.isLoginOptionAvailable(shellName) && SystemInfo.isMac) {
                shellCommand2.add(LOGIN_CLI_OPTION);
            }
            if (LocalTerminalDirectRunner.isInteractiveOptionAvailable(shellName)) {
                shellCommand2.add(INTERACTIVE_CLI_OPTION);
            }
        }
        List<String> list = List.copyOf(shellCommand2);
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static boolean isAbsoluteFilePathAndExists(@NotNull String path) {
        File file;
        if (path == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(20);
        }
        return (file = new File(path)).isAbsolute() && file.isFile();
    }

    @NotNull
    private static String stringifyProcessInfo(String @NotNull [] command, @NotNull String workingDirectory, @Nullable TermSize initialTermSize, @NotNull Map<String, String> environment, boolean envDiff) {
        if (workingDirectory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(21);
        }
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(22);
        }
        if (command == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(23);
        }
        String info = Arrays.toString(command) + " in " + workingDirectory + (LocalTerminalDirectRunner.isDirectory(workingDirectory) ? "" : " [no such directory]") + ", [" + initialTermSize + "]";
        if (envDiff) {
            String string = info + ", diff_envs=" + LocalTerminalDirectRunner.getEnvironmentDiff(environment, System.getenv());
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = info + ", envs=" + environment;
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getEnvironmentDiff(@NotNull Map<String, String> environment, @NotNull Map<String, String> baseEnvironment) {
        if (environment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(26);
        }
        if (baseEnvironment == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(27);
        }
        Map map2 = environment.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> Objects.equals(entry.getValue(), baseEnvironment.get(entry.getKey())) ? null : entry).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        if (map2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(28);
        }
        return map2;
    }

    @NotNull
    private String getWorkingDirectory(@Nullable String directory) {
        if (directory != null && LocalTerminalDirectRunner.isDirectory(directory)) {
            String string = directory;
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(29);
            }
            return string;
        }
        String configuredWorkingDirectory = TerminalProjectOptionsProvider.getInstance(this.myProject).getStartingDirectory();
        if (configuredWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(configuredWorkingDirectory)) {
            String string = configuredWorkingDirectory;
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(30);
            }
            return string;
        }
        String defaultWorkingDirectory = TerminalProjectOptionsProvider.getInstance(this.myProject).getDefaultStartingDirectory();
        if (defaultWorkingDirectory != null && LocalTerminalDirectRunner.isDirectory(defaultWorkingDirectory)) {
            String string = defaultWorkingDirectory;
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(31);
            }
            return string;
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (projectDir != null) {
            String string = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir).getAbsolutePath();
            if (string == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = SystemProperties.getUserHome();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static boolean isDirectory(@NotNull String directory) {
        if (directory == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(34);
        }
        try {
            boolean ok = Files.isDirectory(Path.of(directory, new String[0]), new LinkOption[0]);
            if (!ok) {
                LOG.info("Cannot start local terminal in " + directory + ": no such directory");
            }
            return ok;
        }
        catch (InvalidPathException e) {
            LOG.info("Cannot start local terminal in " + directory + ": invalid path", (Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public TtyConnector createTtyConnector(final @NotNull PtyProcess process) {
        if (process == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(35);
        }
        return new PtyProcessTtyConnector(process, this.myDefaultCharset){

            public void close() {
                if (process instanceof UnixPtyProcess) {
                    ((UnixPtyProcess)process).hangup();
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                        if (process.isAlive()) {
                            LOG.info("Terminal hasn't been terminated by SIGHUP, performing default termination");
                            process.destroy();
                        }
                    }, 1000L, TimeUnit.MILLISECONDS);
                } else {
                    process.destroy();
                }
            }

            public void resize(@NotNull TermSize termSize) {
                if (termSize == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resize to " + termSize);
                }
                super.resize(termSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termSize", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$1", "resize"));
            }
        };
    }

    @Override
    @NotNull
    public String getDefaultTabTitle() {
        String string = TerminalOptionsProvider.getInstance().getTabName();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
        ShellStartupOptions startupOptions;
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(37);
        }
        List<String> shellCommand2 = (startupOptions = this.myStartupOptionsThreadLocal.get()) != null ? startupOptions.getShellCommand() : null;
        return shellCommand2 != null ? shellCommand2 : LocalTerminalDirectRunner.convertShellPathToCommand(this.getShellPath());
    }

    @ApiStatus.Internal
    protected boolean isBlockTerminalEnabled() {
        return false;
    }

    @NotNull
    private String getShellPath() {
        String string = TerminalProjectOptionsProvider.getInstance(this.myProject).getShellPath();
        if (string == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public List<String> getCommand(@NotNull String shellPath2, @NotNull Map<String, String> envs, boolean shellIntegration) {
        if (shellPath2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(39);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(40);
        }
        List<String> command = LocalTerminalDirectRunner.convertShellPathToCommand(shellPath2);
        if (shellIntegration) {
            ShellStartupOptions options = this.injectShellIntegration(command, envs);
            List<String> list = Objects.requireNonNull(options.getShellCommand());
            if (list == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(41);
            }
            return list;
        }
        List<String> list = command;
        if (list == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    ShellStartupOptions injectShellIntegration(@NotNull List<String> shellCommand2, @NotNull Map<String, String> envs) {
        if (shellCommand2 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(43);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(44);
        }
        ShellStartupOptions options = new ShellStartupOptions.Builder().shellCommand(shellCommand2).envVariables(envs).build();
        return this.injectShellIntegration(options);
    }

    @NotNull
    private ShellStartupOptions injectShellIntegration(@NotNull ShellStartupOptions options) {
        String commandEndMarker;
        if (options == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(45);
        }
        List<String> shellCommand2 = options.getShellCommand();
        String shellExe = (String)ContainerUtil.getFirstItem(shellCommand2);
        if (shellCommand2 == null || shellExe == null) {
            ShellStartupOptions shellStartupOptions2 = options;
            if (shellStartupOptions2 == null) {
                LocalTerminalDirectRunner.$$$reportNull$$$0(46);
            }
            return shellStartupOptions2;
        }
        ArrayList<String> arguments = new ArrayList<String>(shellCommand2.subList(1, shellCommand2.size()));
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        ShellIntegration integration = null;
        ArrayList<String> resultCommand = new ArrayList<String>();
        resultCommand.add(shellExe);
        String shellName = PathUtil.getFileName((String)shellExe);
        String rcFilePath = LocalTerminalDirectRunner.findRCFile(shellName);
        if (rcFilePath != null) {
            boolean isBlockTerminal = LocalTerminalDirectRunner.isBlockTerminalSupported(shellName);
            if (shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME)) {
                LocalTerminalDirectRunner.addRcFileArgument(envs, arguments, resultCommand, rcFilePath, "--rcfile");
                boolean loginShell = arguments.removeAll(LOGIN_CLI_OPTIONS);
                LocalTerminalDirectRunner.setLoginShellEnv(envs, loginShell);
                LocalTerminalDirectRunner.setCommandHistoryFile(options, envs);
                integration = new ShellIntegration(ShellType.BASH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (shellName.equals(ZSH_NAME)) {
                String zdotdir = envs.get(ZDOTDIR);
                if (StringUtil.isNotEmpty((String)zdotdir)) {
                    envs.put("_INTELLIJ_ORIGINAL_ZDOTDIR", zdotdir);
                }
                String zshDir = PathUtil.getParentPath((String)rcFilePath);
                envs.put(ZDOTDIR, zshDir);
                envs.put(IJ_ZSH_DIR, zshDir);
                integration = new ShellIntegration(ShellType.ZSH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (shellName.equals(FISH_NAME)) {
                resultCommand.add("--init-command=source " + CommandLineUtil.posixQuote((String)rcFilePath));
                integration = new ShellIntegration(ShellType.FISH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (LocalTerminalDirectRunner.isPowerShell(shellName)) {
                resultCommand.addAll(arguments);
                arguments.clear();
                resultCommand.addAll(List.of("-NoExit", "-ExecutionPolicy", "Bypass", "-File", rcFilePath));
                integration = new ShellIntegration(ShellType.POWERSHELL, isBlockTerminal ? new CommandBlockIntegration(true) : null);
            }
        }
        if (this.isBlockTerminalEnabled() && integration != null && integration.getCommandBlockIntegration() != null) {
            envs.put("INTELLIJ_TERMINAL_COMMAND_BLOCKS", "1");
            envs.put("FIG_TERM", "1");
        }
        CommandBlockIntegration commandIntegration = integration != null ? integration.getCommandBlockIntegration() : null;
        String string = commandEndMarker = commandIntegration != null ? commandIntegration.getCommandEndMarker() : null;
        if (commandEndMarker != null) {
            envs.put(IJ_COMMAND_END_MARKER, commandEndMarker);
        }
        resultCommand.addAll(arguments);
        ShellStartupOptions shellStartupOptions3 = options.builder().shellCommand(resultCommand).envVariables(envs).shellIntegration(integration).build();
        if (shellStartupOptions3 == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(47);
        }
        return shellStartupOptions3;
    }

    private static void setCommandHistoryFile(@NotNull ShellStartupOptions startupOptions, @NotNull Map<String, String> envs) {
        Function0<Path> commandHistoryFileProvider;
        Path commandHistoryFile;
        if (startupOptions == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(48);
        }
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(49);
        }
        Path path = commandHistoryFile = (commandHistoryFileProvider = startupOptions.getCommandHistoryFileProvider()) != null ? (Path)commandHistoryFileProvider.invoke() : null;
        if (commandHistoryFile != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFile.toString());
            ShellTerminalWidget widget = LocalTerminalDirectRunner.getShellTerminalWidget(startupOptions);
            if (widget != null) {
                widget.setCommandHistoryFilePath(commandHistoryFile.toString());
            }
        }
    }

    @ApiStatus.Internal
    public static boolean isBlockTerminalSupported(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(50);
        }
        if (LocalTerminalDirectRunner.isPowerShell(shellName)) {
            return SystemInfo.isWin11OrNewer && Registry.is((String)"terminal.new.ui.powershell.win11", (boolean)false) || SystemInfo.isWin10OrNewer && !SystemInfo.isWin11OrNewer && Registry.is((String)"terminal.new.ui.powershell.win10", (boolean)false);
        }
        return shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME) || shellName.equals(ZSH_NAME) || shellName.equals(FISH_NAME) && Registry.is((String)"terminal.new.ui.fish", (boolean)false);
    }

    private static boolean isLoginOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(51);
        }
        return LocalTerminalDirectRunner.isBashZshFish(shellName);
    }

    private static boolean isInteractiveOptionAvailable(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(52);
        }
        return LocalTerminalDirectRunner.isBashZshFish(shellName);
    }

    private static boolean isBashZshFish(@NotNull String shellName) {
        if (shellName == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(53);
        }
        return shellName.equals(BASH_NAME) || SystemInfo.isMac && shellName.equals(SH_NAME) || shellName.equals(ZSH_NAME) || shellName.equals(FISH_NAME);
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (envs == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(54);
        }
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> arguments, List<String> result2, String rcFilePath, String rcfileOption) {
        result2.add(rcfileOption);
        result2.add(rcFilePath);
        int idx = arguments.indexOf(rcfileOption);
        if (idx >= 0) {
            arguments.remove(idx);
            if (idx < arguments.size()) {
                String userRcFile = FileUtil.expandUserHome((String)arguments.get(idx));
                if (!userRcFile.equals(rcFilePath)) {
                    envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)arguments.get(idx)));
                }
                arguments.remove(idx);
            }
        }
    }

    private static boolean containsLoginOrInteractiveOption(List<String> command) {
        return LocalTerminalDirectRunner.isLogin(command) || command.contains(INTERACTIVE_CLI_OPTION);
    }

    private static boolean isLogin(@NotNull List<String> command) {
        if (command == null) {
            LocalTerminalDirectRunner.$$$reportNull$$$0(55);
        }
        return ContainerUtil.exists(command, LOGIN_CLI_OPTIONS::contains);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 11, 13, 16, 18, 19, 24, 25, 28, 29, 30, 31, 32, 33, 36, 38, 41, 42, 46, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userEnvs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultEnvs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 17: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 23: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseEnvironment";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellCommand";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAbsolutePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalEnvironment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTerminalCustomizers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetInitialCommand";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "convertShellPathToCommand";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyProcessInfo";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentDiff";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTabTitle";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findRCFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPowerShell";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAbsolutePath";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 42: 
            case 46: 
            case 47: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTerminalEnvironment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupWslEnv";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupOptions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyTerminalCustomizers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetInitialCommand";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertShellPathToCommand";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAbsoluteFilePathAndExists";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stringifyProcessInfo";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentDiff";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createTtyConnector";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInitialCommand";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setCommandHistoryFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isBlockTerminalSupported";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isLoginOptionAvailable";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isInteractiveOptionAvailable";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isBashZshFish";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setLoginShellEnv";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isLogin";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 11, 13, 16, 18, 19, 24, 25, 28, 29, 30, 31, 32, 33, 36, 38, 41, 42, 46, 47 -> new IllegalStateException(string);
        };
    }
}

