/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.ExperimentalUI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.exp.TerminalWidgetImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/LocalBlockTerminalRunner;", "Lorg/jetbrains/plugins/terminal/LocalTerminalDirectRunner;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createShellTerminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "parent", "Lcom/intellij/openapi/Disposable;", "startupOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "isBlockTerminalEnabled", "", "shouldShowPromotion", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@ApiStatus.Experimental
public class LocalBlockTerminalRunner
extends LocalTerminalDirectRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BLOCK_TERMINAL_REGISTRY = "terminal.new.ui";
    @NotNull
    public static final String BLOCK_TERMINAL_FISH_REGISTRY = "terminal.new.ui.fish";
    @NotNull
    public static final String BLOCK_TERMINAL_POWERSHELL_WIN11_REGISTRY = "terminal.new.ui.powershell.win11";
    @NotNull
    public static final String BLOCK_TERMINAL_POWERSHELL_WIN10_REGISTRY = "terminal.new.ui.powershell.win10";
    @NotNull
    private static final String BLOCK_TERMINAL_SHOW_PROMOTION = "terminal.new.ui.show.promotion";

    public LocalBlockTerminalRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    protected boolean isBlockTerminalEnabled() {
        return (ExperimentalUI.Companion.isNewUI() || ApplicationManager.getApplication().isUnitTestMode()) && Registry.is((String)BLOCK_TERMINAL_REGISTRY, (boolean)false);
    }

    @Override
    @NotNull
    protected TerminalWidget createShellTerminalWidget(@NotNull Disposable parent, @NotNull ShellStartupOptions startupOptions) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        if (this.isBlockTerminalEnabled()) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            JBTerminalSystemSettingsProvider jBTerminalSystemSettingsProvider = this.getSettingsProvider();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jBTerminalSystemSettingsProvider), (String)"getSettingsProvider(...)");
            return new TerminalWidgetImpl(project, jBTerminalSystemSettingsProvider, parent);
        }
        TerminalWidget terminalWidget = super.createShellTerminalWidget(parent, startupOptions);
        Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"createShellTerminalWidget(...)");
        return terminalWidget;
    }

    public boolean shouldShowPromotion() {
        return ExperimentalUI.Companion.isNewUI() && Registry.is((String)BLOCK_TERMINAL_SHOW_PROMOTION, (boolean)false) && !Registry.is((String)BLOCK_TERMINAL_REGISTRY, (boolean)false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/LocalBlockTerminalRunner$Companion;", "", "()V", "BLOCK_TERMINAL_FISH_REGISTRY", "", "BLOCK_TERMINAL_POWERSHELL_WIN10_REGISTRY", "BLOCK_TERMINAL_POWERSHELL_WIN11_REGISTRY", "BLOCK_TERMINAL_REGISTRY", "BLOCK_TERMINAL_SHOW_PROMOTION", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

