/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0018\u0012\u0011\u0010\u0003\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u001cH\u0016J2\u0010\u001d\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0017H\u0002J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006!"}, d2={"Lgit4idea/actions/branch/GitSingleBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "dynamicText", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "(Ljava/util/function/Supplier;)V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "disabledForLocal", "getDisabledForLocal", "disabledForRemote", "getDisabledForRemote", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabledAndVisible", "branches", "update", "updateIfEnabledAndVisible", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSingleBranchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSingleBranchAction.kt\ngit4idea/actions/branch/GitSingleBranchAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1747#2,3:78\n*S KotlinDebug\n*F\n+ 1 GitSingleBranchAction.kt\ngit4idea/actions/branch/GitSingleBranchAction\n*L\n58#1:78,3\n*E\n"})
public abstract class GitSingleBranchAction
extends DumbAwareAction {
    private final boolean disabledForLocal;
    private final boolean disabledForRemote;
    private final boolean disabledForCurrent;

    public GitSingleBranchAction(@NotNull Supplier<String> dynamicText) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        super(dynamicText);
    }

    public GitSingleBranchAction() {
        Supplier supplier = Presentation.NULL_STRING;
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"NULL_STRING");
        this(supplier);
    }

    public boolean getDisabledForLocal() {
        return this.disabledForLocal;
    }

    public boolean getDisabledForRemote() {
        return this.disabledForRemote;
    }

    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        List<GitRepository> repositories2 = GitBranchActionsUtil.getAffectedRepositories(e);
        List branches2 = (List)e.getData(GitBranchActionsUtil.BRANCHES_KEY);
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(project, repositories2, branches2));
        DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, repositories2, (String)GitBundle.message("action.not.possible.in.fresh.repo.generic", new Object[0]));
        if (e.getPresentation().isEnabledAndVisible()) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            List list2 = branches2;
            Intrinsics.checkNotNull((Object)list2);
            this.updateIfEnabledAndVisible(e, project2, repositories2, (GitBranch)CollectionsKt.single((List)list2));
        }
    }

    private final boolean isEnabledAndVisible(Project project, List<? extends GitRepository> repositories2, List<? extends GitBranch> branches2) {
        if (project == null) {
            return false;
        }
        Collection collection = repositories2;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        collection = branches2;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        if (branches2.size() != 1) {
            return false;
        }
        GitBranch branch = (GitBranch)CollectionsKt.single(branches2);
        if (this.getDisabledForLocal() && !branch.isRemote()) {
            return false;
        }
        if (this.getDisabledForRemote() && branch.isRemote()) {
            return false;
        }
        if (this.getDisabledForCurrent()) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = repositories2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)branch)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List list2 = (List)e.getData(GitBranchActionsUtil.BRANCHES_KEY);
        if (list2 == null) {
            return;
        }
        List branches2 = list2;
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((List)branches2);
        if (gitBranch == null) {
            return;
        }
        GitBranch branch = gitBranch;
        List<GitRepository> repositories2 = GitBranchActionsUtil.getAffectedRepositories(e);
        this.actionPerformed(e, project2, repositories2, branch);
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull List<? extends GitRepository> var3, @NotNull GitBranch var4);
}

