/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.util.containers.FilteringIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsTypedElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public final class JpsElementCollectionImpl<E extends JpsElement>
extends JpsElementBase<JpsElementCollectionImpl<E>>
implements JpsElementCollection<E> {
    private final List<E> myElements;
    private final Map<E, E> myCopyToOriginal;
    private final JpsElementChildRole<E> myChildRole;

    JpsElementCollectionImpl(JpsElementChildRole<E> role) {
        this.myChildRole = role;
        this.myElements = new ArrayList();
        this.myCopyToOriginal = null;
    }

    private JpsElementCollectionImpl(JpsElementCollectionImpl<E> original) {
        this.myChildRole = original.myChildRole;
        this.myElements = new ArrayList(original.myElements.size());
        this.myCopyToOriginal = new HashMap<E, E>(original.myElements.size());
        for (JpsElement e : original.myElements) {
            Object copy = e.getBulkModificationSupport().createCopy();
            JpsElementCollectionImpl.setParent(copy, this);
            this.myElements.add(copy);
            this.myCopyToOriginal.put(copy, e);
        }
    }

    @Override
    public List<E> getElements() {
        return this.myElements;
    }

    @Override
    public <X extends JpsTypedElement<P>, P extends JpsElement> Iterable<X> getElementsOfType(@NotNull JpsElementType<P> type) {
        if (type == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(0);
        }
        return new JpsElementIterable(type);
    }

    @Override
    @NotNull
    public E addChild(@NotNull JpsElementCreator<E> creator) {
        if (creator == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(1);
        }
        E e = this.addChild(creator.create());
        if (e == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(2);
        }
        return e;
    }

    @Override
    public <X extends E> X addChild(X element) {
        this.myElements.add(element);
        JpsElementCollectionImpl.setParent(element, this);
        return element;
    }

    @Override
    public void removeChild(@NotNull E element) {
        boolean removed;
        if (element == null) {
            JpsElementCollectionImpl.$$$reportNull$$$0(3);
        }
        if (removed = this.myElements.remove(element)) {
            JpsElementCollectionImpl.setParent(element, null);
        }
    }

    @Override
    public void removeAllChildren() {
        ArrayList<E> elements = new ArrayList<E>(this.myElements);
        for (JpsElement element : elements) {
            this.removeChild(element);
        }
    }

    @Override
    @NotNull
    public JpsElementCollectionImpl<E> createCopy() {
        return new JpsElementCollectionImpl<E>(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/impl/JpsElementCollectionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/impl/JpsElementCollectionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class JpsElementIterable<X extends JpsTypedElement<P>, P extends JpsElement>
    implements Iterable<X> {
        private final JpsElementType<? extends JpsElement> myType;

        JpsElementIterable(JpsElementType<P> type) {
            this.myType = type;
        }

        @Override
        public Iterator<X> iterator() {
            Iterator iterator = JpsElementCollectionImpl.this.myElements.iterator();
            return new FilteringIterator(iterator, e -> e.getType().equals(this.myType));
        }
    }
}

