/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security;

import com.google.gson.Gson;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.HttpUtilKt;
import org.jetbrains.security.RemoteConfig;
import org.jetbrains.security.ResourceUrl;
import org.jetbrains.security.UrlConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0016\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/security/RemoteConfig;", "", "()V", "cachedDbUrl", "Lorg/jetbrains/security/ResourceUrl;", "client", "Lio/ktor/client/HttpClient;", "configUrl", "", "defaultDbUrl", "getDefaultDbUrl", "()Lorg/jetbrains/security/ResourceUrl;", "initialExpiration", "Ljava/time/LocalDateTime;", "localGson", "Lcom/google/gson/Gson;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "request", "Lcom/squareup/okhttp/Request;", "standardExpiration", "getDbUrl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "obtainDbUrlOrDefault", "obtainDbUrlOrDefaultSync", "setDbUrl", "", "newDbUrl"})
public final class RemoteConfig {
    @NotNull
    public static final RemoteConfig INSTANCE = new RemoteConfig();
    @NotNull
    private static final Gson localGson = new Gson();
    @NotNull
    private static final LocalDateTime initialExpiration;
    @NotNull
    private static final LocalDateTime standardExpiration;
    private static final Logger logger;
    @NotNull
    private static final HttpClient client;
    @NotNull
    private static final ResourceUrl defaultDbUrl;
    @NotNull
    private static ResourceUrl cachedDbUrl;
    @NotNull
    private static final String configUrl = "https://www.jetbrains.com/config/vs.json";
    private static final Request request;

    private RemoteConfig() {
    }

    @NotNull
    public final ResourceUrl getDefaultDbUrl() {
        return defaultDbUrl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDbUrl(@NotNull Continuation<? super ResourceUrl> var1_1) {
        if (!(var1_1 instanceof getDbUrl.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfig this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDbUrl((Continuation<? super ResourceUrl>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (RemoteConfig.cachedDbUrl.getExpiration().compareTo(LocalDateTime.now()) >= 0) ** GOTO lbl22
                $continuation.label = 1;
                v0 = this.obtainDbUrlOrDefault((Continuation<? super ResourceUrl>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                RemoteConfig.cachedDbUrl = (ResourceUrl)v0;
lbl22:
                // 2 sources

                return RemoteConfig.cachedDbUrl;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void setDbUrl(@NotNull ResourceUrl newDbUrl) {
        Intrinsics.checkNotNullParameter((Object)newDbUrl, (String)"newDbUrl");
        cachedDbUrl = newDbUrl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object obtainDbUrlOrDefault(@NotNull Continuation<? super ResourceUrl> var1_1) {
        if (!(var1_1 instanceof obtainDbUrlOrDefault.1)) ** GOTO lbl-1000
        var18_2 = var1_1;
        if ((var18_2.label & -2147483648) != 0) {
            var18_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfig this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.obtainDbUrlOrDefault((Continuation<? super ResourceUrl>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_5 = RemoteConfig.client;
                urlString$iv = "https://www.jetbrains.com/config/vs.json";
                $i$f$get = false;
                $this$get$iv$iv = $this$get_u24default$iv;
                $i$f$get = false;
                var9_15 = $this$get$iv$iv;
                $this$get_u24lambda_u2d4$iv = var10_16 = new HttpRequestBuilder();
                $i$a$-get-BuildersKt$get$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$get_u24lambda_u2d4$iv, (String)urlString$iv);
                $this$null = $this$get_u24lambda_u2d4$iv;
                builder$iv$iv$iv = var10_16;
                $i$f$get = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv$iv = $this$get$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                ** if (v0 != var19_4) goto lbl35
lbl34:
                // 1 sources

                return var19_4;
lbl35:
                // 1 sources

                ** GOTO lbl48
            }
            case 1: {
                $i$f$get = false;
                $i$f$get = false;
                $i$f$get = false;
                $i$f$request = false;
                this = (RemoteConfig)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl48:
                // 2 sources

                $this$body$iv = (HttpResponse)v0;
                $i$f$body = false;
                $i$f$typeInfo = false;
                kType$iv$iv = Reflection.typeOf(UrlConfig.class);
                reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = $this$body$iv.getCall().body(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(UrlConfig.class), (KType)kType$iv$iv), (Continuation)$continuation);
                ** if (v1 != var19_4) goto lbl58
lbl57:
                // 1 sources

                return var19_4;
lbl58:
                // 1 sources

                ** GOTO lbl66
            }
            case 2: {
                $i$f$body = false;
                this = (RemoteConfig)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl66:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.security.UrlConfig");
                    }
                    urlConfig = (UrlConfig)v1;
                    var2_26 = new ResourceUrl(urlConfig.getDb().getUrl(), RemoteConfig.standardExpiration);
                }
                catch (Exception e) {
                    RemoteConfig.logger.warn("Couldn't RemoteConfig#obtainDbUrlOrDefault", (Throwable)e);
                    var2_26 = this.getDefaultDbUrl();
                }
                return var2_26;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final ResourceUrl obtainDbUrlOrDefaultSync() {
        ResourceUrl resourceUrl;
        try {
            OkHttpClient okHttpClient = HttpUtilKt.defaultHttpClient();
            Request request = RemoteConfig.request;
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
            String remoteFileContent = HttpUtilKt.getResponseStringSafely(okHttpClient, request);
            UrlConfig urlConfig = (UrlConfig)localGson.fromJson(StringsKt.trimIndent((String)remoteFileContent), UrlConfig.class);
            String string = urlConfig.getDb().getUrl();
            LocalDateTime localDateTime = LocalDateTime.now().plusDays(1L);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().plusDays(1)");
            resourceUrl = new ResourceUrl(string, localDateTime);
        }
        catch (Exception e) {
            logger.warn("Couldn't RemoteConfig#obtainDbUrlOrDefaultSync", (Throwable)e);
            LocalDateTime localDateTime = LocalDateTime.now().plusMinutes(30L);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().plusMinutes(30)");
            resourceUrl = new ResourceUrl("https://vulnerability-search.europe-north1-gke.intellij.net", localDateTime);
        }
        return resourceUrl;
    }

    static {
        LocalDateTime localDateTime = LocalDateTime.now().plusHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().plusHours(1)");
        initialExpiration = localDateTime;
        localDateTime = LocalDateTime.now().plusDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now().plusDays(1)");
        standardExpiration = localDateTime;
        logger = LoggerFactory.getLogger(INSTANCE.getClass());
        client = HttpUtilKt.ktorHttpClient();
        defaultDbUrl = new ResourceUrl("https://vulnerability-search.europe-north1-gke.intellij.net", initialExpiration);
        cachedDbUrl = defaultDbUrl;
        request = new Request.Builder().url(configUrl).build();
    }
}

