/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.tagging.Tagger;

public abstract class AbstractSuppressMisspelledSuggestionsFilter
extends RuleFilter {
    protected final Language language;
    protected Tagger tagger;

    protected AbstractSuppressMisspelledSuggestionsFilter(Language language) {
        this.language = language;
        this.tagger = language.getTagger();
    }

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        RuleMatch ruleMatch = match;
        List<String> replacements = match.getSuggestedReplacements();
        ArrayList<String> newReplacements = new ArrayList<String>();
        String suppressMatch = this.getRequired("suppressMatch", arguments);
        String suppressPostag = this.getOptional("SuppressPostag", arguments);
        List<Object> atrs = new ArrayList();
        if (this.tagger != null && suppressPostag != null) {
            atrs = this.tagger.tag(replacements);
        }
        for (int i = 0; i < replacements.size(); ++i) {
            if (this.isMisspelled(replacements.get(i))) continue;
            if (this.tagger != null && suppressPostag != null) {
                if (((AnalyzedTokenReadings)atrs.get(i)).matchesPosTagRegex(suppressPostag)) continue;
                newReplacements.add(replacements.get(i));
                continue;
            }
            newReplacements.add(replacements.get(i));
        }
        boolean bSuppressMatch = true;
        if (suppressMatch != null && suppressMatch.equalsIgnoreCase("false")) {
            bSuppressMatch = false;
        }
        if (newReplacements.isEmpty() && bSuppressMatch) {
            return null;
        }
        ruleMatch.setSuggestedReplacements(newReplacements);
        return ruleMatch;
    }

    public boolean isMisspelled(String s) throws IOException {
        SpellingCheckRule spellerRule = this.language.getDefaultSpellingRule();
        if (spellerRule == null) {
            return false;
        }
        try {
            List<String> tokens = this.language.getWordTokenizer().tokenize(s);
            boolean isMisspelled2 = false;
            for (String token : tokens) {
                isMisspelled2 = isMisspelled2 || spellerRule != null && spellerRule.isMisspelled(token);
            }
            return isMisspelled2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

