/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestionWithMessage;
import org.languagetool.tools.StringTools;

public abstract class AbstractCheckCaseRule
extends AbstractSimpleReplaceRule2 {
    public AbstractCheckCaseRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setLocQualityIssueType(ITSIssueType.Typographical);
        super.setCategory(Categories.CASING.getCategory(messages));
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        List<Map<String, SuggestionWithMessage>> wrongWords = this.getWrongWords(true);
        if (wrongWords.size() == 0) {
            return this.toRuleMatchArray(ruleMatches);
        }
        ArrayBlockingQueue<AnalyzedTokenReadings> prevTokens = new ArrayBlockingQueue<AnalyzedTokenReadings>(wrongWords.size());
        int sentStart = 0;
        while (sentStart + 1 < tokens.length && this.isPunctuationStart(tokens[sentStart + 1].getToken())) {
            ++sentStart;
        }
        block1: for (int i = 1; i < tokens.length; ++i) {
            this.addToQueue(tokens[i], prevTokens);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> phrases = new ArrayList<String>();
            List<AnalyzedTokenReadings> prevTokensList = Arrays.asList(prevTokens.toArray(new AnalyzedTokenReadings[0]));
            for (int j = prevTokensList.size() - 1; j >= 0; --j) {
                if (j != prevTokensList.size() - 1 && prevTokensList.get(j + 1).isWhitespaceBefore()) {
                    sb.insert(0, " ");
                }
                sb.insert(0, prevTokensList.get(j).getToken());
                phrases.add(0, sb.toString());
            }
            if (this.isTokenException(tokens[i])) continue;
            int len = phrases.size();
            for (int j = 0; j < len; ++j) {
                RuleMatch lastRuleMatch;
                String originalPhrase = (String)phrases.get(j);
                int crtWordCount = len - j;
                SuggestionWithMessage suggMess = wrongWords.get(crtWordCount - 1).get(originalPhrase.toLowerCase(this.getLocale()));
                if (suggMess == null) continue;
                String correctPhrase = suggMess.getSuggestion();
                String capitalizedCorrect = StringTools.uppercaseFirstChar(correctPhrase);
                int startPos = prevTokensList.get(len - crtWordCount).getStartPos();
                int endPos = prevTokensList.get(len - 1).getEndPos();
                if (crtWordCount + sentStart == i && originalPhrase.equals(capitalizedCorrect) || correctPhrase.equals(originalPhrase)) {
                    RuleMatch lastRuleMatch2;
                    if (ruleMatches.size() <= 0 || (lastRuleMatch2 = (RuleMatch)ruleMatches.get(ruleMatches.size() - 1)).getToPos() <= startPos) continue block1;
                    ruleMatches.remove(ruleMatches.size() - 1);
                    continue block1;
                }
                if (originalPhrase.equals(originalPhrase.toUpperCase()) || correctPhrase == null || correctPhrase.equals(originalPhrase)) continue;
                String msg = suggMess.getMessage();
                if (msg == null) {
                    msg = this.getMessage();
                }
                RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, msg, this.getShort());
                if (this.subRuleSpecificIds) {
                    ruleMatch.setSpecificRuleId(StringTools.toId(this.getId() + "_" + correctPhrase));
                }
                if (crtWordCount + sentStart == i) {
                    correctPhrase = StringTools.uppercaseFirstChar(correctPhrase);
                }
                ruleMatch.addSuggestedReplacement(correctPhrase);
                if (this.isException(sentence.getText().substring(startPos, endPos))) continue block1;
                if (ruleMatches.size() > 0 && (lastRuleMatch = (RuleMatch)ruleMatches.get(ruleMatches.size() - 1)).getFromPos() == ruleMatch.getFromPos() && lastRuleMatch.getToPos() < ruleMatch.getToPos()) {
                    ruleMatches.remove(ruleMatches.size() - 1);
                }
                ruleMatches.add(ruleMatch);
                continue block1;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isPunctuationStart(String word) {
        return StringUtils.getDigits((String)word).length() > 0 || StringTools.isPunctuationMark(word) || StringTools.isNotWordCharacter(word);
    }
}

