/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.webservice;

import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextToKeyCache;
import com.jetbrains.performancePlugin.remotedriver.webservice.UiHierarchyWebService;
import com.jetbrains.performancePlugin.remotedriver.webservice.UiHierarchyWebServiceExtension;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.CantFindRouteException;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.RequestContext;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.Routing;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.RoutingKt;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.StaticFile;
import com.jetbrains.performancePlugin.remotedriver.xpath.XpathDataModelCreator;
import com.jetbrains.performancePlugin.remotedriver.xpath.XpathUtilsKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Component;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;
import org.jsoup.helper.W3CDom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0014J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/webservice/UiHierarchyWebService;", "Lorg/jetbrains/ide/RestService;", "()V", "routing", "Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/Routing;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "hierarchy", "isMethodSupported", "", "method", "Lio/netty/handler/codec/http/HttpMethod;", "partialHierarchy", "component", "Ljava/awt/Component;", "rawHierarchy", "intellij.performanceTesting.remoteDriver"})
public final class UiHierarchyWebService
extends RestService {
    @NotNull
    private final Routing routing;

    public UiHierarchyWebService() {
        if (!Registry.is((String)"expose.ui.hierarchy.url")) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
        this.routing = RoutingKt.route("/api/" + this.getServiceName(), (Function1<? super Routing, Unit>)((Function1)new Function1<Routing, Unit>(this){
            final /* synthetic */ UiHierarchyWebService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Routing $this$route) {
                Intrinsics.checkNotNullParameter((Object)$this$route, (String)"$this$route");
                $this$route.get("/", (Function1<? super RequestContext, ? extends Object>)((Function1)new Function1<RequestContext, Object>(this.this$0){
                    final /* synthetic */ UiHierarchyWebService this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@NotNull RequestContext $this$get) {
                        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
                        return UiHierarchyWebService.access$hierarchy(this.this$0);
                    }
                }));
                $this$route.get("/raw", (Function1<? super RequestContext, ? extends Object>)((Function1)new Function1<RequestContext, Object>(this.this$0){
                    final /* synthetic */ UiHierarchyWebService this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@NotNull RequestContext $this$get) {
                        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
                        return UiHierarchyWebService.access$rawHierarchy(this.this$0);
                    }
                }));
                $this$route.get("/{id}", (Function1<? super RequestContext, ? extends Object>)((Function1)new Function1<RequestContext, Object>(this.this$0){
                    final /* synthetic */ UiHierarchyWebService this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@NotNull RequestContext $this$get) {
                        Component component;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
                            String string = $this$get.getPathParameters().get("id");
                            if (string == null) {
                                throw new IllegalStateException("id parameter is not found");
                            }
                            String id = string;
                            for (UiHierarchyWebServiceExtension it : (Iterable)UiHierarchyWebServiceExtension.Companion.getEP_NAME().getExtensionList()) {
                                boolean bl = false;
                                component = it.getComponentById(id);
                                if (component == null) {
                                    continue;
                                }
                                break block4;
                            }
                            component = null;
                        }
                        if (component == null) {
                            throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
                        }
                        Component component2 = component;
                        return UiHierarchyWebService.access$partialHierarchy(this.this$0, component2);
                    }
                }));
                $this$route.static();
            }
        }));
    }

    @NotNull
    protected String getServiceName() {
        return "remote-driver";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object[] objectArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST};
        return CollectionsKt.listOf((Object[])objectArray).contains(method);
    }

    private final String partialHierarchy(Component component) {
        Document doc2 = XpathDataModelCreator.create$default(new XpathDataModelCreator(TextToKeyCache.INSTANCE, (Function2<? super Component, ? super Element, Unit>)((Function2)partialHierarchy.doc.1.INSTANCE)), component, null, 2, null);
        String string = new W3CDom().asString(doc2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private final String rawHierarchy() {
        Document doc2 = XpathDataModelCreator.create$default(new XpathDataModelCreator(TextToKeyCache.INSTANCE, null, 2, null), null, null, 2, null);
        String string = new W3CDom().asString(doc2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private final String hierarchy() {
        Document doc2 = XpathDataModelCreator.create$default(new XpathDataModelCreator(TextToKeyCache.INSTANCE, null, 2, null), null, null, 2, null);
        return XpathUtilsKt.convertToHtml(doc2);
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            FullHttpResponse fullHttpResponse;
            Object result = this.routing.handleRequest(urlDecoder, request, context);
            if (result instanceof String) {
                String string = (String)result;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                fullHttpResponse = Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])byArray));
            } else if (result instanceof StaticFile) {
                fullHttpResponse = Responses.response((String)((StaticFile)result).getType(), (ByteBuf)Unpooled.wrappedBuffer((byte[])((StaticFile)result).getByteArray()));
            } else {
                throw new NotImplementedError(result.getClass() + " type is not supported");
            }
            FullHttpResponse response = fullHttpResponse;
            RestService.Companion.sendResponse((HttpRequest)request, context, (HttpResponse)response);
        }
        catch (CantFindRouteException e) {
            e.printStackTrace();
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            RestService.Companion.sendStatus(httpResponseStatus, bl, channel);
        }
        return null;
    }

    public static final /* synthetic */ String access$hierarchy(UiHierarchyWebService $this) {
        return $this.hierarchy();
    }

    public static final /* synthetic */ String access$rawHierarchy(UiHierarchyWebService $this) {
        return $this.rawHierarchy();
    }

    public static final /* synthetic */ String access$partialHierarchy(UiHierarchyWebService $this, Component component) {
        return $this.partialHierarchy(component);
    }
}

