/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.driver.model.transport;

import com.intellij.driver.model.LockSemantics;
import com.intellij.driver.model.OnDispatcher;
import com.intellij.driver.model.transport.PassByValue;
import java.awt.Point;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.jetbrains.annotations.Contract;

public abstract class RemoteCall
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int sessionId;
    private final String pluginId;
    private final String timedSpan;
    private final OnDispatcher dispatcher;
    private final LockSemantics lockSemantics;
    private final String className;
    private final String methodName;
    private final Object[] args;

    public RemoteCall(int sessionId, String timedSpan, String pluginId, OnDispatcher dispatcher, LockSemantics lockSemantics, String className, String methodName, Object[] args) {
        this.sessionId = sessionId;
        this.pluginId = pluginId;
        this.timedSpan = timedSpan;
        this.dispatcher = dispatcher;
        this.lockSemantics = lockSemantics;
        this.className = className;
        this.methodName = methodName;
        this.args = args;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public OnDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public LockSemantics getLockSemantics() {
        return this.lockSemantics;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getTimedSpan() {
        return this.timedSpan;
    }

    public static boolean isPassByValue(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || LocalDate.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz) || Duration.class.isAssignableFrom(clazz) || Point.class.isAssignableFrom(clazz) || PassByValue.class.isAssignableFrom(clazz);
    }

    @Contract(value="null -> true")
    public static boolean isPassByValue(Object result) {
        return result == null || result instanceof String || result instanceof Boolean || result instanceof Integer || result instanceof Long || result instanceof Byte || result instanceof Short || result instanceof Double || result instanceof Float || result instanceof LocalDate || result instanceof LocalDateTime || result instanceof Duration || result instanceof Point || result instanceof PassByValue;
    }
}

