/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.SftpProgressTracker;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObject;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.PatchedFileSystemFile;
import com.intellij.ssh.impl.sshj.channels.ProgressTrackerListener;
import com.intellij.ssh.impl.sshj.channels.SshjSftpChannelKt;
import com.intellij.ssh.impl.sshj.channels.SshjSshChannel;
import com.intellij.util.PathUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPFileTransfer;
import net.schmizz.sshj.xfer.FilePermission;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u001eH\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J:\u00101\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020&2\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u0001052\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020&\u0018\u000107H\u0016JB\u00101\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020&2\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u0001052\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020&\u0018\u0001072\u0006\u00108\u001a\u00020$H\u0016J4\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2\u0006\u0010;\u001a\u00020&2\b\u00104\u001a\u0004\u0018\u0001052\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H:0=H\u0082\b\u00a2\u0006\u0002\u0010>R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjSftpChannel;", "Lcom/intellij/ssh/channels/SftpChannel;", "Lcom/intellij/ssh/impl/sshj/channels/SshjSshChannel;", "sshConnection", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "channel", "Lnet/schmizz/sshj/connection/channel/Channel;", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "(Lcom/intellij/ssh/impl/sshj/SshjSshConnection;Lnet/schmizz/sshj/connection/channel/Channel;Lnet/schmizz/sshj/sftp/SFTPClient;)V", "home", "", "getHome", "()Ljava/lang/String;", "home$delegate", "Lkotlin/Lazy;", "canonicalize", "path", "downloadFileOrDir", "", "remotePath", "localPath", "file", "Lcom/intellij/ssh/RemoteFileObject;", "inputStream", "Ljava/io/InputStream;", "ls", "", "Lcom/intellij/ssh/channels/SftpChannel$FileInfo;", "lstat", "Lcom/intellij/ssh/channels/SftpChannel$Attrs;", "mkdir", "nonExistentFile", "outputStream", "Ljava/io/OutputStream;", "append", "", "persistExecutable", "Ljava/io/File;", "destinationPath", "readlink", "rename", "oldPath", "newPath", "rm", "rmdir", "setAttr", "attrs", "stat", "uploadFileOrDir", "remoteDir", "relativePath", "progressTracker", "Lcom/intellij/ssh/SftpProgressTracker;", "filesFilter", "Ljava/util/function/Predicate;", "persistExecutableBit", "wrapListener", "T", "baseDirectory", "handler", "Lkotlin/Function0;", "(Ljava/io/File;Lcom/intellij/ssh/SftpProgressTracker;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjSftpChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjSftpChannel.kt\ncom/intellij/ssh/impl/sshj/channels/SshjSftpChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n219#1,3:269\n222#1:273\n225#1:309\n1#2:272\n1#2:768\n33#3,35:274\n33#3,35:310\n33#3,6:345\n40#3,28:355\n33#3,35:383\n33#3,35:418\n33#3,35:453\n33#3,35:488\n33#3,35:523\n33#3,35:558\n33#3,35:593\n33#3,35:628\n33#3,35:663\n33#3,35:698\n33#3,35:733\n1549#4:351\n1620#4,3:352\n*S KotlinDebug\n*F\n+ 1 SshjSftpChannel.kt\ncom/intellij/ssh/impl/sshj/channels/SshjSftpChannel\n*L\n43#1:269,3\n43#1:273\n43#1:309\n43#1:272\n44#1:274,35\n95#1:310,35\n99#1:345,6\n99#1:355,28\n103#1:383,35\n121#1:418,35\n173#1:453,35\n177#1:488,35\n181#1:523,35\n185#1:558,35\n189#1:593,35\n193#1:628,35\n197#1:663,35\n206#1:698,35\n210#1:733,35\n100#1:351\n100#1:352,3\n*E\n"})
public final class SshjSftpChannel
extends SshjSshChannel
implements SftpChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final Lazy home$delegate;

    public SshjSftpChannel(@NotNull SshjSshConnection sshConnection, @NotNull Channel channel2, @NotNull SFTPClient sftp2) {
        Intrinsics.checkNotNullParameter((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)sftp2, (String)"sftp");
        super(sshConnection, channel2);
        this.sftp = sftp2;
        this.home$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ SshjSftpChannel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return SshjSftpChannel.access$getSftp$p(this.this$0).canonicalize("");
            }
        }));
    }

    @Override
    @NotNull
    public String getHome() {
        Lazy lazy = this.home$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void uploadFileOrDir(@NotNull File file, @NotNull String remoteDir, @NotNull String relativePath, @Nullable SftpProgressTracker progressTracker, @Nullable Predicate<File> filesFilter, boolean persistExecutableBit) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)remoteDir, (String)"remoteDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SshjSftpChannel sshjSftpChannel = this;
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File("/");
        }
        File baseDirectory$iv = file2;
        boolean $i$f$wrapListener = false;
        TransferListener oldListener$iv = this_$iv.sftp.getFileTransfer().getTransferListener();
        try {
            ProgressTrackerListener progressTrackerListener;
            SFTPFileTransfer sFTPFileTransfer = this_$iv.sftp.getFileTransfer();
            SftpProgressTracker sftpProgressTracker = progressTracker;
            if (sftpProgressTracker != null) {
                void it$iv;
                SftpProgressTracker sftpProgressTracker2 = sftpProgressTracker;
                SFTPFileTransfer sFTPFileTransfer2 = sFTPFileTransfer;
                boolean bl = false;
                progressTrackerListener = new ProgressTrackerListener(baseDirectory$iv, (SftpProgressTracker)it$iv);
                sFTPFileTransfer = sFTPFileTransfer2;
            } else {
                progressTrackerListener = null;
            }
            sFTPFileTransfer.setTransferListener((TransferListener)progressTrackerListener);
            boolean bl = false;
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String file$iv = string;
            boolean logNoSuchFileError$iv = true;
            boolean log$iv = true;
            boolean $i$f$wrapSshjSftpException = false;
            boolean $i$f$wrapSshjSftpException2 = false;
            try {
                boolean bl2 = false;
                Object object = new char[]{'/'};
                String destinationPath = FileUtil.toCanonicalPath((String)(StringsKt.trimEnd((String)remoteDir, (char[])object) + "/" + relativePath), (char)'/');
                SftpChannel sftpChannel2 = this;
                object = file.isDirectory() ? destinationPath : PathUtil.getParentPath((String)destinationPath);
                Intrinsics.checkNotNull((Object)object);
                UtilKt.createDirectories(sftpChannel2, (String)object);
                if (filesFilter != null) {
                    this.sftp.getFileTransfer().setUploadFilter(arg_0 -> SshjSftpChannel.uploadFileOrDir$lambda$2$lambda$1$lambda$0(filesFilter, progressTracker, arg_0));
                }
                FileSystemFile fileSystemFile = new FileSystemFile(file);
                this.sftp.put((LocalSourceFile)fileSystemFile, destinationPath);
                if (persistExecutableBit) {
                    Intrinsics.checkNotNull((Object)destinationPath);
                    this.persistExecutable(file, destinationPath);
                }
                this.sftp.getFileTransfer().setUploadFilter(null);
                Unit unit = Unit.INSTANCE;
            }
            catch (SFTPException e$iv$iv) {
                IOException it$iv = (IOException)((Object)e$iv$iv);
                boolean bl3 = false;
                String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
                Response.StatusCode statusCode = e$iv$iv.getStatusCode();
                switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                    case 1: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                        }
                        UtilKt.getSSHJ_LOG().info(message$iv$iv);
                        break;
                    }
                    case 2: {
                        if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                        }
                        UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                        break;
                    }
                    default: {
                        UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                    }
                }
                throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
            }
            catch (IOException e$iv$iv) {
                IOException it$iv = e$iv$iv;
                boolean bl4 = false;
                String message$iv$iv = "File " + file$iv + ": " + it$iv.getMessage();
                UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.sftp.getFileTransfer().setTransferListener(oldListener$iv);
        }
    }

    private final void persistExecutable(File file, String destinationPath) {
        if (Companion.shouldSetExecutableBit(file)) {
            return;
        }
        FileAttributes attributes = this.sftp.stat(destinationPath);
        if (!attributes.getPermissions().contains(FilePermission.USR_X)) {
            Set permissions = new LinkedHashSet();
            Set set = attributes.getPermissions();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPermissions(...)");
            permissions.addAll(set);
            permissions.add(FilePermission.USR_X);
            FileAttributes newAttributes = new FileAttributes.Builder().withAtimeMtime(attributes.getAtime(), attributes.getMtime()).withPermissions(permissions).withSize(attributes.getSize()).withType(attributes.getType()).withUIDGID(attributes.getUID(), attributes.getGID()).build();
            this.sftp.setattr(destinationPath, newAttributes);
        }
    }

    @Override
    public void uploadFileOrDir(@NotNull File file, @NotNull String remoteDir, @NotNull String relativePath, @Nullable SftpProgressTracker progressTracker, @Nullable Predicate<File> filesFilter) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)remoteDir, (String)"remoteDir");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        this.uploadFileOrDir(file, remoteDir, relativePath, progressTracker, filesFilter, false);
    }

    @Override
    public void downloadFileOrDir(@NotNull String remotePath, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        boolean logNoSuchFileError$iv = true;
        boolean log$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.getFileTransfer().download(remotePath, (LocalDestFile)new PatchedFileSystemFile(localPath));
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + remotePath + ": " + it$iv.getMessage();
            Response.StatusCode statusCode = e$iv$iv.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().info(message$iv$iv);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug(message$iv$iv, (Throwable)e$iv$iv);
                    }
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
                }
            }
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + remotePath + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SftpChannel.FileInfo> ls(@NotNull String path) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List list3 = this.sftp.ls(path);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ls(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemoteResourceInfo remoteResourceInfo = (RemoteResourceInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                FileAttributes fileAttributes = it.getAttributes();
                Intrinsics.checkNotNull((Object)fileAttributes);
                collection.add(new SftpChannel.FileInfo(string, SshjSftpChannelKt.access$toAttrs(fileAttributes)));
            }
            list2 = (List)destination$iv$iv;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        return list2;
    }

    @Override
    @NotNull
    public InputStream inputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            RemoteFile remoteFile = this.sftp.open(path, (Set)EnumSet.of((Enum)OpenMode.READ));
            Intrinsics.checkNotNull((Object)remoteFile);
            RemoteFile.RemoteFileInputStream delegateStream = new RemoteFile.RemoteFileInputStream(remoteFile);
            return new InputStream(remoteFile, delegateStream){
                final /* synthetic */ RemoteFile $remoteFile;
                final /* synthetic */ RemoteFile.RemoteFileInputStream $delegateStream;
                {
                    this.$remoteFile = $remoteFile;
                    this.$delegateStream = $delegateStream;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    Closeable closeable = (Closeable)this.$remoteFile;
                    RemoteFile.RemoteFileInputStream remoteFileInputStream = this.$delegateStream;
                    Throwable throwable = null;
                    try {
                        RemoteFile it = (RemoteFile)closeable;
                        boolean bl = false;
                        remoteFileInputStream.close();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }

                public int read() {
                    return this.$delegateStream.read();
                }

                public int read(@NotNull byte[] b, int off, int len) {
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return this.$delegateStream.read(b, off, len);
                }
            };
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    @NotNull
    public OutputStream outputStream(@NotNull String path, boolean append) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            EnumSet<Enum> mode = EnumSet.of((Enum)OpenMode.CREAT, (Enum)OpenMode.WRITE, (Enum)(append ? OpenMode.APPEND : OpenMode.TRUNC));
            SshjSftpChannel $this$outputStream_u24lambda_u248_u24lambda_u247 = this;
            boolean bl2 = false;
            String string = $this$outputStream_u24lambda_u248_u24lambda_u247.getSshConnection().getSshjBackend$intellij_platform_ssh().getTransport().getServerVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServerVersion(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String serverVersion = string2;
            int maxChunkSize = StringsKt.contains$default((CharSequence)serverVersion, (CharSequence)"openssh", (boolean)false, (int)2, null) ? 131072 : (StringsKt.contains$default((CharSequence)serverVersion, (CharSequence)"dropbear", (boolean)false, (int)2, null) ? 4096 : 65536);
            RemoteFile remoteFile = this.sftp.open(path, (Set)mode);
            Intrinsics.checkNotNull((Object)remoteFile);
            RemoteFile.RemoteFileOutputStream delegate = new RemoteFile.RemoteFileOutputStream(remoteFile, 0L, 50);
            return new OutputStream(remoteFile, delegate, maxChunkSize){
                final /* synthetic */ RemoteFile $remoteFile;
                final /* synthetic */ RemoteFile.RemoteFileOutputStream $delegate;
                final /* synthetic */ int $maxChunkSize;
                {
                    this.$remoteFile = $remoteFile;
                    this.$delegate = $delegate;
                    this.$maxChunkSize = $maxChunkSize;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    Closeable closeable = (Closeable)this.$remoteFile;
                    RemoteFile.RemoteFileOutputStream remoteFileOutputStream = this.$delegate;
                    Throwable throwable = null;
                    try {
                        RemoteFile it = (RemoteFile)closeable;
                        boolean bl = false;
                        remoteFileOutputStream.close();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }

                public void flush() {
                    this.$delegate.flush();
                }

                public void write(int b) {
                    throw new IllegalStateException("Please don't write to streams byte by byte. This error is easier to debug than performance degradations.".toString());
                }

                public void write(@NotNull byte[] b, int off, int len) {
                    int currentLen;
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int end = off + len;
                    int off2 = off;
                    do {
                        currentLen = Math.min(end - off2, this.$maxChunkSize);
                        this.$delegate.write(b, off2, currentLen);
                    } while ((off2 += currentLen) < end);
                }
            };
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public void mkdir(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.mkdir(path);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    @NotNull
    public SftpChannel.Attrs lstat(@NotNull String path) {
        SftpChannel.Attrs attrs;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            FileAttributes fileAttributes = this.sftp.lstat(path);
            Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"lstat(...)");
            attrs = SshjSftpChannelKt.access$toAttrs(fileAttributes);
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        return attrs;
    }

    @Override
    @NotNull
    public SftpChannel.Attrs stat(@NotNull String path) {
        SftpChannel.Attrs attrs;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            FileAttributes fileAttributes = this.sftp.stat(path);
            Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"stat(...)");
            attrs = SshjSftpChannelKt.access$toAttrs(fileAttributes);
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        return attrs;
    }

    @Override
    public void rename(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.rename(oldPath, newPath);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + oldPath + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + oldPath + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public void rm(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.rm(path);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public void rmdir(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.rmdir(path);
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    public void setAttr(@NotNull String path, @NotNull SftpChannel.Attrs attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            this.sftp.setattr(path, new FileAttributes.Builder().withPermissions(attrs.getPermissions()).withSize(attrs.getSize()).withUIDGID(attrs.getUid(), attrs.getGid()).withAtimeMtime(attrs.getAtime(), attrs.getMtime()).build());
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
    }

    @Override
    @NotNull
    public String readlink(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            string = this.sftp.readlink(path);
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Override
    @NotNull
    public String canonicalize(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean log$iv = false;
        boolean logNoSuchFileError$iv = true;
        boolean $i$f$wrapSshjSftpException = false;
        boolean $i$f$wrapSshjSftpException2 = false;
        try {
            boolean bl = false;
            string = this.sftp.canonicalize(path);
        }
        catch (SFTPException e$iv$iv) {
            IOException it$iv = (IOException)((Object)e$iv$iv);
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            throw SftpChannelException.Companion.create(e$iv$iv.getStatusCode().getCode(), message$iv$iv, e$iv$iv);
        }
        catch (IOException e$iv$iv) {
            IOException it$iv = e$iv$iv;
            boolean bl = false;
            String message$iv$iv = "File " + path + ": " + it$iv.getMessage();
            UtilKt.getSSHJ_LOG().warn(message$iv$iv, (Throwable)e$iv$iv);
            throw SftpChannelException.Companion.create(-1, message$iv$iv, e$iv$iv);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Override
    @NotNull
    public RemoteFileObject file(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SshjRemoteFileObject(this.sftp, path, this.toString(), false, 8, null);
    }

    @Override
    @NotNull
    public RemoteFileObject nonExistentFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SshjRemoteFileObject(this.sftp, path, this.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T> T wrapListener(File baseDirectory, SftpProgressTracker progressTracker, Function0<? extends T> handler) {
        boolean $i$f$wrapListener = false;
        TransferListener oldListener = this.sftp.getFileTransfer().getTransferListener();
        try {
            ProgressTrackerListener progressTrackerListener;
            SFTPFileTransfer sFTPFileTransfer = this.sftp.getFileTransfer();
            SftpProgressTracker sftpProgressTracker = progressTracker;
            if (sftpProgressTracker != null) {
                void it;
                SftpProgressTracker sftpProgressTracker2 = sftpProgressTracker;
                SFTPFileTransfer sFTPFileTransfer2 = sFTPFileTransfer;
                boolean bl = false;
                progressTrackerListener = new ProgressTrackerListener(baseDirectory, (SftpProgressTracker)it);
                sFTPFileTransfer = sFTPFileTransfer2;
            } else {
                progressTrackerListener = null;
            }
            sFTPFileTransfer.setTransferListener((TransferListener)progressTrackerListener);
            Object object = handler.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.sftp.getFileTransfer().setTransferListener(oldListener);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final boolean uploadFileOrDir$lambda$2$lambda$1$lambda$0(Predicate $filesFilter, SftpProgressTracker $progressTracker, LocalSourceFile it) {
        if (it instanceof FileSystemFile) {
            File actualFile = ((FileSystemFile)it).getFile();
            boolean accept = $filesFilter.test(actualFile);
            if (!accept) {
                SftpProgressTracker sftpProgressTracker = $progressTracker;
                if (sftpProgressTracker != null) {
                    Intrinsics.checkNotNull((Object)actualFile);
                    sftpProgressTracker.onFileIgnored(actualFile);
                }
            }
            return accept;
        }
        return true;
    }

    public static final /* synthetic */ SFTPClient access$getSftp$p(SshjSftpChannel $this) {
        return $this.sftp;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshjSftpChannel$Companion;", "", "()V", "shouldSetExecutableBit", "", "file", "Ljava/io/File;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldSetExecutableBit(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return !file.isFile() || !file.canExecute();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

