/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigService;
import com.intellij.ssh.interaction.SshPasswordProvider;
import com.intellij.util.EventDispatcher;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0012\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u0016H\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#H\u0007J\u0015\u0010$\u001a\u00020%2\r\b\u0001\u0010&\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004J\u001e\u0010'\u001a\u00020(2\b\b\u0002\u0010 \u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0007J\u0012\u0010,\u001a\u00020(2\b\b\u0002\u0010 \u001a\u00020)H\u0007J\u001c\u0010,\u001a\u00020(2\b\b\u0002\u0010 \u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J\u0006\u0010-\u001a\u00020.J\u001a\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#H\u0007J\u0016\u00101\u001a\u00020\u00002\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u000e\u00103\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0016J\u0010\u00104\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\fJ\u000e\u00105\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u000eJ\u001a\u00106\u001a\u00020\u00002\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u00108\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0014R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\n\u00a8\u00069"}, d2={"Lcom/intellij/ssh/ConnectionBuilder;", "", "host", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Ljava/lang/String;)V", "disconnectTrigger", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ssh/ForceDisconnectListener;", "getHost", "()Ljava/lang/String;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "sshBackendLibrary", "Lcom/intellij/ssh/SshBackendLibrary;", "sshConnectionConfigModifiers", "", "Lkotlin/Function1;", "Lcom/intellij/ssh/config/SshConnectionConfig;", "sshPasswordProvider", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "useOpenSshConfig", "", "userHostPort", "getUserHostPort", "buildConnectionConfig", "buildSessionConfig", "Lcom/intellij/ssh/SessionConfig;", "checkCanAuthenticate", "addToPool", "connect", "Lcom/intellij/ssh/SshSession;", "timeoutInSeconds", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "execBuilder", "Lcom/intellij/ssh/ExecBuilder;", "command", "openFailSafeSftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "", "explicitCommand", "Lcom/intellij/ssh/SftpChannelConfig$SftpCommand;", "openSftpChannel", "shellBuilder", "Lcom/intellij/ssh/ShellChannelBuilder;", "withConnectionTimeout", "timeout", "withDisconnectTrigger", "value", "withParsingOpenSSHConfig", "withProgressIndicator", "withSshBackendLibrary", "withSshConnectionConfig", "modifier", "withSshPasswordProvider", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nssh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/ConnectionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,432:1\n1#2:433\n42#3,3:434\n42#3,3:437\n*S KotlinDebug\n*F\n+ 1 ssh.kt\ncom/intellij/ssh/ConnectionBuilder\n*L\n121#1:434,3\n144#1:437,3\n*E\n"})
public final class ConnectionBuilder {
    @NotNull
    private final String host;
    @NotNull
    private final List<Function1<SshConnectionConfig, SshConnectionConfig>> sshConnectionConfigModifiers;
    @Nullable
    private SshPasswordProvider sshPasswordProvider;
    @Nullable
    private EventDispatcher<ForceDisconnectListener> disconnectTrigger;
    @NotNull
    private SshBackendLibrary sshBackendLibrary;
    @Nullable
    private ProgressIndicator progressIndicator;
    private boolean useOpenSshConfig;

    public ConnectionBuilder(@NotNull String host2) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        this.host = host2;
        this.sshConnectionConfigModifiers = new ArrayList();
        this.sshBackendLibrary = SshBackendLibrary.Companion.get();
        this.progressIndicator = ProgressManager.getGlobalProgressIndicator();
        this.useOpenSshConfig = true;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final ConnectionBuilder withSshPasswordProvider(@NotNull SshPasswordProvider value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sshPasswordProvider = value;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final ConnectionBuilder withConnectionTimeout(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return this.withSshConnectionConfig((Function1<? super SshConnectionConfig, SshConnectionConfig>)((Function1)new Function1<SshConnectionConfig, SshConnectionConfig>(timeout, timeUnit){
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $timeUnit;
            {
                this.$timeout = $timeout;
                this.$timeUnit = $timeUnit;
                super(1);
            }

            @NotNull
            public final SshConnectionConfig invoke(@NotNull SshConnectionConfig it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SshConnectionConfig.copy$default(it, null, null, false, Duration.of(this.$timeout, this.$timeUnit.toChronoUnit()), false, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, 524279, null);
            }
        }));
    }

    public static /* synthetic */ ConnectionBuilder withConnectionTimeout$default(ConnectionBuilder connectionBuilder2, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return connectionBuilder2.withConnectionTimeout(l, timeUnit);
    }

    @NotNull
    public final ConnectionBuilder withParsingOpenSSHConfig(boolean value) {
        ConnectionBuilder connectionBuilder2;
        ConnectionBuilder $this$withParsingOpenSSHConfig_u24lambda_u240 = connectionBuilder2 = this;
        boolean bl = false;
        $this$withParsingOpenSSHConfig_u24lambda_u240.useOpenSshConfig = value;
        return connectionBuilder2;
    }

    @NotNull
    public final ConnectionBuilder withSshConnectionConfig(@NotNull Function1<? super SshConnectionConfig, SshConnectionConfig> modifier) {
        ConnectionBuilder connectionBuilder2;
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        ConnectionBuilder $this$withSshConnectionConfig_u24lambda_u241 = connectionBuilder2 = this;
        boolean bl = false;
        ((Collection)$this$withSshConnectionConfig_u24lambda_u241.sshConnectionConfigModifiers).add(modifier);
        return connectionBuilder2;
    }

    @NotNull
    public final ConnectionBuilder withDisconnectTrigger(@Nullable EventDispatcher<ForceDisconnectListener> value) {
        ConnectionBuilder connectionBuilder2;
        ConnectionBuilder $this$withDisconnectTrigger_u24lambda_u242 = connectionBuilder2 = this;
        boolean bl = false;
        $this$withDisconnectTrigger_u24lambda_u242.disconnectTrigger = value;
        return connectionBuilder2;
    }

    @NotNull
    public final ConnectionBuilder withSshBackendLibrary(@NotNull SshBackendLibrary value) {
        ConnectionBuilder connectionBuilder2;
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        ConnectionBuilder $this$withSshBackendLibrary_u24lambda_u243 = connectionBuilder2 = this;
        boolean bl = false;
        $this$withSshBackendLibrary_u24lambda_u243.sshBackendLibrary = value;
        return connectionBuilder2;
    }

    @NotNull
    public final ConnectionBuilder withProgressIndicator(@Nullable ProgressIndicator value) {
        ConnectionBuilder connectionBuilder2;
        ConnectionBuilder $this$withProgressIndicator_u24lambda_u244 = connectionBuilder2 = this;
        boolean bl = false;
        $this$withProgressIndicator_u24lambda_u244.progressIndicator = value;
        return connectionBuilder2;
    }

    @NotNull
    public final String getUserHostPort() {
        SshConnectionConfig $this$_get_userHostPort__u24lambda_u245 = this.buildConnectionConfig();
        boolean bl = false;
        return (String)(((CharSequence)$this$_get_userHostPort__u24lambda_u245.getUser()).length() == 0 ? "" : $this$_get_userHostPort__u24lambda_u245.getUser() + "@") + $this$_get_userHostPort__u24lambda_u245.getHost() + ":" + $this$_get_userHostPort__u24lambda_u245.getPort();
    }

    @JvmOverloads
    @NotNull
    public final SshSession connect(long timeoutInSeconds, @NotNull TimeUnit timeUnit) throws SshException {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return Ssh.access$connect(this.withConnectionTimeout(timeoutInSeconds, timeUnit).buildSessionConfig());
    }

    public static /* synthetic */ SshSession connect$default(ConnectionBuilder connectionBuilder2, long l, TimeUnit timeUnit, int n, Object object) throws SshException {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return connectionBuilder2.connect(l, timeUnit);
    }

    @NotNull
    public final SshSession connect() throws SshException {
        return Ssh.access$connect(this.buildSessionConfig());
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate(boolean addToPool) throws SshException {
        return Ssh.access$checkCanAuthenticate(this.buildSessionConfig(), addToPool);
    }

    public static /* synthetic */ boolean checkCanAuthenticate$default(ConnectionBuilder connectionBuilder2, boolean bl, int n, Object object) throws SshException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return connectionBuilder2.checkCanAuthenticate(bl);
    }

    @NotNull
    public final SftpChannel openSftpChannel(int timeoutInSeconds, @Nullable SftpChannelConfig.SftpCommand explicitCommand) throws SshException {
        long l = timeoutInSeconds;
        Object object = TimeUnit.SECONDS;
        SftpChannelConfig channelConfig = new SftpChannelConfig(explicitCommand, l, (TimeUnit)((Object)object));
        boolean $i$f$service = false;
        Class<SshConnectionService> serviceClass$iv = SshConnectionService.class;
        object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((SshConnectionService)object).sftp(this.buildSessionConfig(), channelConfig);
    }

    public static /* synthetic */ SftpChannel openSftpChannel$default(ConnectionBuilder connectionBuilder2, int n, SftpChannelConfig.SftpCommand sftpCommand, int n2, Object object) throws SshException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            sftpCommand = null;
        }
        return connectionBuilder2.openSftpChannel(n, sftpCommand);
    }

    @JvmOverloads
    @NotNull
    public final SftpChannel openSftpChannel(int timeoutInSeconds) throws SshException {
        return this.openSftpChannel(timeoutInSeconds, null);
    }

    public static /* synthetic */ SftpChannel openSftpChannel$default(ConnectionBuilder connectionBuilder2, int n, int n2, Object object) throws SshException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return connectionBuilder2.openSftpChannel(n);
    }

    @JvmOverloads
    @NotNull
    public final SftpChannel openFailSafeSftpChannel(int timeoutInSeconds, @Nullable SftpChannelConfig.SftpCommand explicitCommand) throws SshException {
        long l = timeoutInSeconds;
        Object object = TimeUnit.SECONDS;
        SftpChannelConfig channelConfig = new SftpChannelConfig(explicitCommand, l, (TimeUnit)((Object)object));
        boolean $i$f$service = false;
        Class<SshConnectionService> serviceClass$iv = SshConnectionService.class;
        object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return ((SshConnectionService)object).failSafeSftp(this.buildSessionConfig(), channelConfig);
    }

    public static /* synthetic */ SftpChannel openFailSafeSftpChannel$default(ConnectionBuilder connectionBuilder2, int n, SftpChannelConfig.SftpCommand sftpCommand, int n2, Object object) throws SshException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            sftpCommand = null;
        }
        return connectionBuilder2.openFailSafeSftpChannel(n, sftpCommand);
    }

    @NotNull
    public final ExecBuilder execBuilder(@NlsSafe @NotNull String command) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return new ExecBuilder(this.buildSessionConfig(), command);
    }

    @NotNull
    public final ShellChannelBuilder shellBuilder() throws SshConfigParseException {
        return new ShellChannelBuilder(this.buildSessionConfig());
    }

    @NotNull
    public final SshConnectionConfig buildConnectionConfig() throws SshConfigParseException {
        return SshConnectionConfigService.Companion.getInstance().get(this.host, this.useOpenSshConfig, this.sshConnectionConfigModifiers);
    }

    @NotNull
    public final SessionConfig buildSessionConfig() throws SshConfigParseException {
        if (!(this.sshPasswordProvider != null)) {
            boolean bl = false;
            String string = "Forgotten sshPasswordProvider";
            throw new IllegalStateException(string.toString());
        }
        return new SessionConfig(this.host, this.buildConnectionConfig(), this.sshPasswordProvider, null, this.sshBackendLibrary, this.progressIndicator, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final ConnectionBuilder withConnectionTimeout(long timeout) {
        return ConnectionBuilder.withConnectionTimeout$default(this, timeout, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SshSession connect(long timeoutInSeconds) throws SshException {
        return ConnectionBuilder.connect$default(this, timeoutInSeconds, null, 2, null);
    }

    @JvmOverloads
    public final boolean checkCanAuthenticate() throws SshException {
        return ConnectionBuilder.checkCanAuthenticate$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final SftpChannel openSftpChannel() throws SshException {
        return ConnectionBuilder.openSftpChannel$default(this, 0, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final SftpChannel openFailSafeSftpChannel(int timeoutInSeconds) throws SshException {
        return ConnectionBuilder.openFailSafeSftpChannel$default(this, timeoutInSeconds, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SftpChannel openFailSafeSftpChannel() throws SshException {
        return ConnectionBuilder.openFailSafeSftpChannel$default(this, 0, null, 3, null);
    }
}

