/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.jline.builtins.ssh.ShellFactoryImpl;
import org.jline.builtins.ssh.Ssh;

public class ShellCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(ShellCommand.class.getName());
    private final Consumer<Ssh.ExecuteParams> execute;
    private final String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private Environment env;

    public ShellCommand(Consumer<Ssh.ExecuteParams> execute2, String command2) {
        this.execute = execute2;
        this.command = command2;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession channel, Environment env2) throws IOException {
        this.session = channel.getSession();
        this.env = env2;
        new Thread(this::run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        int exitStatus = 0;
        try {
            this.execute.accept(new Ssh.ExecuteParams(this.command, this.env.getEnv(), this.session, this.in, this.out, this.err));
        }
        catch (RuntimeException e) {
            try {
                exitStatus = 1;
                LOGGER.log(Level.SEVERE, "Unable to start shell", e);
                try {
                    Throwable t2 = e.getCause() != null ? e.getCause() : e;
                    this.err.write(t2.toString().getBytes());
                    this.err.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(exitStatus);
                throw throwable;
            }
            ShellFactoryImpl.close(this.in, this.out, this.err);
            this.callback.onExit(exitStatus);
        }
        ShellFactoryImpl.close(this.in, this.out, this.err);
        this.callback.onExit(exitStatus);
    }

    public void destroy(ChannelSession channel) {
    }
}

