/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.dev.inspectionKts;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplateKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0003"}, d2={"templateJavaInspectionKts", "", "filename", "intellij.qodana.jvm.dev"})
public final class JavaInspectionKtsTemplateProviderKt {
    private static final String templateJavaInspectionKts(String filename) {
        String inspectionName = InspectionKtsTemplateKt.templateInspectionKtsFilenameToInspectionName(filename);
        String imports = "import com.intellij.psi.PsiClass\nimport com.intellij.psi.PsiLocalVariable\nimport com.intellij.psi.PsiMethod";
        String topComment = "/**\n * This is an auto-generated template Java custom inspection\n * Reports all local variables inside all class methods\n *\n * The inspection is applied automatically and executed on-fly: to see the inspection results, open the Java file in the editor\n * \n * In this example, the inspection algorithm is the following:\n *   1. Take all classes in file\n *   2. If the class is not an interface, take all its declared methods, otherwise ignore\n *   3. For each declared method, take all nodes that correspond to local variables and are descendants of method node \n *   4. Reports variables' name and type\n */";
        String inspectionVisitorContent = StringsKt.trimIndent((String)("\n    val everyLocalVariableInMethodInspection = localInspection { psiFile, inspection ->\n        // take all classes declared in file: all PsiClass children of PsiFile node (root)\n        val classes = psiFile.descendantsOfType<PsiClass>()\n        \n        classes.forEach { javaClass: PsiClass ->\n            // ignore interfaces\n            if (javaClass.isInterface) {\n                return@forEach\n            }\n    \n            // take all declared methods of a class\n            javaClass.methods.forEach { method: PsiMethod ->\n                // take all local variables inside method\n                val localVariables = method.descendantsOfType<PsiLocalVariable>()\n    \n                // for each local variable, report its name and type as a problem\n                localVariables.forEach { variable: PsiLocalVariable ->\n                    val variableType = variable.type.canonicalText\n                    val message = \"This is a variable ${variable.name} in method ${method.name} of type $variableType. " + inspectionName + "\"\n                    inspection.registerProblem(variable, message)\n                }\n            }\n        }\n    }\n  "));
        return InspectionKtsTemplateKt.standardLocalInspectionKtsTemplateContent$default(filename, imports, topComment, null, inspectionVisitorContent, "everyLocalVariableInMethodInspection", null, 72, null);
    }

    public static final /* synthetic */ String access$templateJavaInspectionKts(String filename) {
        return JavaInspectionKtsTemplateProviderKt.templateJavaInspectionKts(filename);
    }
}

