/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.html.HtmlQuotesFormatPreprocessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(1);
        }
        TemplateImpl tokenTemplate = token.getTemplate();
        String s = this.toString(token, hasChildren, context);
        assert (tokenTemplate != null);
        TemplateImpl template = tokenTemplate.copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key2, boolean forceSingleTag) {
        if (key2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(2);
        }
        StringBuilder builder2 = new StringBuilder("<");
        builder2.append(key2).append('>');
        if (!forceSingleTag && !HtmlUtil.isSingleHtmlTag(key2, false)) {
            builder2.append("$END$</").append(key2).append('>');
        }
        return new TemplateImpl("", builder2.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(4);
        }
        CodeStyleSettings.QuoteStyle quoteStyle = XmlEditUtil.quoteStyle(context.getContainingFile());
        XmlTag tag = token.getXmlTag();
        if (tag != null) {
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
                HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, tag);
                Document document2 = token.getFile().getViewProvider().getDocument();
                token.setTemplateText(document2.getText(), token.getFile());
            }
            String string2 = XmlZenCodingGenerator.replaceQuotesIfNeeded(this.toString(token.getXmlTag(), token.getAttributes(), hasChildren, context), context.getContainingFile());
            if (string2 == null) {
                XmlZenCodingGenerator.$$$reportNull$$$0(5);
            }
            return string2;
        }
        PsiFile file = token.getFile();
        if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
            HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, (PsiElement)file);
        }
        String string3 = XmlZenCodingGenerator.replaceQuotesIfNeeded(file.getText(), context.getContainingFile());
        if (string3 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(6);
        }
        return string3;
    }

    private static String replaceQuotesIfNeeded(@NotNull String text2, @NotNull PsiFile file) {
        PsiElement context;
        if (text2 == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(8);
        }
        if ((context = file.getContext()) != null) {
            String contextText = context.getText();
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\"')) {
                return StringUtil.escapeChar((String)text2, (char)'\"');
            }
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\'')) {
                return StringUtil.escapeChar((String)text2, (char)'\'');
            }
        }
        return text2;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull Map<String, String> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull Map<String, String> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull CustomTemplateCallback var1, boolean var2);

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(9);
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = Math.min(editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(currentOffset)), currentOffset);
        CharSequence documentText = editor.getDocument().getCharsSequence();
        PsiElement prevVisibleLeaf = callback.getContext();
        while (prevVisibleLeaf != null) {
            TextRange textRange = prevVisibleLeaf.getTextRange();
            int endOffset = textRange.getEndOffset();
            if (endOffset <= currentOffset) {
                if (endOffset <= startOffset) break;
                IElementType prevType = prevVisibleLeaf.getNode().getElementType();
                if (prevType == XmlTokenType.XML_TAG_END || prevType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    startOffset = endOffset;
                    break;
                }
            }
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        if (startOffset < 0 || currentOffset > documentText.length() || currentOffset < startOffset) {
            Logger.getInstance(this.getClass()).error("Error while calculating emmet abbreviation. Offset: " + currentOffset + "; Start: " + startOffset, new Attachment[]{CoreAttachmentFactory.createAttachment((Document)editor.getDocument())});
            return null;
        }
        String key2 = this.computeKey(documentText.subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key2) && ZenCodingTemplate.checkTemplateKey(key2, callback, this) ? key2 : null;
    }

    @Override
    public void disableEmmet() {
        EmmetOptions.getInstance().setEmmetEnabled(false);
    }

    @Override
    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            XmlZenCodingGenerator.$$$reportNull$$$0(10);
        }
        return ZenCodingUtil.isHtml(callback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateByKey";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceQuotesIfNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHtml";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }
}

