/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/IJFUSMapper;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "FUS_RECORDER", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "ML_RECORDER", "fusMachineId", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "mlMachineId", "report", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class IJFUSMapper
extends ApplicationUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("map.ml.fus", 1, "IJ_MAP");
    @NotNull
    private final String ML_RECORDER;
    @NotNull
    private final String FUS_RECORDER;
    @NotNull
    private final StringEventField mlMachineId = EventFields.StringValidatedByRegexpReference$default("ml_machine_id", "hash", null, 4, null);
    @NotNull
    private final StringEventField fusMachineId = EventFields.StringValidatedByRegexpReference$default("fus_machine_id", "hash", null, 4, null);
    @NotNull
    private final EventId2<String, String> report = this.GROUP.registerEvent("paired", (EventField)this.mlMachineId, (EventField)this.fusMachineId, "Paired FUS and ML machine_id");

    public IJFUSMapper() {
        this.ML_RECORDER = "ML";
        this.FUS_RECORDER = "FUS";
    }

    @Override
    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @Override
    @NotNull
    public Set<MetricEvent> getMetrics() {
        EventLogOptions eventLogOptions = EventLogConfigOptionsService.getInstance().getOptions(this.ML_RECORDER);
        Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions, (String)"getOptions(...)");
        EventLogOptions mlConfig = eventLogOptions;
        EventLogOptions eventLogOptions2 = EventLogConfigOptionsService.getInstance().getOptions(this.FUS_RECORDER);
        Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions2, (String)"getOptions(...)");
        EventLogOptions fusConfig = eventLogOptions2;
        String string = "JetBrains" + this.ML_RECORDER;
        String string2 = mlConfig.getMachineIdSalt();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = MachineIdManager.INSTANCE.getAnonymizedMachineId(string, string2);
        String string4 = "JetBrains" + this.FUS_RECORDER;
        String string5 = fusConfig.getMachineIdSalt();
        if (string5 == null) {
            string5 = "";
        }
        return SetsKt.setOf((Object)this.report.metric(string3, MachineIdManager.INSTANCE.getAnonymizedMachineId(string4, string5)));
    }
}

