/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.formatting.FormattingMode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.smart.YAMLInjectedElementEnterHandler;
import org.jetbrains.yaml.smart.YAMLInjectedElementEnterHandlerKt;
import org.jetbrains.yaml.smart.YamlCoroutineScopeService;
import org.jetbrains.yaml.smart.YamlIndentPreservationUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/yaml/smart/YAMLInjectedElementEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "reformatAsync", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "linesToAdjustIndent", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "usePreviousLineIndents", "Ljava/util/TreeSet;", "getLineIndentRange", "Lcom/intellij/openapi/util/TextRange;", "line", "intellij.yaml"})
public final class YAMLInjectedElementEnterHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = CommonDataKeys.HOST_EDITOR.getData(dataContext);
        EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
        if (editorEx == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EditorEx hostEditor = editorEx;
        int caretOffset = hostEditor.getCaretModel().getOffset();
        String string = (String)YamlIndentPreservationUtilsKt.getINDENT_BEFORE_PROCESSING().get((UserDataHolder)file);
        if (string == null) {
            string = "";
        }
        String injectionIndent = string;
        RangeMarker rangeMarker = (RangeMarker)YamlIndentPreservationUtilsKt.getINJECTION_RANGE_BEFORE_ENTER().get((UserDataHolder)file);
        if (rangeMarker == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        RangeMarker pointer = rangeMarker;
        DocumentEx documentEx = hostEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (psiLanguageInjectionHost == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiLanguageInjectionHost currentInjectionHost = psiLanguageInjectionHost;
        TextRange currentHostRange = currentInjectionHost.getTextRange();
        TreeSet lines = YAMLInjectedElementEnterHandlerKt.access$linesBetween((Document)document, currentHostRange.getEndOffset(), pointer.getEndOffset());
        pointer.dispose();
        YamlIndentPreservationUtilsKt.getINJECTION_RANGE_BEFORE_ENTER().set((UserDataHolder)file, null);
        int caretLine = document.getLineNumber(caretOffset);
        lines.add(caretLine);
        TreeSet<Integer> linesToAdjustIndent = new TreeSet<Integer>();
        for (Integer line : lines) {
            boolean fix;
            Intrinsics.checkNotNull((Object)line);
            int lineStartOffset = document.getLineStartOffset(line.intValue());
            CharSequence lineChars = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line.intValue()));
            int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)lineChars, (CharSequence)injectionIndent);
            boolean bl = fix = !StringsKt.startsWith$default((CharSequence)lineChars, (CharSequence)injectionIndent, (boolean)false, (int)2, null);
            if (fix) {
                document.replaceString(lineStartOffset, lineStartOffset + commonPrefixLength, (CharSequence)injectionIndent);
                int n = caretLine;
                if (line == n) {
                    hostEditor.getCaretModel().moveToOffset(lineStartOffset + injectionIndent.length());
                }
            }
            if (!fix && (!StringsKt.isBlank((CharSequence)lineChars) || Intrinsics.areEqual(lines.last(), (Object)line))) continue;
            linesToAdjustIndent.add(line);
        }
        if (Registry.is((String)"yaml.injection.async.indent")) {
            this.usePreviousLineIndents((Document)document, linesToAdjustIndent);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildersKt.launch$default((CoroutineScope)YamlCoroutineScopeService.Companion.getCoroutineScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, document, linesToAdjustIndent, null){
                int label;
                final /* synthetic */ YAMLInjectedElementEnterHandler this$0;
                final /* synthetic */ PsiFile $file;
                final /* synthetic */ DocumentEx $document;
                final /* synthetic */ TreeSet<Integer> $linesToAdjustIndent;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$document = $document;
                    this.$linesToAdjustIndent = $linesToAdjustIndent;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Project project = this.$file.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            this.label = 1;
                            Object object3 = YAMLInjectedElementEnterHandler.access$reformatAsync(this.this$0, project, (Document)this.$document, this.$linesToAdjustIndent, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            for (Integer line : linesToAdjustIndent) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file.getProject());
                Document document2 = (Document)document;
                Document document3 = (Document)document;
                Intrinsics.checkNotNull((Object)line);
                codeStyleManager.adjustLineIndent(document2, this.getLineIndentRange(document3, line).getEndOffset());
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private final void usePreviousLineIndents(Document document, TreeSet<Integer> linesToAdjustIndent) {
        Iterator<Integer> iterator = linesToAdjustIndent.iterator();
        while (iterator.hasNext()) {
            Integer line;
            Integer n = line = iterator.next();
            if (n != null && n == 0) continue;
            TextRange prevLineIndentRange = this.getLineIndentRange(document, line - 1);
            Intrinsics.checkNotNull((Object)line);
            TextRange indentRange = this.getLineIndentRange(document, line);
            if (prevLineIndentRange.getLength() == indentRange.getLength()) continue;
            document.replaceString(indentRange.getStartOffset(), indentRange.getEndOffset(), prevLineIndentRange.subSequence(document.getCharsSequence()));
        }
    }

    private final TextRange getLineIndentRange(Document $this$getLineIndentRange, int line) {
        int lineStart = $this$getLineIndentRange.getLineStartOffset(line);
        int indentEnd = StringUtil.skipWhitespaceForward((CharSequence)$this$getLineIndentRange.getCharsSequence(), (int)lineStart);
        TextRange textRange = TextRange.create((int)lineStart, (int)indentEnd);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    private final Object reformatAsync(Project project, Document document, Iterable<Integer> linesToAdjustIndent, Continuation<? super Unit> $completion) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
        Object object = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])readConstraintArray, (Function1)((Function1)new Function1<ReadAndWriteScope, ReadResult<? extends Unit>>(linesToAdjustIndent, this, document, project, codeStyleManager){
            final /* synthetic */ Iterable<Integer> $linesToAdjustIndent;
            final /* synthetic */ YAMLInjectedElementEnterHandler this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ Project $project;
            final /* synthetic */ CodeStyleManager $codeStyleManager;
            {
                this.$linesToAdjustIndent = $linesToAdjustIndent;
                this.this$0 = $receiver;
                this.$document = $document;
                this.$project = $project;
                this.$codeStyleManager = $codeStyleManager;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ReadResult<Unit> invoke(@NotNull ReadAndWriteScope $this$constrainedReadAndWriteAction) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
                Iterable<Integer> iterable = this.$linesToAdjustIndent;
                YAMLInjectedElementEnterHandler yAMLInjectedElementEnterHandler = this.this$0;
                Document document = this.$document;
                Project project = this.$project;
                CodeStyleManager codeStyleManager = this.$codeStyleManager;
                boolean $i$f$mapNotNull = false;
                void var9_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    int line = ((Number)element$iv$iv).intValue();
                    boolean bl2 = false;
                    TextRange lineIndentRange = YAMLInjectedElementEnterHandler.access$getLineIndentRange(yAMLInjectedElementEnterHandler, document, line);
                    if (PsiDocumentManager.getInstance((Project)project).getPsiFile(document) == null) {
                        pair = null;
                    } else {
                        PsiFile psiFile;
                        Intrinsics.checkNotNull((Object)psiFile);
                        PsiFile docFile = psiFile;
                        if (codeStyleManager.getLineIndent(docFile, lineIndentRange.getEndOffset(), FormattingMode.ADJUST_INDENT) == null) {
                            pair = null;
                        } else {
                            String string;
                            Intrinsics.checkNotNull((Object)string);
                            String indent = string;
                            pair = StringUtil.equals((CharSequence)lineIndentRange.subSequence(document.getCharsSequence()), (CharSequence)indent) ? null : TuplesKt.to((Object)line, (Object)indent);
                        }
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List toAdjust = (List)destination$iv$iv;
                if (toAdjust.isEmpty()) {
                    return $this$constrainedReadAndWriteAction.value((Object)Unit.INSTANCE);
                }
                return $this$constrainedReadAndWriteAction.writeAction((Function0)new Function0<Unit>((List<Pair<Integer, String>>)toAdjust, this.this$0, this.$document){
                    final /* synthetic */ List<Pair<Integer, String>> $toAdjust;
                    final /* synthetic */ YAMLInjectedElementEnterHandler this$0;
                    final /* synthetic */ Document $document;
                    {
                        this.$toAdjust = $toAdjust;
                        this.this$0 = $receiver;
                        this.$document = $document;
                        super(0);
                    }

                    public final void invoke() {
                        CommandProcessor.getInstance().runUndoTransparentAction(() -> reformatAsync.1.invoke$lambda$0(this.$toAdjust, this.this$0, this.$document));
                    }

                    private static final void invoke$lambda$0(List $toAdjust, YAMLInjectedElementEnterHandler this$0, Document $document) {
                        Intrinsics.checkNotNullParameter((Object)$toAdjust, (String)"$toAdjust");
                        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                        for (Pair pair : $toAdjust) {
                            int line = ((Number)pair.component1()).intValue();
                            String lineIndent = (String)pair.component2();
                            TextRange indentRange = YAMLInjectedElementEnterHandler.access$getLineIndentRange(this$0, $document, line);
                            $document.replaceString(indentRange.getStartOffset(), indentRange.getEndOffset(), (CharSequence)lineIndent);
                        }
                    }
                });
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$reformatAsync(YAMLInjectedElementEnterHandler $this, Project project, Document document, Iterable linesToAdjustIndent, Continuation $completion) {
        return $this.reformatAsync(project, document, linesToAdjustIndent, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TextRange access$getLineIndentRange(YAMLInjectedElementEnterHandler $this, Document $receiver, int line) {
        return $this.getLineIndentRange($receiver, line);
    }
}

