/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.sorting.AdditionalContextFeatureProvider;
import com.intellij.completion.ml.sorting.MyEnvironment;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/sorting/ContextFactorCalculator;", "", "()V", "calculateContextFactors", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nContextFactorCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextFactorCalculator.kt\ncom/intellij/completion/ml/sorting/ContextFactorCalculator\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n17#2,6:58\n23#3:64\n*S KotlinDebug\n*F\n+ 1 ContextFactorCalculator.kt\ncom/intellij/completion/ml/sorting/ContextFactorCalculator\n*L\n27#1:58,6\n39#1:64\n*E\n"})
public final class ContextFactorCalculator {
    @NotNull
    public static final ContextFactorCalculator INSTANCE = new ContextFactorCalculator();

    private ContextFactorCalculator() {
    }

    public final void calculateContextFactors(@NotNull LookupImpl lookup, @NotNull CompletionParameters parameters, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        MyEnvironment environment = new MyEnvironment(lookup, parameters);
        LinkedHashMap<Object, MLFeatureValue> contextFeatures = new LinkedHashMap<Object, MLFeatureValue>();
        for (ContextFeatureProvider provider : ContextFeatureProvider.forLanguage((Language)storage.getLanguage())) {
            ProgressManager.checkCanceled();
            try {
                String providerName;
                Map features2;
                Intrinsics.checkNotNullExpressionValue((Object)provider.getName(), (String)"getName(...)");
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)provider.calculateFeatures((CompletionEnvironment)environment), (String)"calculateFeatures(...)");
                for (Map.Entry entry : features2.entrySet()) {
                    String featureName = (String)entry.getKey();
                    MLFeatureValue value = (MLFeatureValue)entry.getValue();
                    contextFeatures.put("ml_ctx_" + providerName + "_" + featureName, value);
                }
                long timeSpent = System.currentTimeMillis() - start$iv;
                storage.getPerformanceTracker().contextFeaturesCalculated(providerName, TimeUnit.NANOSECONDS.toMillis(timeSpent));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ContextFactorCalculator $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ContextFactorCalculator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e);
            }
        }
        for (AdditionalContextFeatureProvider contextFeatureProvider : AdditionalContextFeatureProvider.forLanguage(storage.getLanguage())) {
            contextFeatures.putAll(contextFeatureProvider.calculateFeatures((Map<String, MLFeatureValue>)contextFeatures));
        }
        storage.initContextFactors((Map<String, MLFeatureValue>)contextFeatures, environment);
    }
}

