/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.CmdStatusClientKt;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/svn/status/CmdStatusClient;", "Lorg/jetbrains/idea/svn/api/BaseSvnClient;", "Lorg/jetbrains/idea/svn/status/StatusClient;", "()V", "createInfoGetter", "Lcom/intellij/util/containers/Convertor;", "Ljava/io/File;", "Lorg/jetbrains/idea/svn/info/Info;", "doStatus", "Lorg/jetbrains/idea/svn/status/Status;", "path", "remote", "", "", "depth", "Lorg/jetbrains/idea/svn/api/Depth;", "reportAll", "includeIgnored", "collectParentExternals", "handler", "Lorg/jetbrains/idea/svn/status/StatusConsumer;", "parseResult", "base", "infoBase", "command", "Lorg/jetbrains/idea/svn/commandLine/CommandExecutor;", "Companion", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nCmdStatusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmdStatusClient.kt\norg/jetbrains/idea/svn/status/CmdStatusClient\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,294:1\n13#2:295\n*S KotlinDebug\n*F\n+ 1 CmdStatusClient.kt\norg/jetbrains/idea/svn/status/CmdStatusClient\n*L\n166#1:295\n*E\n"})
public final class CmdStatusClient
extends BaseSvnClient
implements StatusClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void doStatus(@NotNull File path, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)depth), (String)"depth");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        File file = CommandUtil.requireExistingParent(path);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"requireExistingParent(...)");
        File base = file;
        Info infoBase = this.myFactory.createInfoClient().doInfo(base, null);
        List parameters = new ArrayList();
        CmdStatusClientKt.access$putParameters(parameters, path, depth, remote, reportAll, includeIgnored);
        CommandExecutor commandExecutor = this.execute(this.myVcs, Target.Companion.on$default(Target.Companion, path, null, 2, null), SvnCommandName.st, parameters, null);
        Intrinsics.checkNotNullExpressionValue((Object)commandExecutor, (String)"execute(...)");
        CommandExecutor command = commandExecutor;
        this.parseResult(path, base, infoBase, command, handler);
    }

    @Override
    @Nullable
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref status = ref;
        this.doStatus(path, Depth.EMPTY, remote, false, false, false, arg_0 -> CmdStatusClient.doStatus$lambda$0(status, arg_0));
        return (Status)status.get();
    }

    private final void parseResult(File path, File base, Info infoBase, CommandExecutor command, StatusConsumer handler) throws SvnBindException {
        String string = command.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutput(...)");
        String result = string;
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            Object[] objectArray = new Object[]{command.getCommandText()};
            throw new SvnBindException(SvnBundle.message("error.svn.status.with.no.output", objectArray));
        }
        try {
            if (!CmdStatusClientKt.access$parseResult(base, infoBase, this.createInfoGetter(), result, handler)) {
                if (!SvnUtil.isSvnVersioned(this.myVcs, path)) {
                    LOG.info("Status requested not in working copy. Command - " + command.getCommandText() + ". Result - " + result);
                    Object[] objectArray = new Object[]{command.getCommandText()};
                    throw new SvnBindException(ErrorCode.WC_NOT_WORKING_COPY, SvnBundle.message("error.svn.status.not.in.working.copy", objectArray));
                }
                Status.Builder status = new Status.Builder(path);
                status.setItemStatus(StatusType.STATUS_NORMAL);
                status.setInfoProvider(() -> CmdStatusClient.parseResult$lambda$1(this, path));
                handler.consume(status.build());
            }
        }
        catch (JAXBException e) {
            command.logCommand();
            throw new SvnBindException(e);
        }
    }

    private final Convertor<File, Info> createInfoGetter() {
        return arg_0 -> CmdStatusClient.createInfoGetter$lambda$2(this, arg_0);
    }

    private static final void doStatus$lambda$0(Ref $status, Status it) {
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        $status.set((Object)it);
    }

    private static final Info parseResult$lambda$1(CmdStatusClient this$0, File $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return (Info)this$0.createInfoGetter().convert((Object)$path);
    }

    private static final Info createInfoGetter$lambda$2(CmdStatusClient this$0, File it) {
        Info info2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            info2 = this$0.myFactory.createInfoClient().doInfo(it, null);
        }
        catch (SvnBindException e) {
            throw new SvnExceptionWrapper(e);
        }
        return info2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CmdStatusClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/svn/status/CmdStatusClient$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "parseResult", "Lorg/jetbrains/idea/svn/status/Status;", "base", "Ljava/io/File;", "result", "", "intellij.vcs.svn"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Status parseResult(@NotNull File base, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Ref ref = new Ref();
            CmdStatusClientKt.access$parseResult(base, null, Companion::parseResult$lambda$0, result, arg_0 -> ((Ref)ref).set(arg_0));
            return (Status)ref.get();
        }

        private static final Info parseResult$lambda$0(File it) {
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

