/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JSpinnerSetValueTask;
import org.assertj.swing.driver.JSpinnerValueQuery;
import org.assertj.swing.driver.JTextComponentTextQuery;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.format.Formatting;

public class JSpinnerDriver
extends JComponentDriver {
    private static final TypeMatcher EDITOR_MATCHER = new TypeMatcher(JTextComponent.class, true);
    private static final String VALUE_PROPERTY = "value";

    public JSpinnerDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner, int times) {
        this.checkIsPositive(times, "increment the value");
        JSpinnerDriver.validateAndIncrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(@Nonnull JSpinner spinner, int times) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(spinner);
            JSpinnerDriver.incrementValue(spinner, times);
        });
    }

    @RunsInCurrentThread
    private static void incrementValue(@Nonnull JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getNextValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void increment(@Nonnull JSpinner spinner) {
        JSpinnerDriver.validateAndIncrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndIncrementValue(@Nonnull JSpinner spinner) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(spinner);
            Object newValue = spinner.getNextValue();
            if (newValue != null) {
                spinner.setValue(newValue);
            }
        });
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner, int times) {
        this.checkIsPositive(times, "decrement the value");
        JSpinnerDriver.validateAndDecrementValue(spinner, times);
        this.robot.waitForIdle();
    }

    private void checkIsPositive(int times, @Nonnull String action) {
        if (times > 0) {
            return;
        }
        String msg = String.format("The number of times to %s should be greater than zero, but was <%d>", action, times);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    private static void validateAndDecrementValue(@Nonnull JSpinner spinner, int times) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(spinner);
            JSpinnerDriver.decrementValue(spinner, times);
        });
    }

    @RunsInCurrentThread
    private static void decrementValue(@Nonnull JSpinner spinner, int times) {
        for (int i = 0; i < times; ++i) {
            Object newValue = spinner.getPreviousValue();
            if (newValue == null) {
                return;
            }
            spinner.setValue(newValue);
        }
    }

    @RunsInEDT
    public void decrement(@Nonnull JSpinner spinner) {
        JSpinnerDriver.validateAndDecrementValue(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void validateAndDecrementValue(@Nonnull JSpinner spinner) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(spinner);
            Object newValue = spinner.getPreviousValue();
            if (newValue != null) {
                spinner.setValue(newValue);
            }
        });
    }

    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JSpinner spinner) {
        JTextComponent editor2 = this.findEditor(spinner);
        if (editor2 != null) {
            return JTextComponentTextQuery.textOf(editor2);
        }
        Object value = JSpinnerValueQuery.valueOf(spinner);
        return value != null ? value.toString() : null;
    }

    @RunsInEDT
    public void enterTextAndCommit(@Nonnull JSpinner spinner, String text2) {
        this.enterText(spinner, text2);
        JSpinnerDriver.commit(spinner);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void commit(@Nonnull JSpinner spinner) {
        GuiActionRunner.execute(() -> spinner.commitEdit());
    }

    @RunsInEDT
    public void enterText(@Nonnull JSpinner spinner, @Nonnull String text2) {
        JSpinnerDriver.checkInEdtEnabledAndShowing(spinner);
        JTextComponent editor2 = this.findEditor(spinner);
        this.robot.waitForIdle();
        JSpinnerDriver.checkEditorNotNull(spinner, editor2);
        if (editor2 == null) {
            return;
        }
        this.robot.focusAndWaitForFocusGain(editor2);
        this.invokeAction(editor2, "select-all");
        this.robot.enterText(text2);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent findEditor(@Nonnull JSpinner spinner) {
        ComponentFinder finder = this.robot.finder();
        ArrayList<Component> found = Lists.newArrayList(finder.findAll((Container)spinner, EDITOR_MATCHER));
        if (found.size() != 1) {
            return null;
        }
        Component c = (Component)found.get(0);
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    @RunsInEDT
    private static void checkEditorNotNull(@Nonnull JSpinner spinner, @Nullable JTextComponent editor2) {
        GuiActionRunner.execute(() -> {
            if (editor2 == null) {
                throw ActionFailedException.actionFailure(Strings.concat("Unable to find editor for ", Formatting.format(spinner)));
            }
        });
    }

    @RunsInEDT
    public void selectValue(@Nonnull JSpinner spinner, @Nonnull Object value) {
        try {
            JSpinnerSetValueTask.setValue(spinner, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat("Value ", Strings.quote(value), " is not valid"));
        }
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public JTextComponent editor(@Nonnull JSpinner spinner) {
        return (JTextComponent)this.robot.finder().find((Container)spinner, EDITOR_MATCHER);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JSpinner spinner, Object value) {
        ((ObjectAssert)((AbstractObjectAssert)Assertions.assertThat(JSpinnerValueQuery.valueOf(spinner))).as(JSpinnerDriver.propertyName(spinner, VALUE_PROPERTY))).isEqualTo(value);
    }
}

