/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractMapSizeAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.RecursiveAssertionAssert;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.description.Description;
import org.assertj.core.error.ShouldBeUnmodifiable;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.Maps;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractMapAssert<SELF extends AbstractMapAssert<SELF, ACTUAL, K, V>, ACTUAL extends Map<K, V>, K, V>
extends AbstractObjectAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Map.Entry<? extends K, ? extends V>> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    protected AbstractMapAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF allSatisfy(BiConsumer<? super K, ? super V> entryRequirements) {
        this.maps.assertAllSatisfy(this.info, (Map)this.actual, entryRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF anySatisfy(BiConsumer<? super K, ? super V> entryRequirements) {
        this.maps.assertAnySatisfy(this.info, (Map)this.actual, entryRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF noneSatisfy(BiConsumer<? super K, ? super V> entryRequirements) {
        this.maps.assertNoneSatisfy(this.info, (Map)this.actual, entryRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.maps.assertHasSizeGreaterThan(this.info, (Map)this.actual, boundary);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.maps.assertHasSizeGreaterThanOrEqualTo(this.info, (Map)this.actual, boundary);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.maps.assertHasSizeLessThan(this.info, (Map)this.actual, boundary);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.maps.assertHasSizeLessThanOrEqualTo(this.info, (Map)this.actual, boundary);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.maps.assertHasSizeBetween(this.info, (Map)this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasSameSizeAs(Map<?, ?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF contains(Map.Entry<? extends K, ? extends V> ... entries) {
        return this.containsForProxy(entries);
    }

    protected SELF containsForProxy(Map.Entry<? extends K, ? extends V>[] entries) {
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF containsAnyOf(Map.Entry<? extends K, ? extends V> ... entries) {
        return this.containsAnyOfForProxy(entries);
    }

    protected SELF containsAnyOfForProxy(Map.Entry<? extends K, ? extends V>[] entries) {
        this.maps.assertContainsAnyOf(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsAllEntriesOf(Map<? extends K, ? extends V> other) {
        this.maps.assertContainsAllEntriesOf(this.info, (Map)this.actual, other);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsExactlyEntriesOf(Map<? extends K, ? extends V> map) {
        return this.containsExactly(this.toEntries(map));
    }

    public SELF containsExactlyInAnyOrderEntriesOf(Map<? extends K, ? extends V> map) {
        return this.containsOnly(this.toEntries(map));
    }

    private Map.Entry<? extends K, ? extends V>[] toEntries(Map<? extends K, ? extends V> map) {
        return map.entrySet().toArray(new Map.Entry[0]);
    }

    public SELF containsEntry(K key, V value) {
        this.maps.assertContains(this.info, (Map)this.actual, Arrays.array(Assertions.entry(key, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(K key, Consumer<? super V> valueRequirements) {
        this.maps.assertHasEntrySatisfying((AssertionInfo)this.info, (Map)this.actual, key, valueRequirements);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super Map.Entry<K, V>> entryCondition) {
        this.maps.assertHasEntrySatisfying(this.info, (Map)this.actual, entryCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasEntrySatisfying(Condition<? super K> keyCondition, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfyingConditions(this.info, (Map)this.actual, keyCondition, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasKeySatisfying(Condition<? super K> keyCondition) {
        this.maps.assertHasKeySatisfying(this.info, (Map)this.actual, keyCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF hasValueSatisfying(Condition<? super V> valueCondition) {
        this.maps.assertHasValueSatisfying(this.info, (Map)this.actual, valueCondition);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF doesNotContain(Map.Entry<? extends K, ? extends V> ... entries) {
        return this.doesNotContainForProxy(entries);
    }

    protected SELF doesNotContainForProxy(Map.Entry<? extends K, ? extends V>[] entries) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainEntry(K key, V value) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, Arrays.array(Assertions.entry(key, value)));
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsKey(K key) {
        return this.containsKeys(key);
    }

    @SafeVarargs
    public final SELF containsKeys(K ... keys) {
        return this.containsKeysForProxy(keys);
    }

    protected SELF containsKeysForProxy(K[] keys) {
        this.maps.assertContainsKeys(this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainKey(K key) {
        return this.doesNotContainKeys(key);
    }

    @SafeVarargs
    public final SELF doesNotContainKeys(K ... keys) {
        return this.doesNotContainKeysForProxy(keys);
    }

    protected SELF doesNotContainKeysForProxy(K[] keys) {
        this.maps.assertDoesNotContainKeys(this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF containsOnlyKeys(K ... keys) {
        return this.containsOnlyKeysForProxy(keys);
    }

    protected SELF containsOnlyKeysForProxy(K[] keys) {
        this.maps.assertContainsOnlyKeys((AssertionInfo)this.info, (Map)this.actual, keys);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsOnlyKeys(Iterable<? extends K> keys) {
        if (keys instanceof Path) {
            Iterable<? extends K> path = keys;
            this.maps.assertContainsOnlyKeys((AssertionInfo)this.info, (Map)this.actual, Collections.singleton(path));
        } else {
            this.maps.assertContainsOnlyKeys((AssertionInfo)this.info, (Map)this.actual, keys);
        }
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF containsValues(V ... values) {
        return this.containsValuesForProxy(values);
    }

    protected SELF containsValuesForProxy(V[] values) {
        this.maps.assertContainsValues(this.info, (Map)this.actual, values);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    public SELF doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF containsOnly(Map.Entry<? extends K, ? extends V> ... entries) {
        return this.containsOnlyForProxy(entries);
    }

    protected SELF containsOnlyForProxy(Map.Entry<? extends K, ? extends V>[] entries) {
        this.maps.assertContainsOnly(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @SafeVarargs
    public final SELF containsExactly(Map.Entry<? extends K, ? extends V> ... entries) {
        return this.containsExactlyForProxy(entries);
    }

    protected SELF containsExactlyForProxy(Map.Entry<? extends K, ? extends V>[] entries) {
        this.maps.assertContainsExactly(this.info, (Map)this.actual, entries);
        return (SELF)((AbstractMapAssert)this.myself);
    }

    @Beta
    public SELF isUnmodifiable() {
        this.isNotNull();
        this.assertIsUnmodifiable();
        return (SELF)((AbstractMapAssert)this.myself);
    }

    private void assertIsUnmodifiable() {
        switch (((Map)this.actual).getClass().getName()) {
            case "java.util.Collections$EmptyNavigableMap": 
            case "java.util.Collections$EmptyMap": 
            case "java.util.Collections$EmptySortedMap": 
            case "java.util.Collections$SingletonMap": {
                return;
            }
        }
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).clear(), "Map.clear()");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).compute(null, (k, v) -> v), "Map.compute(null, (k, v) -> v)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).computeIfAbsent(null, k -> null), "Map.computeIfAbsent(null, k -> null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).computeIfPresent(null, (k, v) -> v), "Map.computeIfPresent(null, (k, v) -> v)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).merge(null, null, (v1, v2) -> v1), "Map.merge(null, null, (v1, v2) -> v1))");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).put(null, null), "Map.put(null, null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).putAll(new HashMap()), "Map.putAll(new HashMap<>())");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).putIfAbsent(null, null), "Map.putIfAbsent(null, null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).replace(null, null, null), "Map.replace(null, null, null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).replace(null, null), "Map.replace(null, null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).remove(null), "Map.remove(null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).remove(null, null), "Map.remove(null, null)");
        this.expectUnsupportedOperationException(() -> ((Map)this.actual).replaceAll((k, v) -> v), "Map.replaceAll((k, v) -> v)");
        if (this.actual instanceof NavigableMap) {
            NavigableMap navigableMap = (NavigableMap)this.actual;
            this.expectUnsupportedOperationException(() -> navigableMap.pollFirstEntry(), "NavigableMap.pollFirstEntry()");
            this.expectUnsupportedOperationException(() -> navigableMap.pollLastEntry(), "NavigableMap.pollLastEntry()");
        }
    }

    private void expectUnsupportedOperationException(Runnable runnable, String method) {
        try {
            runnable.run();
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (RuntimeException e) {
            this.throwAssertionError(ShouldBeUnmodifiable.shouldBeUnmodifiable(method, e));
        }
    }

    @Override
    @Deprecated
    public SELF usingElementComparator(Comparator<? super Map.Entry<? extends K, ? extends V>> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @Deprecated
    public SELF usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @CheckReturnValue
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractMapAssert)super.as(description, args));
    }

    @Override
    @CheckReturnValue
    public SELF as(Description description) {
        return (SELF)((AbstractMapAssert)super.as(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(Description description) {
        return (SELF)((AbstractMapAssert)super.describedAs(description));
    }

    @Override
    @CheckReturnValue
    public SELF describedAs(String description, Object ... args) {
        return (SELF)((AbstractMapAssert)super.describedAs(description, args));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.has((Condition)condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractMapAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractMapAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.is((Condition)condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractMapAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        return (SELF)((AbstractMapAssert)super.isIn((Iterable)values));
    }

    @Override
    public SELF isIn(Object ... values) {
        return (SELF)((AbstractMapAssert)super.isIn(values));
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractMapAssert)super.isNot((Condition)condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        return (SELF)((AbstractMapAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public SELF isNotIn(Object ... values) {
        return (SELF)((AbstractMapAssert)super.isNotIn(values));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractMapAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractMapAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractMapAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractMapAssert)super.isSameAs(expected));
    }

    @Override
    @CheckReturnValue
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractMapAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractMapAssert)super.usingDefaultComparator());
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator, String customComparatorDescription) {
        return (SELF)((AbstractMapAssert)super.usingComparator((Comparator)customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractMapAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    @CheckReturnValue
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractMapAssert)super.withThreadDumpOnError());
    }

    @CheckReturnValue
    public AbstractMapSizeAssert<SELF, ACTUAL, K, V> size() {
        Objects.requireNonNull((Map)this.actual, "Can not perform assertions on the size of a null map.");
        return new MapSizeAssert(this, ((Map)this.actual).size());
    }

    @Deprecated
    @CheckReturnValue
    public AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> extracting(Object ... keys) {
        this.isNotNull();
        List extractedValues = Stream.of(keys).map(((Map)this.actual)::get).collect(Collectors.toList());
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(keys);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return this.newListAssertInstance(extractedValues).as(description, new Object[0]);
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extractingByKeys(K ... keys) {
        return this.extractingByKeysForProxy(keys);
    }

    protected AbstractListAssert<?, List<? extends V>, V, ObjectAssert<V>> extractingByKeysForProxy(K[] keys) {
        this.isNotNull();
        List extractedValues = Stream.of(keys).map(((Map)this.actual)::get).collect(Collectors.toList());
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(keys);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return ((AbstractListAssert)this.newListAssertInstance(extractedValues).withAssertionState(this.myself)).as(description, new Object[0]);
    }

    @Deprecated
    @CheckReturnValue
    public AbstractObjectAssert<?, ?> extracting(Object key) {
        this.isNotNull();
        Object extractedValue = ((Map)this.actual).get(key);
        String extractedPropertyOrFieldDescription = Extractors.extractedDescriptionOf(key);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertyOrFieldDescription);
        return this.newObjectAssert(extractedValue).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractObjectAssert<?, V> extractingByKey(K key) {
        return this.internalExtractingByKey(key);
    }

    @CheckReturnValue
    public <ASSERT extends AbstractAssert<?, ?>> ASSERT extractingByKey(K key, InstanceOfAssertFactory<?, ASSERT> assertFactory) {
        return this.internalExtractingByKey(key).asInstanceOf(assertFactory);
    }

    private AbstractObjectAssert<?, V> internalExtractingByKey(K key) {
        this.isNotNull();
        Object extractedValue = ((Map)this.actual).get(key);
        String extractedPropertyOrFieldDescription = Extractors.extractedDescriptionOf(key);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertyOrFieldDescription);
        return ((AbstractObjectAssert)this.newObjectAssert(extractedValue).withAssertionState(this.myself)).as(description, new Object[0]);
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> extractingFromEntries(Function<? super Map.Entry<K, V>, Object> extractor) {
        this.isNotNull();
        List extractedObjects = ((Map)this.actual).entrySet().stream().map(extractor).collect(Collectors.toList());
        return ((AbstractListAssert)this.newListAssertInstance(extractedObjects).withAssertionState(this.myself)).as(this.info.description());
    }

    @SafeVarargs
    @CheckReturnValue
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extractingFromEntries(Function<? super Map.Entry<K, V>, Object> ... extractors) {
        return this.extractingFromEntriesForProxy(extractors);
    }

    protected AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extractingFromEntriesForProxy(Function<? super Map.Entry<K, V>, Object>[] extractors) {
        this.isNotNull();
        Function<Map.Entry, Tuple> tupleExtractor = objectToExtractValueFrom -> new Tuple(Stream.of(extractors).map(extractor -> extractor.apply(objectToExtractValueFrom)).toArray());
        List extractedTuples = ((Map)this.actual).entrySet().stream().map(tupleExtractor).collect(Collectors.toList());
        return ((AbstractListAssert)this.newListAssertInstance(extractedTuples).withAssertionState(this.myself)).as(this.info.description());
    }

    @CheckReturnValue
    public AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> flatExtracting(String ... keys) {
        Tuple values = Extractors.byName(keys).apply(this.actual);
        List<Object> valuesFlattened = AbstractMapAssert.flatten(values.toList());
        String extractedPropertiesOrFieldsDescription = Extractors.extractedDescriptionOf(keys);
        String description = Description.mostRelevantDescription(this.info.description(), extractedPropertiesOrFieldsDescription);
        return this.newListAssertInstance(valuesFlattened).as(description, new Object[0]);
    }

    @Override
    @Beta
    public RecursiveComparisonAssert<?> usingRecursiveComparison() {
        return super.usingRecursiveComparison();
    }

    @Override
    public RecursiveComparisonAssert<?> usingRecursiveComparison(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        return super.usingRecursiveComparison(recursiveComparisonConfiguration);
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion() {
        return super.usingRecursiveAssertion();
    }

    @Override
    public RecursiveAssertionAssert usingRecursiveAssertion(RecursiveAssertionConfiguration recursiveAssertionConfiguration) {
        return super.usingRecursiveAssertion(recursiveAssertionConfiguration);
    }

    private static List<Object> flatten(Iterable<Object> collectionToFlatten) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object item : collectionToFlatten) {
            if (item instanceof Iterable) {
                result2.addAll(IterableUtil.toCollection((Iterable)item));
                continue;
            }
            if (Arrays.isArray(item)) {
                result2.addAll(Arrays.asList(item));
                continue;
            }
            result2.add(item);
        }
        return result2;
    }
}

