/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugStepCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
public final class DebugStepCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%debugStep";
    @NotNull
    public static final String SPAN_NAME = "debugStep";

    public DebugStepCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Companion.DebugStepTypes debugStepType = null;
        try {
            String string = this.extractCommandArgument(PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractCommandArgument(...)");
            debugStepType = Companion.DebugStepTypes.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            callback2.reject("Unknown special character. Please use: OVER, INTO or OUT");
            return;
        }
        Object[] objectArray = XDebuggerManager.getInstance((Project)context.getProject()).getDebugSessions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getDebugSessions(...)");
        Object[] debugSessions = objectArray;
        String string = debugStepType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        SpanBuilder spanBuilder = PerformanceTestSpan.TRACER.spanBuilder("debugStep_" + string).setParent(PerformanceTestSpan.getContext());
        Ref spanRef = new Ref();
        Ref scopeRef = new Ref();
        if (debugSessions.length == 0) {
            callback2.reject("Debug process was not started");
            return;
        }
        if (debugSessions.length > 1) {
            callback2.reject("Currently running " + debugSessions.length + " debug processes");
            return;
        }
        XDebugSession debugSession = (XDebugSession)ArraysKt.first((Object[])debugSessions);
        debugSession.getDebugProcess().getSession().addSessionListener(new XDebugSessionListener(callback2, (Ref<Span>)spanRef, (Ref<Scope>)scopeRef){
            final /* synthetic */ ActionCallback $callback;
            final /* synthetic */ Ref<Span> $spanRef;
            final /* synthetic */ Ref<Scope> $scopeRef;
            {
                this.$callback = $callback;
                this.$spanRef = $spanRef;
                this.$scopeRef = $scopeRef;
            }

            public void sessionPaused() {
                super.sessionPaused();
                this.$callback.setDone();
                ((Span)this.$spanRef.get()).end();
                ((Scope)this.$scopeRef.get()).close();
            }
        });
        ApplicationManager.getApplication().runWriteAction(Context.current().wrap(() -> DebugStepCommand.execute$lambda$0(spanRef, spanBuilder, scopeRef, debugStepType, debugSession)));
    }

    private static final void execute$lambda$0(Ref $spanRef, SpanBuilder $spanBuilder, Ref $scopeRef, Companion.DebugStepTypes $debugStepType, XDebugSession $debugSession) {
        Intrinsics.checkNotNullParameter((Object)$spanRef, (String)"$spanRef");
        Intrinsics.checkNotNullParameter((Object)$scopeRef, (String)"$scopeRef");
        Intrinsics.checkNotNullParameter((Object)((Object)$debugStepType), (String)"$debugStepType");
        $spanRef.set((Object)$spanBuilder.startSpan());
        $scopeRef.set((Object)((Span)$spanRef.get()).makeCurrent());
        switch (WhenMappings.$EnumSwitchMapping$0[$debugStepType.ordinal()]) {
            case 1: {
                $debugSession.stepOver(false);
                break;
            }
            case 2: {
                $debugSession.stepInto();
                break;
            }
            case 3: {
                $debugSession.stepOut();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugStepCommand$Companion;", "", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "SPAN_NAME", "DebugStepTypes", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugStepCommand$Companion$DebugStepTypes;", "", "(Ljava/lang/String;I)V", "OVER", "INTO", "OUT", "intellij.performanceTesting"})
        private static final class DebugStepTypes
        extends Enum<DebugStepTypes> {
            public static final /* enum */ DebugStepTypes OVER = new DebugStepTypes();
            public static final /* enum */ DebugStepTypes INTO = new DebugStepTypes();
            public static final /* enum */ DebugStepTypes OUT = new DebugStepTypes();
            private static final /* synthetic */ DebugStepTypes[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static DebugStepTypes[] values() {
                return (DebugStepTypes[])$VALUES.clone();
            }

            public static DebugStepTypes valueOf(String value) {
                return Enum.valueOf(DebugStepTypes.class, value);
            }

            @NotNull
            public static EnumEntries<DebugStepTypes> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = debugStepTypesArray = new DebugStepTypes[]{DebugStepTypes.OVER, DebugStepTypes.INTO, DebugStepTypes.OUT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.DebugStepTypes.values().length];
            try {
                nArray[Companion.DebugStepTypes.OVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.DebugStepTypes.INTO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.DebugStepTypes.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

