/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.backend.common.SamTypeApproximator;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegen;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegenInfo;
import org.jetbrains.kotlin.codegen.DelegatedPropertiesCodegenHelper;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmRuntimeTypes;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewVariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsOnDeclarationBodyChecker;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends KtVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{KtTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create((IElementType[])new IElementType[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.RANGE, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.IDENTIFIER})});
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptor> classStack;
    private final Stack<String> nameStack;
    private final Stack<FunctionDescriptor> functionsStack;
    private final Set<ClassDescriptor> uninitializedClasses;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;
    private final SwitchCodegenProvider switchCodegenProvider;
    private final LanguageVersionSettings languageVersionSettings;
    private final ClassBuilderMode classBuilderMode;
    private final DelegatedPropertiesCodegenHelper delegatedPropertiesCodegenHelper;
    private final JvmDefaultMode jvmDefaultMode;
    private final SamTypeApproximator samTypeApproximator;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state) {
        if (state == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.functionsStack = new Stack();
        this.uninitializedClasses = new HashSet<ClassDescriptor>();
        this.bindingTrace = state.getBindingTrace();
        this.bindingContext = state.getBindingContext();
        this.filter = state.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state.getJvmRuntimeTypes();
        this.switchCodegenProvider = new SwitchCodegenProvider(state);
        this.languageVersionSettings = state.getLanguageVersionSettings();
        this.classBuilderMode = state.getClassBuilderMode();
        this.delegatedPropertiesCodegenHelper = new DelegatedPropertiesCodegenHelper(state);
        this.jvmDefaultMode = state.getJvmDefaultMode();
        this.samTypeApproximator = new SamTypeApproximator(state.getModule().getBuiltIns(), state.getLanguageVersionSettings());
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes, @NotNull String name) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        if (callableDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (supertypes == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        return this.recordClassForCallable(element, callableDescriptor, supertypes, name, null);
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull KtElement element, @NotNull FunctionDescriptor functionDescriptor, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if (functionDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        return this.recordClassForCallable(element, functionDescriptor, this.runtimeTypes.getSupertypesForClosure(functionDescriptor), name, customContainer);
    }

    @NotNull
    private ClassDescriptor recordClassForCallable(@NotNull KtElement element, @NotNull CallableDescriptor callableDescriptor, @NotNull Collection<KotlinType> supertypes, @NotNull String name, @Nullable DeclarationDescriptor customContainer) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (callableDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        if (supertypes == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(11);
        }
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        SyntheticClassDescriptorForLambda classDescriptor = new SyntheticClassDescriptorForLambda(customContainer != null ? customContainer : this.correctContainerForLambda(callableDescriptor), Name.special((String)("<closure-" + simpleName + ">")), supertypes, element);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_CALLABLE, callableDescriptor, classDescriptor);
        SyntheticClassDescriptorForLambda syntheticClassDescriptorForLambda = classDescriptor;
        if (syntheticClassDescriptorForLambda == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        return syntheticClassDescriptorForLambda;
    }

    @NotNull
    private DeclarationDescriptor correctContainerForLambda(@NotNull CallableDescriptor descriptor) {
        ClassDescriptor classDescriptor;
        if (descriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        while (container instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(classDescriptor = ((ConstructorDescriptor)container).getConstructedClass()) && this.uninitializedClasses.contains(classDescriptor)) {
            container = classDescriptor.getContainingDeclaration();
        }
        DeclarationDescriptor declarationDescriptor = container;
        if (declarationDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        return declarationDescriptor;
    }

    @NotNull
    private String inventAnonymousClassName() {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        String string = top + "$" + (cnt + 1);
        if (string == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void visitKtElement(@NotNull KtElement element) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        super.visitKtElement(element);
        if (!this.classBuilderMode.generateBodies) {
            KotlinFileStub stub;
            if (element instanceof KtFile && (stub = ((KtFile)element).getStub()) != null) {
                for (StubElement stubElement : stub.getChildrenStubs()) {
                    stubElement.getPsi().accept((PsiElementVisitor)this);
                }
                return;
            }
            if (element instanceof KtElementImplStub && ((KtElementImplStub)element).getStub() != null && (stub = ((KtElementImplStub)element).getStub()) != null) {
                for (StubElement stubElement : stub.getChildrenStubs()) {
                    stubElement.getPsi().accept((PsiElementVisitor)this);
                }
                return;
            }
        }
        element.acceptChildren((PsiElementVisitor)this);
    }

    public void visitScript(@NotNull KtScript script) {
        ClassDescriptor scriptDescriptor;
        if (script == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        if ((scriptDescriptor = (ClassDescriptor)this.bindingContext.get(BindingContext.SCRIPT, script)) == null) {
            return;
        }
        String scriptInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(script.getFqName());
        this.recordClosure(scriptDescriptor, scriptInternalName);
        this.classStack.push((Object)scriptDescriptor);
        this.nameStack.push((Object)scriptInternalName);
        script.acceptChildren((PsiElementVisitor)this);
        this.nameStack.pop();
        this.classStack.pop();
    }

    public void visitKtFile(@NotNull KtFile file) {
        String name;
        if (file == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        if (file instanceof KtCodeFragment) {
            CodeFragmentCodegenInfo info = CodeFragmentCodegen.getCodeFragmentInfo((KtCodeFragment)file);
            name = info.getClassDescriptor().getName().asString() + "$" + info.getMethodDescriptor().getName().asString();
        } else {
            name = AsmUtil.internalNameByFqNameWithoutInnerClasses(file.getPackageFqName());
        }
        this.nameStack.push((Object)name);
        this.visitKtElement((KtElement)file);
        this.nameStack.pop();
    }

    public void visitEnumEntry(@NotNull KtEnumEntry enumEntry) {
        if (enumEntry == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        if (enumEntry.getDeclarations().isEmpty()) {
            for (KtSuperTypeListEntry specifier : enumEntry.getSuperTypeListEntries()) {
                specifier.accept((PsiElementVisitor)this);
            }
            return;
        }
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        if (descriptor == null) {
            return;
        }
        this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor);
        super.visitEnumEntry(enumEntry);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        if (declaration == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        if (!this.filter.shouldAnnotateClass((KtClassOrObject)declaration)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name);
        super.visitObjectDeclaration(declaration);
        this.nameStack.pop();
        this.classStack.pop();
    }

    public void visitClass(@NotNull KtClass klass) {
        if (klass == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        if (!this.filter.shouldAnnotateClass((KtClassOrObject)klass)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name);
        super.visitClass(klass);
        this.nameStack.pop();
        this.classStack.pop();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier((Name)classDescriptor.getName());
        if (DescriptorUtils.isTopLevelDeclaration(classDescriptor)) {
            return base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName;
        }
        return base + "$" + descriptorName.asString();
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2) {
        KtObjectDeclaration object;
        ClassDescriptor classDescriptor;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        if ((classDescriptor = this.bindingContext.get(BindingContext.CLASS, object = expression2.getObjectDeclaration())) == null) {
            super.visitObjectLiteralExpression(expression2);
            return;
        }
        String name = this.inventAnonymousClassName();
        this.recordClosure(classDescriptor, name);
        KtSuperTypeList delegationSpecifierList = object.getSuperTypeList();
        if (delegationSpecifierList != null) {
            delegationSpecifierList.accept((PsiElementVisitor)this);
        }
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        KtClassBody body = object.getBody();
        if (body != null) {
            super.visitClassBody(body);
        }
        this.nameStack.pop();
        this.classStack.pop();
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        KtFunctionLiteral functionLiteral;
        FunctionDescriptor functionDescriptor;
        if (lambdaExpression == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        if ((functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral = lambdaExpression.getFunctionLiteral())) == null) {
            return;
        }
        String name = this.inventAnonymousClassName();
        Collection<KotlinType> supertypes = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForCallable((KtElement)functionLiteral, functionDescriptor, supertypes, name);
        MutableClosure closure = this.recordClosure(classDescriptor, name);
        this.classStack.push((Object)classDescriptor);
        this.nameStack.push((Object)name);
        if (CoroutineUtilKt.isSuspendLambda(functionDescriptor)) {
            this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, true);
        }
        this.functionsStack.push((Object)functionDescriptor);
        super.visitLambdaExpression(lambdaExpression);
        this.functionsStack.pop();
        this.nameStack.pop();
        this.classStack.pop();
    }

    private boolean isAdaptedCallableReference(@NotNull KtCallableReferenceExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, boolean isSuspendConversion) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if (resolvedCall2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (isSuspendConversion) {
            return true;
        }
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        if (!(resultingDescriptor instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)resultingDescriptor;
        if (!resolvedCall2.getValueArguments().isEmpty()) {
            return true;
        }
        KotlinType callableReferenceType = this.bindingContext.getType((KtExpression)expression2);
        if (callableReferenceType != null) {
            KotlinType callableReferenceReturnType = ((TypeProjection)CollectionsKt.last(callableReferenceType.getArguments())).getType();
            KotlinType functionReturnType = functionDescriptor.getReturnType();
            return functionReturnType != null && KotlinBuiltIns.isUnit(callableReferenceReturnType) && !KotlinBuiltIns.isUnit(functionReturnType);
        }
        return false;
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
        SimpleFunctionDescriptor functionDescriptor;
        Collection<KotlinType> supertypes;
        CallableDescriptor callableDescriptor;
        KotlinType receiverType;
        ResolvedCall<? extends CallableDescriptor> referencedFunction;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(26);
        }
        if ((referencedFunction = CallUtilKt.getResolvedCall((KtElement)expression2.getCallableReference(), this.bindingContext)) == null) {
            return;
        }
        CallableDescriptor target = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        KotlinType kotlinType = dispatchReceiver != null && !(dispatchReceiver instanceof TransientReceiver) ? dispatchReceiver.getType() : (receiverType = extensionReceiver != null && !(extensionReceiver instanceof TransientReceiver) ? extensionReceiver.getType() : null);
        if (target instanceof FunctionDescriptor) {
            FunctionDescriptor targetFunction = (FunctionDescriptor)target;
            callableDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression2);
            if (callableDescriptor == null) {
                return;
            }
            KotlinType functionReferenceType = this.bindingContext.getType((KtExpression)expression2);
            boolean isSuspendConversion = !targetFunction.isSuspend() && functionReferenceType != null && FunctionTypesKt.isKSuspendFunctionType(functionReferenceType);
            supertypes = this.runtimeTypes.getSupertypesForFunctionReference(targetFunction, (AnonymousFunctionDescriptor)callableDescriptor, receiverType != null, this.isAdaptedCallableReference(expression2, referencedFunction, isSuspendConversion), isSuspendConversion);
        } else if (target instanceof PropertyDescriptor) {
            callableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, expression2);
            if (callableDescriptor == null) {
                return;
            }
            supertypes = Collections.singleton(this.runtimeTypes.getSupertypeForPropertyReference((PropertyDescriptor)target, ReflectionTypes.Companion.isNumberedKMutablePropertyType(callableDescriptor.getReturnType()), receiverType != null));
        } else {
            return;
        }
        String name = this.inventAnonymousClassName();
        ClassDescriptor classDescriptor = this.recordClassForCallable((KtElement)expression2, callableDescriptor, supertypes, name);
        MutableClosure closure = this.recordClosure(classDescriptor, name);
        if (callableDescriptor instanceof SimpleFunctionDescriptor && (functionDescriptor = (SimpleFunctionDescriptor)callableDescriptor).isSuspend()) {
            this.createAndRecordSuspendFunctionView(closure, functionDescriptor, false);
            boolean isRecursive = false;
            for (FunctionDescriptor descriptor : this.functionsStack) {
                if (descriptor != target) continue;
                isRecursive = true;
                break;
            }
            this.bindingTrace.record(CodegenBinding.RECURSIVE_SUSPEND_CALLABLE_REFERENCE, classDescriptor, isRecursive);
        }
        if (receiverType != null) {
            closure.setCustomCapturedReceiverType(receiverType);
        }
        super.visitCallableReferenceExpression(expression2);
    }

    private SimpleFunctionDescriptor createAndRecordSuspendFunctionView(MutableClosure closure, SimpleFunctionDescriptor functionDescriptor, boolean isSuspendLambda) {
        SimpleFunctionDescriptor jvmSuspendFunctionView = CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(functionDescriptor, this.bindingContext);
        this.bindingTrace.record(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, functionDescriptor, jvmSuspendFunctionView);
        closure.setSuspend(true);
        if (isSuspendLambda) {
            closure.setSuspendLambda();
        }
        return jvmSuspendFunctionView;
    }

    @NotNull
    private MutableClosure recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(27);
        }
        if (name == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        Type type = Type.getObjectType((String)JvmCodegenUtil.sanitizeNameIfNeeded(name, this.languageVersionSettings));
        MutableClosure mutableClosure = CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, this.getProperEnclosingClass(), type);
        if (mutableClosure == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(29);
        }
        return mutableClosure;
    }

    @Nullable
    private ClassDescriptor getProperEnclosingClass() {
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor fromStack = (ClassDescriptor)this.classStack.get(i);
            if (this.uninitializedClasses.contains(fromStack)) continue;
            return fromStack;
        }
        return null;
    }

    private void recordLocalVariablePropertyMetadata(LocalVariableDescriptor variableDescriptor) {
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        if (delegateType == null) {
            return;
        }
        LocalVariableDescriptor metadataVariableDescriptor = new LocalVariableDescriptor(variableDescriptor.getContainingDeclaration(), Annotations.Companion.getEMPTY(), Name.identifier((String)(variableDescriptor.getName().asString() + "$metadata")), ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(variableDescriptor)), SourceElement.NO_SOURCE);
        this.bindingTrace.record(CodegenBinding.LOCAL_VARIABLE_PROPERTY_METADATA, variableDescriptor, metadataVariableDescriptor);
    }

    public void visitProperty(@NotNull KtProperty property) {
        String nameForClassOrPackageMember;
        DeclarationDescriptor descriptor;
        if (property == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        if ((descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property)) == null) {
            return;
        }
        this.checkRuntimeAsserionsOnDeclarationBody((KtDeclaration)property, descriptor);
        if (descriptor instanceof LocalVariableDescriptor) {
            this.recordLocalVariablePropertyMetadata((LocalVariableDescriptor)descriptor);
        }
        if ((nameForClassOrPackageMember = this.getNameForClassOrPackageMember(descriptor)) != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
        } else {
            this.nameStack.push((Object)(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier((Name)property.getNameAsSafeName()).asString()));
        }
        KtPropertyDelegate delegate = property.getDelegate();
        if (delegate != null && descriptor instanceof VariableDescriptorWithAccessors) {
            VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor;
            String name = this.inventAnonymousClassName();
            KotlinType supertype = this.runtimeTypes.getSupertypeForPropertyReference(variableDescriptor, variableDescriptor.isVar(), false);
            ClassDescriptor classDescriptor = this.recordClassForCallable((KtElement)delegate, variableDescriptor, Collections.singleton(supertype), name);
            this.recordClosure(classDescriptor, name);
            if (this.delegatedPropertiesCodegenHelper.isDelegatedPropertyMetadataRequired(variableDescriptor)) {
                Type containerType = this.getMetadataOwner(property);
                List<VariableDescriptorWithAccessors> descriptors = this.bindingTrace.get(CodegenBinding.DELEGATED_PROPERTIES_WITH_METADATA, containerType);
                if (descriptors == null) {
                    descriptors = new ArrayList<VariableDescriptorWithAccessors>(1);
                    this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTIES_WITH_METADATA, containerType, descriptors);
                }
                descriptors.add(variableDescriptor);
                this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, variableDescriptor, containerType);
            } else {
                this.bindingTrace.record(CodegenBinding.DELEGATED_PROPERTY_WITH_OPTIMIZED_METADATA, variableDescriptor);
            }
        }
        super.visitProperty(property);
        this.nameStack.pop();
    }

    private void checkRuntimeAsserionsOnDeclarationBody(@NotNull KtDeclaration declaration, DeclarationDescriptor descriptor) {
        if (declaration == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        if (this.classBuilderMode.generateBodies) {
            RuntimeAssertionsOnDeclarationBodyChecker.check((KtDeclaration)declaration, (DeclarationDescriptor)descriptor, (BindingTrace)this.bindingTrace, (LanguageVersionSettings)this.languageVersionSettings);
        }
    }

    @NotNull
    private Type getMetadataOwner(@NotNull KtProperty property) {
        if (property == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(32);
        }
        for (int i = this.classStack.size() - 1; i >= 0; --i) {
            ClassDescriptor descriptor = (ClassDescriptor)this.classStack.get(i);
            if (descriptor instanceof SyntheticClassDescriptorForLambda) continue;
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor);
            if (classId == null) {
                Type type = CodegenBinding.getAsmType(this.bindingContext, descriptor);
                if (type == null) {
                    CodegenAnnotatingVisitor.$$$reportNull$$$0(33);
                }
                return type;
            }
            Type type = AsmUtil.asmTypeByClassId(DescriptorUtils.isInterface(descriptor) && !this.jvmDefaultMode.isEnabled() ? classId.createNestedClassId(Name.identifier((String)"DefaultImpls")) : classId);
            if (type == null) {
                CodegenAnnotatingVisitor.$$$reportNull$$$0(34);
            }
            return type;
        }
        Type type = Type.getObjectType((String)JvmFileClassUtil.getFileClassInternalName((KtFile)property.getContainingKtFile()));
        if (type == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(35);
        }
        return type;
    }

    public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
        PropertyAccessorDescriptor accessorDescriptor;
        if (accessor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(36);
        }
        if ((accessorDescriptor = this.bindingContext.get(BindingContext.PROPERTY_ACCESSOR, accessor)) != null) {
            this.checkRuntimeAsserionsOnDeclarationBody((KtDeclaration)accessor, accessorDescriptor);
        }
        super.visitPropertyAccessor(accessor);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        FunctionDescriptor functionDescriptor;
        if (function2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(37);
        }
        if ((functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2)) == null) {
            return;
        }
        this.checkRuntimeAsserionsOnDeclarationBody((KtDeclaration)function2, functionDescriptor);
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (functionDescriptor instanceof SimpleFunctionDescriptor && functionDescriptor.isSuspend() && !functionDescriptor.getVisibility().equals(DescriptorVisibilities.LOCAL)) {
            if (nameForClassOrPackageMember != null) {
                this.nameStack.push((Object)nameForClassOrPackageMember);
            }
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction((KtElement)function2, functionDescriptor, name, functionDescriptor);
            MutableClosure closure = this.recordClosure(classDescriptor, name);
            SimpleFunctionDescriptor jvmSuspendFunctionView = this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, false);
            for (Pair parameterDescriptorPair : CollectionsKt.zip(functionDescriptor.getValueParameters(), jvmSuspendFunctionView.getValueParameters())) {
                this.bindingTrace.record(CodegenBinding.PARAMETER_SYNONYM, parameterDescriptorPair.getFirst(), parameterDescriptorPair.getSecond());
            }
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            if (nameForClassOrPackageMember != null) {
                this.nameStack.pop();
            }
            return;
        }
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push((Object)nameForClassOrPackageMember);
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName();
            ClassDescriptor classDescriptor = this.recordClassForFunction((KtElement)function2, functionDescriptor, name, null);
            MutableClosure closure = this.recordClosure(classDescriptor, name);
            this.classStack.push((Object)classDescriptor);
            this.nameStack.push((Object)name);
            if (functionDescriptor instanceof SimpleFunctionDescriptor && functionDescriptor.isSuspend()) {
                this.createAndRecordSuspendFunctionView(closure, (SimpleFunctionDescriptor)functionDescriptor, true);
            }
            this.functionsStack.push((Object)functionDescriptor);
            super.visitNamedFunction(function2);
            this.functionsStack.pop();
            this.nameStack.pop();
            this.classStack.pop();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(38);
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name = SpecialNames.safeIdentifier((Name)descriptor.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor);
            assert (containingFile != null) : "File not found for " + descriptor;
            return JvmFileClassUtil.getFileClassInternalName((KtFile)containingFile) + '$' + name;
        }
        return null;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(39);
        }
        super.visitCallExpression(expression2);
        this.checkSamCall((KtCallElement)expression2);
        this.checkCrossinlineCall(expression2);
    }

    private void checkCrossinlineCall(@NotNull KtCallExpression expression2) {
        VariableAsFunctionResolvedCall variableAsFunction;
        VariableDescriptor variableDescriptor;
        KtExpression callee;
        Call call2;
        ResolvedCall<?> resolvedCall2;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(40);
        }
        if ((resolvedCall2 = this.bindingContext.get(BindingContext.RESOLVED_CALL, call2 = this.bindingContext.get(BindingContext.CALL, callee = expression2.getCalleeExpression()))) instanceof VariableAsFunctionResolvedCall && (variableDescriptor = (variableAsFunction = (VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor()) instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)variableDescriptor).isCrossinline()) {
            DeclarationDescriptor functionWithCrossinlineParameter = variableDescriptor.getContainingDeclaration();
            if (((FunctionDescriptor)this.functionsStack.peek()).isSuspend()) {
                this.bindingTrace.record(CodegenBinding.CALL_SITE_IS_SUSPEND_FOR_CROSSINLINE_LAMBDA, (ValueParameterDescriptor)variableDescriptor, true);
            }
            for (int i = this.functionsStack.size() - 1; i >= 0; --i) {
                Boolean alreadyPutValue = this.bindingTrace.getBindingContext().get(CodegenBinding.CAPTURES_CROSSINLINE_LAMBDA, this.functionsStack.get(i));
                if (alreadyPutValue != null && alreadyPutValue.booleanValue()) {
                    return;
                }
                this.bindingTrace.record(CodegenBinding.CAPTURES_CROSSINLINE_LAMBDA, this.functionsStack.get(i), true);
                if (this.functionsStack.get(i) != functionWithCrossinlineParameter) continue;
                return;
            }
        }
    }

    private void checkSamCall(@NotNull KtCallElement expression2) {
        ResolvedCall<? extends CallableDescriptor> call2;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(41);
        }
        if ((call2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.bindingContext)) == null) {
            return;
        }
        CallableDescriptor descriptor = call2.getResultingDescriptor();
        if (!(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        this.recordSamValuesForNewInference(call2);
        this.recordSamConstructorIfNeeded(expression2, call2);
        this.recordSamValuesForOldInference(call2, descriptor);
    }

    private void recordSamValuesForOldInference(ResolvedCall<?> call2, CallableDescriptor descriptor) {
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor);
        if (original == null) {
            return;
        }
        SmartList valueParametersWithSAMConversion = new SmartList();
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            ValueParameterDescriptor adaptedParameter = descriptor.getValueParameters().get(valueParameter.getIndex());
            if (KotlinTypeChecker.DEFAULT.equalTypes(adaptedParameter.getType(), valueParameter.getType())) continue;
            valueParametersWithSAMConversion.add(valueParameter);
        }
        this.writeSamValueForValueParameters((Collection<ValueParameterDescriptor>)valueParametersWithSAMConversion, call2.getValueArgumentsByIndex());
    }

    private void recordSamValuesForNewInference(@NotNull ResolvedCall<?> call2) {
        NewAbstractResolvedCall<?> newResolvedCall;
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(42);
        }
        if (!((newResolvedCall = CodegenAnnotatingVisitor.getNewResolvedCallForCallWithPossibleSamConversions(call2)) instanceof NewResolvedCallImpl)) {
            return;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> arguments = newResolvedCall.getValueArguments();
        for (ValueParameterDescriptor valueParameter : arguments.keySet()) {
            ResolvedValueArgument argument = arguments.get(valueParameter);
            if (argument instanceof ExpressionValueArgument) {
                ValueArgument valueArgument = ((ExpressionValueArgument)argument).getValueArgument();
                if (valueArgument == null || ((NewResolvedCallImpl)newResolvedCall).getExpectedTypeForSamConvertedArgument(valueArgument) == null) continue;
                this.recordSamTypeOnArgumentExpression(valueParameter, valueArgument);
                continue;
            }
            if (!(argument instanceof VarargValueArgument)) continue;
            VarargValueArgument varargValueArgument = (VarargValueArgument)argument;
            for (ValueArgument valueArgument : varargValueArgument.getArguments()) {
                if (valueArgument == null || ((NewResolvedCallImpl)newResolvedCall).getExpectedTypeForSamConvertedArgument(valueArgument) == null) continue;
                this.recordSamTypeOnArgumentExpression(valueParameter, valueArgument);
            }
        }
    }

    @Nullable
    private static NewAbstractResolvedCall<?> getNewResolvedCallForCallWithPossibleSamConversions(@NotNull ResolvedCall<?> call2) {
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(43);
        }
        if (call2 instanceof NewVariableAsFunctionResolvedCallImpl) {
            return ((NewVariableAsFunctionResolvedCallImpl)call2).getFunctionCall();
        }
        if (call2 instanceof NewResolvedCallImpl) {
            return (NewResolvedCallImpl)call2;
        }
        return null;
    }

    @Nullable
    private SamType createSamType(KotlinType kotlinType) {
        if (!JavaSingleAbstractMethodUtils.isSamType((KotlinType)kotlinType)) {
            return null;
        }
        return new SamType(kotlinType);
    }

    @Nullable
    private SamType createSamTypeByValueParameter(ValueParameterDescriptor valueParameterDescriptor) {
        KotlinType kotlinSamType = this.samTypeApproximator.getSamTypeForValueParameter(valueParameterDescriptor, false);
        if (kotlinSamType == null) {
            return null;
        }
        if (!JavaSingleAbstractMethodUtils.isSamType((KotlinType)kotlinSamType)) {
            return null;
        }
        return new SamType(kotlinSamType);
    }

    private void writeSamValueForValueParameters(@NotNull Collection<ValueParameterDescriptor> valueParametersWithSAMConversion, @Nullable List<ResolvedValueArgument> valueArguments) {
        if (valueParametersWithSAMConversion == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(44);
        }
        if (valueArguments == null) {
            return;
        }
        for (ValueParameterDescriptor valueParameter : valueParametersWithSAMConversion) {
            SamType samType = this.createSamTypeByValueParameter(valueParameter);
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            this.recordSamTypeOnArgumentExpression(samType, valueArgument);
        }
    }

    private void recordSamTypeOnArgumentExpression(ValueParameterDescriptor valueParameter, ValueArgument valueArgument) {
        SamType samType = this.createSamTypeByValueParameter(valueParameter);
        if (samType == null) {
            return;
        }
        this.recordSamTypeOnArgumentExpression(samType, valueArgument);
    }

    private void recordSamTypeOnArgumentExpression(SamType samType, ValueArgument valueArgument) {
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : valueArgument.asElement().getText();
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call2) {
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(45);
        }
        if (!CodegenAnnotatingVisitor.isSuperTypeCallForAnonymousObject(call2)) {
            this.withinUninitializedClass((KtElement)call2, () -> super.visitSuperTypeCallEntry(call2));
        } else {
            super.visitSuperTypeCallEntry(call2);
        }
        this.checkSamCall((KtCallElement)call2);
    }

    private static boolean isSuperTypeCallForAnonymousObject(@NotNull KtSuperTypeCallEntry call2) {
        PsiElement parent2;
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(46);
        }
        if (!((parent2 = call2.getParent()) instanceof KtSuperTypeList)) {
            return false;
        }
        if (!((parent2 = parent2.getParent()) instanceof KtObjectDeclaration)) {
            return false;
        }
        return (parent2 = parent2.getParent()) instanceof KtObjectLiteralExpression;
    }

    public void visitConstructorDelegationCall(@NotNull KtConstructorDelegationCall call2) {
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(47);
        }
        this.withinUninitializedClass((KtElement)call2, () -> super.visitConstructorDelegationCall(call2));
        this.checkSamCall((KtCallElement)call2);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        PsiElement parent2;
        if (parameter == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(48);
        }
        if ((parent2 = parameter.getParent()) != null && parent2.getParent() instanceof KtConstructor) {
            KtExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                this.withinUninitializedClass((KtElement)defaultValue, () -> defaultValue.accept((PsiElementVisitor)this));
            }
        } else {
            super.visitParameter(parameter);
        }
    }

    private void withinUninitializedClass(@NotNull KtElement element, @NotNull Runnable operation) {
        if (element == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(49);
        }
        if (operation == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(50);
        }
        ClassDescriptor currentClass = CodegenAnnotatingVisitor.peekFromStack(this.classStack);
        assert (currentClass != null) : element.getClass().getSimpleName() + " should be inside a class: " + element.getText();
        assert (!this.uninitializedClasses.contains(currentClass)) : "Class entered twice: " + currentClass;
        this.uninitializedClasses.add(currentClass);
        operation.run();
        boolean removed = this.uninitializedClasses.remove(currentClass);
        assert (removed) : "Inconsistent uninitialized class stack: " + currentClass;
    }

    private void recordSamConstructorIfNeeded(@NotNull KtCallElement expression2, @NotNull ResolvedCall<?> call2) {
        Object callableDescriptor;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(51);
        }
        if (call2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(52);
        }
        if (!((callableDescriptor = call2.getResultingDescriptor()).getOriginal() instanceof SamConstructorDescriptor)) {
            return;
        }
        List<ResolvedValueArgument> valueArguments = call2.getValueArgumentsByIndex();
        if (valueArguments == null || valueArguments.size() != 1) {
            return;
        }
        ResolvedValueArgument valueArgument = valueArguments.get(0);
        if (!(valueArgument instanceof ExpressionValueArgument)) {
            return;
        }
        ValueArgument argument = ((ExpressionValueArgument)valueArgument).getValueArgument();
        if (argument == null) {
            return;
        }
        KtExpression argumentExpression = argument.getArgumentExpression();
        this.bindingTrace.record(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2, argumentExpression);
        SamType samType = this.createSamType(callableDescriptor.getReturnType());
        this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        FunctionDescriptor original;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(53);
        }
        super.visitBinaryExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.bindingContext);
        if (resolvedCall2 != null) {
            this.recordSamValuesForNewInference(resolvedCall2);
        }
        if ((original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor)) == null) {
            return;
        }
        SamType samType = this.createSamTypeByValueParameter(original.getValueParameters().get(0));
        if (samType == null) {
            return;
        }
        IElementType token = expression2.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getRight(), samType);
        } else if (token == KtTokens.IN_KEYWORD || token == KtTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression2.getLeft(), samType);
        }
    }

    public void visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(54);
        }
        super.visitArrayAccessExpression(expression2);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)expression2, this.bindingContext);
        if (resolvedCall2 != null) {
            this.recordSamValuesForNewInference(resolvedCall2);
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List indexExpressions = expression2.getIndexExpressions();
        List<ValueParameterDescriptor> parameters = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters) {
            SamType samType = this.createSamTypeByValueParameter(valueParameter);
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters.size() - 1) {
                PsiElement parent2 = expression2.getParent();
                if (!(parent2 instanceof KtBinaryExpression) || ((KtBinaryExpression)parent2).getOperationToken() != KtTokens.EQ) continue;
                KtExpression right = ((KtBinaryExpression)parent2).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            KtExpression indexExpression = (KtExpression)indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(55);
        }
        super.visitWhenExpression(expression2);
        if (!this.isWhenWithEnums(expression2)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression2.getContainingKtFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings2 = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings2 != null) : "guaranteed by contract";
        int fieldNumber = mappings2.size();
        assert (expression2.getSubjectExpression() != null) : "subject expression should be not null in a valid when by enums";
        KotlinType type = WhenChecker.whenSubjectType(expression2, this.bindingContext);
        assert (type != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        boolean isPublicAbi = false;
        for (FunctionDescriptor descriptor : this.functionsStack) {
            if (!descriptor.isInline()) continue;
            isPublicAbi = !DescriptorVisibilities.isPrivate(descriptor.getVisibility());
            break;
        }
        WhenByEnumsMapping mapping = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber, isPublicAbi);
        for (ConstantValue<?> constant : this.switchCodegenProvider.getAllConstants(expression2)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping.putFirstTime((EnumValue)constant, mapping.size() + 1);
        }
        mappings2.add(mapping);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression2, mapping);
    }

    private boolean isWhenWithEnums(@NotNull KtWhenExpression expression2) {
        ClassId enumClassId;
        if (expression2 == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(56);
        }
        if ((enumClassId = WhenChecker.getClassIdForEnumSubject(expression2, this.bindingContext)) == null) {
            return false;
        }
        return this.switchCodegenProvider.checkAllItemsAreConstantsSatisfying(expression2, constant -> CodegenAnnotatingVisitor.isEnumEntryOrNull(enumClassId, constant));
    }

    private static boolean isEnumEntryOrNull(ClassId enumClassId, ConstantValue<?> constant) {
        return constant instanceof EnumValue && ((EnumValue)constant).getEnumClassId().equals((Object)enumClassId) || constant instanceof NullValue;
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull KtFile file) {
        if (file == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(57);
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = (ClassDescriptor)iterator2.previous();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                CodegenAnnotatingVisitor.$$$reportNull$$$0(58);
            }
            return string;
        }
        String string = JvmFileClassUtil.getFacadeClassInternalName((KtFile)file);
        if (string == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(59);
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            CodegenAnnotatingVisitor.$$$reportNull$$$0(60);
        }
        return (T)(stack.empty() ? null : stack.peek());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 16: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableDescriptor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor";
                break;
            }
            case 13: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 18: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumEntry";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 39: 
            case 40: 
            case 41: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParametersWithSAMConversion";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/binding/CodegenAnnotatingVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClassForCallable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "correctContainerForLambda";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "inventAnonymousClassName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "recordClosure";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataOwner";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTopLevelClassOrPackagePartInternalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "recordClassForCallable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recordClassForFunction";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 58: 
            case 59: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "correctContainerForLambda";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitScript";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitKtFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumEntry";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAdaptedCallableReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "recordClosure";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkRuntimeAsserionsOnDeclarationBody";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataOwner";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitPropertyAccessor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNameForClassOrPackageMember";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkCrossinlineCall";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkSamCall";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "recordSamValuesForNewInference";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNewResolvedCallForCallWithPossibleSamConversions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "writeSamValueForValueParameters";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperTypeCallEntry";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isSuperTypeCallForAnonymousObject";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorDelegationCall";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitParameter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "withinUninitializedClass";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "recordSamConstructorIfNeeded";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isWhenWithEnums";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTopLevelClassOrPackagePartInternalName";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "peekFromStack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

