/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.io.FileAccessorCache;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystemKt;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\"\b\u0002\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0017\u001a\u00020\rH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0006\u0010\u001f\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u0005R%\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012j\u0002`\u00140\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "unmapBuffer", "Lkotlin/Function1;", "Ljava/nio/MappedByteBuffer;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getUnmapBuffer$cli_base", "()Lkotlin/jvm/functions/Function1;", "myHandlers", "", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarHandler;", "cachedOpenFileHandles", "Lcom/intellij/util/io/FileAccessorCache;", "Ljava/io/File;", "Lkotlin/Pair;", "Ljava/io/RandomAccessFile;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/RandomAccessFileAndBuffer;", "getCachedOpenFileHandles$cli_base", "()Lcom/intellij/util/io/FileAccessorCache;", "getProtocol", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "clearHandlersCache", "cleanOpenFilesCache", "Companion", "cli-base"})
public final class FastJarFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final Map<String, FastJarHandler> myHandlers;
    @NotNull
    private final FileAccessorCache<File, Pair<RandomAccessFile, MappedByteBuffer>> cachedOpenFileHandles;

    private FastJarFileSystem(Function1<? super MappedByteBuffer, Unit> unmapBuffer) {
        this.unmapBuffer = unmapBuffer;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> FastJarFileSystem.myHandlers$lambda$1(arg_0 -> FastJarFileSystem.myHandlers$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.myHandlers = concurrentMap;
        this.cachedOpenFileHandles = (FileAccessorCache)new FileAccessorCache<File, Pair<? extends RandomAccessFile, ? extends MappedByteBuffer>>(this){
            final /* synthetic */ FastJarFileSystem this$0;
            {
                this.this$0 = $receiver;
                super(20, 10);
            }

            protected Pair<RandomAccessFile, MappedByteBuffer> createAccessor(File file) throws IOException {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                return new Pair((Object)randomAccessFile, (Object)randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length()));
            }

            protected void disposeAccessor(Pair<? extends RandomAccessFile, ? extends MappedByteBuffer> fileAccessor) throws IOException {
                Intrinsics.checkNotNullParameter(fileAccessor, (String)"fileAccessor");
                ((RandomAccessFile)fileAccessor.getFirst()).close();
                this.this$0.getUnmapBuffer$cli_base().invoke(fileAccessor.getSecond());
            }

            public boolean isEqual(File val1, File val2) {
                Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
                Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
                return Intrinsics.areEqual((Object)val1, (Object)val2);
            }
        };
    }

    @NotNull
    public final Function1<MappedByteBuffer, Unit> getUnmapBuffer$cli_base() {
        return this.unmapBuffer;
    }

    @NotNull
    public final FileAccessorCache<File, Pair<RandomAccessFile, MappedByteBuffer>> getCachedOpenFileHandles$cli_base() {
        return this.cachedOpenFileHandles;
    }

    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Couple<String> pair = Companion.splitPath(path);
        FastJarHandler fastJarHandler = this.myHandlers.get(pair.first);
        Intrinsics.checkNotNull((Object)fastJarHandler);
        Object object = pair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        return fastJarHandler.findFileByPath((String)object);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    public final void clearHandlersCache() {
        this.myHandlers.clear();
        this.cleanOpenFilesCache();
    }

    public final void cleanOpenFilesCache() {
        this.cachedOpenFileHandles.clear();
    }

    private static final FastJarHandler myHandlers$lambda$0(FastJarFileSystem this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new FastJarHandler(this$0, key);
    }

    private static final FastJarHandler myHandlers$lambda$1(Function1 $tmp0, Object p0) {
        return (FastJarHandler)$tmp0.invoke(p0);
    }

    public /* synthetic */ FastJarFileSystem(Function1 unmapBuffer, DefaultConstructorMarker $constructor_marker) {
        this((Function1<? super MappedByteBuffer, Unit>)unmapBuffer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem$Companion;", "", "<init>", "()V", "splitPath", "Lcom/intellij/openapi/util/Couple;", "", "path", "createIfUnmappingPossible", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem;", "cli-base"})
    @SourceDebugExtension(value={"SMAP\nFastJarFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastJarFileSystem.kt\norg/jetbrains/kotlin/cli/jvm/compiler/jarfs/FastJarFileSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Couple<String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int separator = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (!(separator >= 0)) {
                boolean $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = false;
                String $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = "Path in JarFileSystem must contain a separator: " + path;
                throw new IllegalArgumentException($i$a$-require-FastJarFileSystem$Companion$splitPath$22.toString());
            }
            String string = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String localPath = string;
            String string2 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String pathInJar = string2;
            Couple couple = Couple.of((Object)localPath, (Object)pathInJar);
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
            return couple;
        }

        @Nullable
        public final FastJarFileSystem createIfUnmappingPossible() {
            Function1 function1 = FastJarFileSystemKt.access$prepareCleanerCallback();
            if (function1 == null) {
                return null;
            }
            Function1 cleanerCallBack = function1;
            return new FastJarFileSystem(cleanerCallBack, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

