/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SwitchExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            SwitchExpressionFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_SWITCH_EXPRESSION) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_SWITCH_STATEMENT)) {
            Document doc = editor.getDocument();
            ASTNode rParenth = BasicJavaAstTreeUtil.getRParenth(astNode);
            ASTNode lParenth = BasicJavaAstTreeUtil.getLParenth(astNode);
            ASTNode condition = BasicJavaAstTreeUtil.getExpression(astNode);
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(astNode.getTextRange().getStartOffset()));
                    ASTNode block = BasicJavaAstTreeUtil.getCodeBlock(astNode);
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    doc.replaceString(astNode.getTextRange().getStartOffset(), stopOffset, (CharSequence)"switch ()");
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/SwitchExpressionFixer", "apply"));
    }
}

