/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodConflictUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

class GrChangeSignatureConflictSearcher {
    private static final Logger LOG = Logger.getInstance(GrChangeSignatureConflictSearcher.class);
    private final JavaChangeInfo myChangeInfo;

    GrChangeSignatureConflictSearcher(JavaChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    public MultiMap<PsiElement, String> findConflicts(Ref<UsageInfo[]> refUsages) {
        MultiMap conflictDescriptions = new MultiMap();
        this.addMethodConflicts((MultiMap<PsiElement, String>)conflictDescriptions);
        Object[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        HashSet usagesSet = ContainerUtil.newHashSet((Object[])usagesIn);
        RenameUtil.removeConflictUsages((Set)usagesSet);
        if (this.myChangeInfo.isVisibilityChanged()) {
            try {
                this.addInaccessibilityDescriptions(usagesSet, (MultiMap<PsiElement, String>)conflictDescriptions);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return conflictDescriptions;
    }

    private boolean needToChangeCalls() {
        return this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged();
    }

    private void addInaccessibilityDescriptions(Set<UsageInfo> usages, MultiMap<PsiElement, String> conflictDescriptions) throws IncorrectOperationException {
        PsiMethod method = this.myChangeInfo.getMethod();
        PsiModifierList modifierList = (PsiModifierList)method.getModifierList().copy();
        VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)this.myChangeInfo.getNewVisibility());
        Iterator<UsageInfo> iterator2 = usages.iterator();
        while (iterator2.hasNext()) {
            PsiResolveHelper helper;
            UsageInfo usageInfo = iterator2.next();
            PsiElement element = usageInfo.getElement();
            if (element == null || !(element instanceof GrReferenceExpression)) continue;
            PsiClass accessObjectClass = null;
            GrExpression qualifier = ((GrReferenceExpression)element).getQualifierExpression();
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
            }
            if ((helper = JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper()).isAccessible((PsiMember)method, modifierList, element, accessObjectClass, null)) continue;
            String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true), this.myChangeInfo.getNewVisibility(), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)element), (boolean)true)});
            conflictDescriptions.putValue((Object)method, (Object)message);
            if (this.needToChangeCalls()) continue;
            iterator2.remove();
        }
    }

    private void addMethodConflicts(MultiMap<PsiElement, String> conflicts) {
        try {
            JavaParameterInfo[] parameters2;
            PsiMethod method = this.myChangeInfo.getMethod();
            if (!(method instanceof GrMethod)) {
                return;
            }
            PsiManager manager = method.getManager();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(manager.getProject());
            CanonicalTypes.Type returnType2 = this.myChangeInfo.getNewReturnType();
            String newMethodName = this.myChangeInfo.getNewName();
            GrMethod prototype = method.isConstructor() ? factory.createConstructorFromText("foo", ArrayUtilRt.EMPTY_STRING_ARRAY, ArrayUtilRt.EMPTY_STRING_ARRAY, "{}", (PsiElement)method) : factory.createMethodFromText("", "foo", returnType2 != null ? returnType2.getTypeText() : null, ArrayUtilRt.EMPTY_STRING_ARRAY, (PsiElement)method);
            prototype.setName(newMethodName);
            for (JavaParameterInfo info : parameters2 = this.myChangeInfo.getNewParameters()) {
                GrParameter param = info instanceof GrParameterInfo ? factory.createParameter(info.getName(), info.getTypeText(), ((GrParameterInfo)info).getDefaultInitializer(), (GroovyPsiElement)method, new String[0]) : factory.createParameter(info.getName(), info.getTypeText(), (GroovyPsiElement)method);
                prototype.getParameterList().add(param);
            }
            ConflictsUtil.checkMethodConflicts((PsiClass)method.getContainingClass(), (PsiMethod)method, (PsiMethod)prototype, conflicts);
            GrMethodConflictUtil.checkMethodConflicts(method.getContainingClass(), prototype, (GrMethod)method, conflicts, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

