/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;

public final class GrDefaultMethodComparator
extends GrMethodComparator {
    @Override
    public Boolean dominated(@NotNull GroovyMethodResult result1, @NotNull GroovyMethodResult result2, @NotNull GrMethodComparator.Context context) {
        PsiType returnType2;
        PsiType returnType1;
        if (result1 == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(2);
        }
        PsiMethod method1 = result1.getElement();
        PsiSubstitutor substitutor1 = result1.getContextSubstitutor();
        PsiElement resolveContext1 = result1.getCurrentFileResolveContext();
        PsiMethod method2 = result2.getElement();
        PsiSubstitutor substitutor2 = result2.getContextSubstitutor();
        PsiElement resolveContext2 = result2.getCurrentFileResolveContext();
        List<Argument> arguments2 = context.getArguments();
        if (context.isConstructor() && arguments2 != null && arguments2.size() == 1) {
            if (method1.getParameterList().isEmpty()) {
                return true;
            }
            if (method2.getParameterList().isEmpty()) {
                return false;
            }
        }
        Object[] params1 = method1.getParameterList().getParameters();
        Object[] params2 = method2.getParameterList().getParameters();
        if (arguments2 != null && arguments2.size() == 0 && params2.length == 1 && params2[0].getType() instanceof PsiArrayType) {
            return true;
        }
        if (arguments2 == null && params1.length != params2.length) {
            return false;
        }
        if (params1.length < params2.length) {
            PsiParameter last = (PsiParameter)ArrayUtil.getLastElement((Object[])params1);
            return last != null && last.getType() instanceof PsiArrayType;
        }
        if (params1.length > params2.length) {
            PsiParameter last = (PsiParameter)ArrayUtil.getLastElement((Object[])params2);
            return last == null || !(last.getType() instanceof PsiArrayType);
        }
        PsiElement myPlace = context.getPlace();
        for (int i2 = 0; i2 < params2.length; ++i2) {
            PsiType argType;
            PsiType pType1 = params1[i2].getType();
            PsiType pType2 = params2[i2].getType();
            PsiType type1 = substitutor1.substitute(pType1);
            PsiType type2 = substitutor2.substitute(pType2);
            if (arguments2 != null && arguments2.size() > i2 && (argType = arguments2.get(i2).getType()) != null) {
                boolean converts2;
                boolean converts1 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type1), argType);
                if (converts1 != (converts2 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type2), argType))) {
                    return converts2;
                }
                if (TypesUtil.resolvesTo(type1, "java.util.concurrent.Callable") && TypesUtil.resolvesTo(type2, "java.lang.Runnable") && InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.GroovyCallable")) {
                    return true;
                }
            }
            if (!GrDefaultMethodComparator.typesAgree(TypeConversionUtil.erasure((PsiType)pType1), TypeConversionUtil.erasure((PsiType)pType2), context)) {
                return false;
            }
            if (resolveContext1 != null && resolveContext2 == null) {
                return !TypesUtil.resolvesTo(type1, "java.lang.Object") || !TypesUtil.resolvesTo(type2, "java.lang.Object");
            }
            if (resolveContext1 != null || resolveContext2 == null) continue;
            return true;
        }
        if (!(method1 instanceof SyntheticElement) && !(method2 instanceof SyntheticElement) && !TypesUtil.isAssignableWithoutConversions(returnType1 = substitutor1.substitute(method1.getReturnType()), returnType2 = substitutor2.substitute(method2.getReturnType())) && TypesUtil.isAssignableWithoutConversions(returnType2, returnType1)) {
            return false;
        }
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod) {
            PsiType firstReceiverType = ((GrGdkMethod)method1).getReceiverType();
            PsiType secondReceiverType = ((GrGdkMethod)method2).getReceiverType();
            if (!GrDefaultMethodComparator.typesAgree(TypeConversionUtil.erasure((PsiType)firstReceiverType), TypeConversionUtil.erasure((PsiType)secondReceiverType), context)) {
                return false;
            }
        }
        return true;
    }

    private static boolean typesAgree(@NotNull PsiType type1, @NotNull PsiType type2, @NotNull GrMethodComparator.Context context) {
        if (type1 == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(3);
        }
        if (type2 == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            GrDefaultMethodComparator.$$$reportNull$$$0(5);
        }
        boolean hasArguments = context.getArguments() != null;
        return hasArguments ? TypesUtil.isAssignableWithoutConversions(type1, type2) : type1.equals(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result2";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "dominated";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "typesAgree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

