/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodMergingContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GrMethodMergingContributor
extends CompletionContributor {
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        CompletionParameters parameters2;
        if (context == null) {
            GrMethodMergingContributor.$$$reportNull$$$0(0);
        }
        if ((parameters2 = context.getParameters()).getCompletionType() != CompletionType.SMART && parameters2.getCompletionType() != CompletionType.BASIC) {
            return null;
        }
        boolean needInsertBrace = false;
        boolean needInsertParenth = false;
        LookupElement[] items = context.getItems();
        if (items.length > 1) {
            String commonName = null;
            ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
            for (LookupElement item : items) {
                PsiElement o = item.getPsiElement();
                if (item.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) != null || !(o instanceof PsiMethod)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                PsiMethod method = (PsiMethod)o;
                String name = JavaMethodMergingContributor.joinLookupStrings((LookupElement)item);
                if (commonName != null && !commonName.equals(name)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                if (GrMethodMergingContributor.hasOnlyClosureParams(method)) {
                    needInsertBrace = true;
                } else {
                    needInsertParenth = true;
                }
                if (needInsertBrace && needInsertParenth) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                commonName = name;
                allMethods.add(method);
            }
            for (LookupElement item : items) {
                JavaCompletionUtil.putAllMethods((LookupElement)item, allMethods);
            }
            return AutoCompletionDecision.insertItem((LookupElement)JavaMethodMergingContributor.findBestOverload((LookupElement[])items));
        }
        return super.handleAutoCompletionPossibility(context);
    }

    private static boolean hasOnlyClosureParams(PsiMethod method) {
        PsiParameter[] params;
        for (PsiParameter param : params = method.getParameterList().getParameters()) {
            PsiType type2 = param.getType();
            if (TypesUtil.isClassType(type2, "groovy.lang.Closure")) continue;
            return false;
        }
        return params.length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/completion/GrMethodMergingContributor", "handleAutoCompletionPossibility"));
    }
}

