/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.completion.ClosureCompleter;
import org.jetbrains.plugins.groovy.lang.completion.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GdslClosureCompleter
extends ClosureCompleter {
    @Override
    protected List<ClosureParameterInfo> getParameterInfos(InsertionContext context, PsiMethod method, PsiSubstitutor substitutor2, PsiElement place) {
        ArrayList<ClosureDescriptor> descriptors = new ArrayList<ClosureDescriptor>();
        GrReferenceExpression ref2 = (GrReferenceExpression)place;
        PsiType qtype = PsiImplUtil.getQualifierType(ref2);
        if (qtype == null) {
            return null;
        }
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (qualifier != null) {
            PsiType type2 = qualifier.getType();
            if (!(type2 instanceof PsiClassType)) {
                return null;
            }
            GdslClosureCompleter.processExecutors((PsiClassType)qtype, ref2, descriptors);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            for (PsiElement parent2 = ref2.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                if (parent2 instanceof GrClosableBlock) {
                    GdslClosureCompleter.processExecutors(TypesUtil.createTypeByFQClassName("groovy.lang.Closure", ref2), ref2, descriptors);
                    continue;
                }
                if (!(parent2 instanceof GrTypeDefinition)) continue;
                GdslClosureCompleter.processExecutors(factory.createType((PsiClass)((GrTypeDefinition)parent2), PsiType.EMPTY_ARRAY), ref2, descriptors);
            }
        }
        for (ClosureDescriptor descriptor2 : descriptors) {
            if (!GdslClosureCompleter.isMethodApplicable(descriptor2, method, ref2)) continue;
            return ContainerUtil.map(descriptor2.getParameters(), d -> new ClosureParameterInfo(d.getName(), d.getType()));
        }
        return null;
    }

    private static void processExecutors(@NotNull PsiClassType qtype, @NotNull GrReferenceExpression ref2, @NotNull List<ClosureDescriptor> descriptors) {
        if (qtype == null) {
            GdslClosureCompleter.$$$reportNull$$$0(0);
        }
        if (ref2 == null) {
            GdslClosureCompleter.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            GdslClosureCompleter.$$$reportNull$$$0(2);
        }
        GroovyDslFileIndex.processExecutors(qtype, ref2, (PairProcessor<? super CustomMembersHolder, ? super GroovyClassDescriptor>)((PairProcessor)(holder, descriptor2) -> {
            holder.consumeClosureDescriptors((GroovyClassDescriptor)descriptor2, descriptors::add);
            return true;
        }));
    }

    private static boolean isMethodApplicable(@NotNull ClosureDescriptor descriptor2, @NotNull PsiMethod method, @NotNull GroovyPsiElement place) {
        PsiTypeParameterList typeParameterList;
        String name;
        if (descriptor2 == null) {
            GdslClosureCompleter.$$$reportNull$$$0(3);
        }
        if (method == null) {
            GdslClosureCompleter.$$$reportNull$$$0(4);
        }
        if (place == null) {
            GdslClosureCompleter.$$$reportNull$$$0(5);
        }
        if (!(name = descriptor2.getMethodName()).equals(method.getName())) {
            return false;
        }
        Object typeContext = descriptor2.getUsePlaceContextForTypes() ? place : ((typeParameterList = method.getTypeParameterList()) != null ? typeParameterList : method);
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        for (String type2 : descriptor2.getMethodParameterTypes()) {
            types.add(GdslClosureCompleter.convertToPsiType(type2, (PsiElement)typeContext));
        }
        boolean isConstructor = descriptor2.isMethodConstructor();
        MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])types.toArray(PsiType.createArray((int)types.size())), (PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)isConstructor);
        GrSignature closureSignature = GrClosureSignatureUtil.createSignature(signature);
        if (method instanceof ClsMethodImpl) {
            method = ((ClsMethodImpl)method).getSourceMirrorMethod();
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        PsiType[] typeArray = (PsiType[])ContainerUtil.map((Object[])parameters2, parameter -> parameter.getType(), (Object[])PsiType.createArray((int)parameters2.length));
        return GrClosureSignatureUtil.isSignatureApplicable(Collections.singletonList(closureSignature), typeArray, place);
    }

    private static PsiType convertToPsiType(@NlsSafe String type2, @NotNull PsiElement place) {
        if (place == null) {
            GdslClosureCompleter.$$$reportNull$$$0(6);
        }
        return JavaPsiFacade.getElementFactory((Project)place.getProject()).createTypeFromText(type2, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qtype";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GdslClosureCompleter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processExecutors";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodApplicable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToPsiType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

