/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroovyRefRenderer
extends NodeRendererImpl {
    private static final Key<NodeRenderer> GROOVY_REF_DELEGATE_RENDERER = new Key("GROOVY_REF_DELEGATE_RENDERER");

    public GroovyRefRenderer() {
        super("Groovy Reference", true);
        this.setIsApplicableChecker(type2 -> type2 instanceof ReferenceType ? DebuggerUtilsAsync.instanceOf((Type)type2, (String)"groovy.lang.Reference") : CompletableFuture.completedFuture(false));
    }

    public String getUniqueId() {
        return "GroovyRefRenderer";
    }

    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(value2, evaluationContext.getProject());
        GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor).thenAccept(renderer -> {
            builder.getParentDescriptor().putUserData(GROOVY_REF_DELEGATE_RENDERER, renderer);
            renderer.buildChildren(fieldDescriptor.getValue(), builder, evaluationContext);
        });
    }

    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        NodeRenderer renderer = (NodeRenderer)node.getParent().getDescriptor().getUserData(GROOVY_REF_DELEGATE_RENDERER);
        return renderer != null ? renderer.getChildValueExpression(node, context) : null;
    }

    public CompletableFuture<Boolean> isExpandableAsync(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(value2, evaluationContext.getProject());
        return GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor).thenCompose(renderer -> renderer.isExpandableAsync(fieldDescriptor.getValue(), evaluationContext, (NodeDescriptor)fieldDescriptor));
    }

    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(descriptor2.getValue(), evaluationContext.getProject(), descriptor2);
        CompletableFuture<NodeRenderer> renderer = GroovyRefRenderer.getDelegateRenderer(evaluationContext.getDebugProcess(), fieldDescriptor);
        return GroovyRefRenderer.calcLabel(renderer, (ValueDescriptor)fieldDescriptor, (EvaluationContext)evaluationContext, (DescriptorLabelListener)listener);
    }

    private static CompletableFuture<NodeRenderer> getDelegateRenderer(DebugProcess debugProcess, ValueDescriptor fieldDescriptor) {
        return ((DebugProcessImpl)debugProcess).getAutoRendererAsync(fieldDescriptor.getType());
    }

    private static ValueDescriptor getWrappedDescriptor(Value ref2, Project project) {
        return GroovyRefRenderer.getWrappedDescriptor(ref2, project, null);
    }

    private static ValueDescriptor getWrappedDescriptor(Value ref2, Project project, final @Nullable ValueDescriptor originalDescriptor) {
        final Field field2 = ((ObjectReference)ref2).referenceType().fieldByName("value");
        final Value wrapped = ((ObjectReference)ref2).getValue(field2);
        return new ValueDescriptorImpl(project, wrapped){

            public Value calcValue(EvaluationContextImpl evaluationContext) {
                return wrapped;
            }

            public void setValueLabel(@NotNull String label) {
                if (label == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (originalDescriptor != null) {
                    originalDescriptor.setValueLabel(label);
                }
            }

            public String calcValueName() {
                return field2.name();
            }

            public PsiExpression getDescriptorEvaluation(DebuggerContext context) {
                return JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText("this." + field2.name(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/plugins/groovy/debugger/GroovyRefRenderer$1", "setValueLabel"));
            }
        };
    }

    @Nullable
    public String calcIdLabel(ValueDescriptor descriptor2, DebugProcess process, DescriptorLabelListener labelListener) {
        ValueDescriptor fieldDescriptor = GroovyRefRenderer.getWrappedDescriptor(descriptor2.getValue(), process.getProject());
        return ((CompletableFuture)GroovyRefRenderer.getDelegateRenderer(process, fieldDescriptor).thenApply(renderer -> ((NodeRendererImpl)renderer).calcIdLabel(fieldDescriptor, process, labelListener))).getNow("");
    }
}

