/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/ParameterCastFix;", "Lcom/intellij/modcommand/ModCommandQuickFix;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "position", "", "myType", "Lcom/intellij/psi/PsiType;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;ILcom/intellij/psi/PsiType;)V", "myExpression", "Lcom/intellij/model/Pointer;", "myName", "", "getFamilyName", "getName", "perform", "Lcom/intellij/modcommand/ModCommand;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.groovy.psi"})
public final class ParameterCastFix
extends ModCommandQuickFix {
    @NotNull
    private final PsiType myType;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String myName;
    @NotNull
    private final Pointer<GrExpression> myExpression;

    public ParameterCastFix(@NotNull GrExpression expression, int position, @NotNull PsiType myType2) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)myType2, (String)"myType");
        this.myType = myType2;
        Object[] objectArray = new Object[]{position + 1, this.myType.getPresentableText()};
        String string = GroovyBundle.message("parameter.cast.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myName = string;
        this.myExpression = (Pointer)SmartPointersKt.createSmartPointer((PsiElement)expression);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("intention.family.name.add.parameter.cast", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        GrExpression grExpression = (GrExpression)this.myExpression.dereference();
        if (grExpression == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        GrExpression expression = grExpression;
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)expression, arg_0 -> ParameterCastFix.perform$lambda$0(project, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    private static final void perform$lambda$0(Project $project, ParameterCastFix this$0, GrExpression expr) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        GrCastFix.doSafeCast($project, this$0.myType, expr);
    }
}

