/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.prompt.BuiltInPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.RightPromptManager;
import org.jetbrains.plugins.terminal.block.prompt.ShellPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptStyle;
import org.jetbrains.plugins.terminal.block.prompt.TerminalSessionInfo;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorStateListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020\"H\u0002J\b\u0010.\u001a\u00020*H\u0016J\u0010\u0010/\u001a\u00020*2\u0006\u0010$\u001a\u00020#H\u0003J\b\u00100\u001a\u00020(H\u0002J\b\u00101\u001a\u00020*H\u0017J\u0012\u00102\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\u001dH\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020#@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "sessionInfo", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalSessionInfo;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalSessionInfo;)V", "commandStartOffset", "", "getCommandStartOffset", "()I", "value", "", "commandText", "getCommandText", "()Ljava/lang/String;", "setCommandText", "(Ljava/lang/String;)V", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "errorStateListeners", "", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorStateListener;", "<set-?>", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "promptState", "getPromptState", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "renderer", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderer;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "renderingInfo", "getRenderingInfo", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "rightPromptManager", "Lorg/jetbrains/plugins/terminal/block/prompt/RightPromptManager;", "addErrorStateListener", "", "listener", "parentDisposable", "createPromptRenderer", "dispose", "doUpdatePrompt", "getOrCreateRightPromptManager", "resetUndoRedoStack", "setErrorDescription", "errorDescription", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorDescription;", "updatePrompt", "state", "PreventMoveToPromptListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalPromptModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptModelImpl.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class TerminalPromptModelImpl
implements TerminalPromptModel,
Disposable {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final TerminalSessionInfo sessionInfo;
    @NotNull
    private TerminalPromptRenderer renderer;
    @Nullable
    private RightPromptManager rightPromptManager;
    @NotNull
    private TerminalPromptState promptState;
    @NotNull
    private TerminalPromptRenderingInfo renderingInfo;
    @NotNull
    private final List<TerminalPromptErrorStateListener> errorStateListeners;

    public TerminalPromptModelImpl(@NotNull EditorEx editor, @NotNull TerminalSessionInfo sessionInfo) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        this.editor = editor;
        this.sessionInfo = sessionInfo;
        this.renderer = this.createPromptRenderer();
        this.promptState = new TerminalPromptState("", null, null, null, null, null, null, null, null, 510, null);
        this.renderingInfo = new TerminalPromptRenderingInfo("", CollectionsKt.emptyList(), null, null, 12, null);
        this.errorStateListeners = new CopyOnWriteArrayList();
        this.getEditor().getCaretModel().addCaretListener((CaretListener)new PreventMoveToPromptListener(), (Disposable)this);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler((Document)this.getDocument(), TerminalPromptModelImpl::_init_$lambda$1);
        Project project = this.getEditor().getProject();
        Intrinsics.checkNotNull((Object)project);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> TerminalPromptModelImpl._init_$lambda$2(this, arg_0));
        BlockTerminalOptions.Companion.getInstance().addListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                renderer = this.createPromptRenderer();
                this.updatePrompt(this.getPromptState());
            }
        }));
    }

    @Override
    @NotNull
    public EditorEx getEditor() {
        return this.editor;
    }

    private final DocumentEx getDocument() {
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return documentEx;
    }

    @Override
    @NotNull
    public TerminalPromptState getPromptState() {
        return this.promptState;
    }

    @Override
    @NotNull
    public TerminalPromptRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    @Override
    public int getCommandStartOffset() {
        return this.getRenderingInfo().getText().length();
    }

    @Override
    @NotNull
    public String getCommandText() {
        String string = this.getDocument().getText(new TextRange(this.getCommandStartOffset(), this.getDocument().getTextLength()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    public void setCommandText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DocumentUtil.writeInRunUndoTransparentAction(() -> TerminalPromptModelImpl._set_commandText_$lambda$0(this, value));
    }

    @Override
    @RequiresEdt
    public void resetUndoRedoStack() {
        Project project = this.getEditor().getProject();
        Intrinsics.checkNotNull((Object)project);
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
        undoManager2.invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)this.getDocument()));
    }

    @Override
    public void updatePrompt(@NotNull TerminalPromptState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TerminalPromptRenderingInfo updatedInfo = this.renderer.calculateRenderingInfo(state);
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, updatedInfo, state){
            final /* synthetic */ TerminalPromptModelImpl this$0;
            final /* synthetic */ TerminalPromptRenderingInfo $updatedInfo;
            final /* synthetic */ TerminalPromptState $state;
            {
                this.this$0 = $receiver;
                this.$updatedInfo = $updatedInfo;
                this.$state = $state;
                super(0);
            }

            public final void invoke() {
                TerminalPromptModelImpl.access$doUpdatePrompt(this.this$0, this.$updatedInfo);
                TerminalPromptModelImpl.access$setPromptState$p(this.this$0, this.$state);
                TerminalPromptModelImpl.access$setRenderingInfo$p(this.this$0, this.$updatedInfo);
            }
        }), (int)1, null);
    }

    @RequiresEdt
    private final void doUpdatePrompt(TerminalPromptRenderingInfo renderingInfo) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> TerminalPromptModelImpl.doUpdatePrompt$lambda$3(this, renderingInfo));
        this.getEditor().getMarkupModel().removeAllHighlighters();
        for (HighlightingInfo highlighting : renderingInfo.getHighlightings()) {
            this.getEditor().getMarkupModel().addRangeHighlighter(highlighting.getStartOffset(), highlighting.getEndOffset(), 1000, highlighting.getTextAttributesProvider().getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
        String rightPrompt = renderingInfo.getRightText();
        if (((CharSequence)rightPrompt).length() > 0) {
            RightPromptManager manager = this.getOrCreateRightPromptManager();
            manager.update(renderingInfo.getText().length(), rightPrompt, renderingInfo.getRightHighlightings());
        } else {
            RightPromptManager rightPromptManager = this.rightPromptManager;
            if (rightPromptManager != null) {
                RightPromptManager it = rightPromptManager;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.rightPromptManager = null;
        }
    }

    private final RightPromptManager getOrCreateRightPromptManager() {
        RightPromptManager rightPromptManager = this.rightPromptManager;
        if (rightPromptManager != null) {
            RightPromptManager it = rightPromptManager;
            boolean bl = false;
            return it;
        }
        RightPromptManager manager = new RightPromptManager((Editor)this.getEditor(), this.sessionInfo.getSettings());
        Disposer.register((Disposable)this, (Disposable)manager);
        this.rightPromptManager = manager;
        return manager;
    }

    private final TerminalPromptRenderer createPromptRenderer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[BlockTerminalOptions.Companion.getInstance().getPromptStyle().ordinal()]) {
            case 1 -> new BuiltInPromptRenderer(this.sessionInfo, true);
            case 2 -> new BuiltInPromptRenderer(this.sessionInfo, false);
            case 3 -> new ShellPromptRenderer(this.sessionInfo);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void setErrorDescription(@Nullable TerminalPromptErrorDescription errorDescription) {
        for (TerminalPromptErrorStateListener listener : this.errorStateListeners) {
            listener.errorStateChanged(errorDescription);
        }
    }

    @Override
    public void addErrorStateListener(@NotNull TerminalPromptErrorStateListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.errorStateListeners, listener, parentDisposable);
    }

    public void dispose() {
    }

    private static final void _set_commandText_$lambda$0(TerminalPromptModelImpl this$0, String $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        this$0.getDocument().replaceString(this$0.getCommandStartOffset(), this$0.getDocument().getTextLength(), (CharSequence)$value);
    }

    private static final void _init_$lambda$1(ReadOnlyFragmentModificationException it) {
    }

    private static final void _init_$lambda$2(TerminalPromptModelImpl this$0, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.doUpdatePrompt(this$0.getRenderingInfo());
    }

    private static final void doUpdatePrompt$lambda$3(TerminalPromptModelImpl this$0, TerminalPromptRenderingInfo $renderingInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$renderingInfo, (String)"$renderingInfo");
        this$0.getDocument().getGuardedBlocks().clear();
        this$0.getDocument().replaceString(0, this$0.getCommandStartOffset(), (CharSequence)$renderingInfo.getText());
        this$0.getDocument().createGuardedBlock(0, $renderingInfo.getText().length());
    }

    public static final /* synthetic */ void access$doUpdatePrompt(TerminalPromptModelImpl $this, TerminalPromptRenderingInfo renderingInfo) {
        $this.doUpdatePrompt(renderingInfo);
    }

    public static final /* synthetic */ void access$setPromptState$p(TerminalPromptModelImpl $this, TerminalPromptState terminalPromptState) {
        $this.promptState = terminalPromptState;
    }

    public static final /* synthetic */ void access$setRenderingInfo$p(TerminalPromptModelImpl $this, TerminalPromptRenderingInfo terminalPromptRenderingInfo) {
        $this.renderingInfo = terminalPromptRenderingInfo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl$PreventMoveToPromptListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl;)V", "preventRecursion", "", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "intellij.terminal"})
    private final class PreventMoveToPromptListener
    implements CaretListener {
        private boolean preventRecursion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.preventRecursion) {
                return;
            }
            int newOffset = TerminalPromptModelImpl.this.getEditor().logicalPositionToOffset(event.getNewPosition());
            if (newOffset < TerminalPromptModelImpl.this.getCommandStartOffset()) {
                this.preventRecursion = true;
                try {
                    TerminalPromptModelImpl.this.getEditor().getCaretModel().moveToOffset(TerminalPromptModelImpl.this.getCommandStartOffset());
                }
                finally {
                    this.preventRecursion = false;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TerminalPromptStyle.values().length];
            try {
                nArray[TerminalPromptStyle.SINGLE_LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalPromptStyle.DOUBLE_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalPromptStyle.SHELL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

