/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "actionPerformedInTerminalToolWindow", "project", "Lcom/intellij/openapi/project/Project;", "terminalWidget", "Lcom/intellij/terminal/ui/TerminalWidget;", "findContextTerminal", "update", "updateInTerminalToolWindow", "intellij.terminal"})
public abstract class TerminalSessionContextMenuActionBase
extends ToolWindowContextMenuActionBase
implements ActionRemoteBehaviorSpecification.Frontend {
    public final void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project != null && TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && content != null) {
            TerminalWidget terminalWidget = this.findContextTerminal(e, content);
            if (terminalWidget != null) {
                this.updateInTerminalToolWindow(e, project, content, terminalWidget);
            } else {
                e.getPresentation().setEnabledAndVisible(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content, @NotNull TerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
    }

    public final void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        TerminalWidget terminalWidget;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project != null && TerminalToolWindowManager.isTerminalToolWindow(toolWindow) && content != null && (terminalWidget = this.findContextTerminal(e, content)) != null) {
            this.actionPerformedInTerminalToolWindow(e, project, content, terminalWidget);
        }
    }

    public abstract void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Content var3, @NotNull TerminalWidget var4);

    private final TerminalWidget findContextTerminal(AnActionEvent e, Content content) {
        JBTerminalWidget terminalWidget = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
        return terminalWidget != null && UIUtil.isAncestor((Component)content.getComponent(), (Component)((Component)terminalWidget)) ? terminalWidget.asNewWidget() : TerminalToolWindowManager.findWidgetByContent(content);
    }
}

