/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.google.common.collect.HashMultiset;
import com.intellij.diff.util.Side;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.PostCommitChangeConverter;
import com.intellij.openapi.vcs.ex.PartialCommitHelper;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.commit.LocalChangesCommitterKt;
import com.intellij.vcs.commit.ToggleAmendCommitOption;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.checkin.GitAmendCommitService;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCheckinExplicitMovementProvider;
import git4idea.checkin.GitCommitAndPushExecutorKt;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitCommitOptionsKt;
import git4idea.checkin.GitCommitOptionsUi;
import git4idea.checkin.GitPostCommitChangeConverter;
import git4idea.checkin.GitPushAfterCommitDialog;
import git4idea.checkin.GitRepositoryCommitter;
import git4idea.checkin.GitSkipHooksCommitHandlerFactoryKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitCommitTemplateTracker;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0004EFGHB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017H\u0002JA\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u000b\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001f0$H\u0016J\b\u0010%\u001a\u00020&H\u0002J\u0018\u0010%\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001fH\u0016J\u001d\u00100\u001a\u0004\u0018\u00010\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016\u00a2\u0006\u0002\u00104J\n\u00105\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u000bH\u0016J\b\u0010:\u001a\u00020\u000bH\u0016J\u001d\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020=2\u000b\u0010>\u001a\u00070\u001f\u00a2\u0006\u0002\b H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\f\u0010B\u001a\b\u0012\u0004\u0012\u0002030\u0014H\u0016J\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00142\f\u0010B\u001a\b\u0012\u0004\u0012\u00020.0\u0014H\u0016J\u0010\u0010D\u001a\u00020@2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lgit4idea/checkin/GitCheckinEnvironment;", "Lcom/intellij/openapi/vcs/checkin/CheckinEnvironment;", "Lcom/intellij/vcs/commit/AmendCommitAware;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "amendService", "Lgit4idea/checkin/GitAmendCommitService;", "getAmendService", "()Lgit4idea/checkin/GitAmendCommitService;", "myNextCleanupCommitMessage", "", "myNextCommitAmend", "myNextCommitAuthor", "Lcom/intellij/vcs/log/VcsUser;", "myNextCommitAuthorDate", "Ljava/util/Date;", "myNextCommitSignOff", "myNextCommitSkipHook", "collectRepositories", "", "Lgit4idea/repo/GitRepository;", "changesRepositories", "", "noChangesRoots", "Lcom/intellij/openapi/vcs/VcsRoot;", "commit", "Lcom/intellij/openapi/vcs/VcsException;", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "Lorg/jetbrains/annotations/NonNls;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "feedback", "", "createCommitOptions", "Lgit4idea/checkin/GitCommitOptions;", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "getAmendCommitDetails", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lcom/intellij/vcs/commit/EditedCommitDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCheckinOperationName", "getDefaultMessageFor", "filesToCheckin", "", "Lcom/intellij/openapi/vcs/FilePath;", "([Lcom/intellij/openapi/vcs/FilePath;)Ljava/lang/String;", "getHelpId", "getLastCommitMessage", "getPostCommitChangeConverter", "Lcom/intellij/openapi/vcs/checkin/PostCommitChangeConverter;", "isAmendCommitSupported", "isRefreshAfterCommitNeeded", "loadMessage", "messageFile", "Ljava/io/File;", "encoding", "markRootDirty", "", "scheduleMissingFileForDeletion", "files", "scheduleUnversionedFilesForAddition", "updateState", "ChangedPath", "CommitChange", "Companion", "GitCheckinOptions", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCheckinEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckinEnvironment.kt\ngit4idea/checkin/GitCheckinEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1103:1\n11391#2:1104\n13309#2:1105\n13310#2:1107\n11392#2:1108\n1#3:1106\n1#3:1119\n1603#4,9:1109\n1855#4:1118\n1856#4:1120\n1612#4:1121\n*S KotlinDebug\n*F\n+ 1 GitCheckinEnvironment.kt\ngit4idea/checkin/GitCheckinEnvironment\n*L\n94#1:1104\n94#1:1105\n94#1:1107\n94#1:1108\n94#1:1106\n201#1:1119\n201#1:1109,9\n201#1:1118\n201#1:1120\n201#1:1121\n*E\n"})
public final class GitCheckinEnvironment
implements CheckinEnvironment,
AmendCommitAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @Nullable
    private VcsUser myNextCommitAuthor;
    private boolean myNextCommitAmend;
    @Nullable
    private Date myNextCommitAuthorDate;
    private boolean myNextCommitSignOff;
    private boolean myNextCommitSkipHook;
    private boolean myNextCleanupCommitMessage;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String GIT_COMMIT_MSG_FILE_PREFIX;
    @NotNull
    private static final String GIT_COMMIT_MSG_FILE_EXT;
    @JvmField
    @NotNull
    public static final SimpleDateFormat COMMIT_DATE_FORMAT;

    public GitCheckinEnvironment(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        Intrinsics.checkNotNullParameter((Object)commitPanel, (String)"commitPanel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        return new GitCheckinOptions(commitPanel, commitContext, ToggleAmendCommitOption.Companion.isAmendCommitOptionSupported(commitPanel, (AmendCommitAware)this));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getDefaultMessageFor(@NotNull FilePath[] filesToCheckin) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)filesToCheckin, (String)"filesToCheckin");
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager manager2 = gitRepositoryManager;
        FilePath[] filePathArray = filesToCheckin;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            GitRepository it$iv;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            void file2 = element$iv;
            boolean bl2 = false;
            if ((GitRepository)manager2.getRepositoryForFileQuick((FilePath)file2) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet repositories2 = (HashSet)destination$iv;
        for (GitRepository repository : repositories2) {
            Intrinsics.checkNotNullExpressionValue((Object)repository.getRepositoryFiles().getMergeMessageFile(), (String)"getMergeMessageFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)repository.getRepositoryFiles().getSquashMessageFile(), (String)"getSquashMessageFile(...)");
            try {
                String encoding;
                File squashMsg;
                File mergeMsg;
                if (!mergeMsg.exists() && !squashMsg.exists()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)GitConfigUtil.getCommitEncoding(this.myProject, repository.getRoot()), (String)"getCommitEncoding(...)");
                if (mergeMsg.exists()) {
                    messages.add(this.loadMessage(mergeMsg, encoding));
                    continue;
                }
                messages.add(this.loadMessage(squashMsg, encoding));
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to load merge message", (Throwable)e);
            }
        }
        return DvcsUtil.joinMessagesOrNull((Collection)messages);
    }

    private final String loadMessage(File messageFile, String encoding) throws IOException {
        String string = FileUtil.loadFile((File)messageFile, (String)encoding);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
        return string;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    @NotNull
    public String getCheckinOperationName() {
        String string = GitBundle.message("commit.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAmendCommitSupported() {
        return this.getAmendService().isAmendCommitSupported();
    }

    @NotNull
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.getAmendService().getLastCommitMessage(root);
    }

    @NotNull
    public CancellablePromise<EditedCommitDetails> getAmendCommitDetails(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return this.getAmendService().getAmendCommitDetails(root);
    }

    private final GitAmendCommitService getAmendService() {
        Object object = this.myProject.getService(GitAmendCommitService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (GitAmendCommitService)((Object)object);
    }

    private final void updateState(CommitContext commitContext) {
        this.myNextCommitAmend = AbstractCommitWorkflowKt.isAmendCommitMode((CommitContext)commitContext);
        this.myNextCommitSkipHook = GitSkipHooksCommitHandlerFactoryKt.isSkipHooks(commitContext);
        this.myNextCommitAuthor = GitCommitOptionsKt.getCommitAuthor(commitContext);
        this.myNextCommitAuthorDate = GitCommitOptionsKt.getCommitAuthorDate(commitContext);
        this.myNextCommitSignOff = GitCommitOptionsKt.isSignOffCommit(commitContext);
        this.myNextCleanupCommitMessage = GitCommitTemplateTracker.exists$default(GitCommitTemplateTracker.Companion.getInstance(this.myProject), null, 1, null);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        Intrinsics.checkNotNullParameter(feedback, (String)"feedback");
        this.updateState(commitContext);
        List exceptions = new ArrayList();
        Map sortedChanges = GitCheckinEnvironment.Companion.sortChangesByGitRoot(this.myProject, changes, exceptions);
        Collection commitWithoutChangesRoots = LocalChangesCommitterKt.getCommitWithoutChangesRoots((CommitContext)commitContext);
        LOG.assertTrue(!sortedChanges.isEmpty() || !commitWithoutChangesRoots.isEmpty(), (Object)("Trying to commit an empty list of changes: " + changes));
        GitCommitOptions commitOptions = this.createCommitOptions();
        List<GitRepository> repositories2 = this.collectRepositories(sortedChanges.keySet(), commitWithoutChangesRoots);
        for (GitRepository repository : repositories2) {
            List list2 = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"emptyList(...)");
            Collection rootChanges = sortedChanges.getOrDefault(repository, list2);
            Collection toCommit = GitCheckinEnvironment.Companion.collectChangesToCommit(rootChanges);
            if (GitCommitOptionsKt.isCommitRenamesSeparately(commitContext)) {
                Pair pair = GitCheckinEnvironment.Companion.commitExplicitRenames(repository, toCommit, commitMessage, commitOptions);
                Collection explicitToCommit = (Collection)pair.component1();
                List moveExceptions = (List)pair.component2();
                toCommit = explicitToCommit;
                if (!moveExceptions.isEmpty()) {
                    exceptions.addAll(moveExceptions);
                    continue;
                }
            }
            exceptions.addAll(GitCheckinEnvironment.Companion.commitRepository(repository, toCommit, commitMessage, commitContext, commitOptions));
        }
        if (GitCommitAndPushExecutorKt.isPushAfterCommit(commitContext) && exceptions.isEmpty()) {
            GitPushAfterCommitDialog.showOrPush(this.myProject, (Collection<GitRepository>)repositories2);
        }
        return exceptions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GitRepository> collectRepositories(Collection<? extends GitRepository> changesRepositories, Collection<VcsRoot> noChangesRoots) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        GitVcs gitVcs = GitVcs.getInstance(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        GitVcs vcs = gitVcs;
        Iterable iterable = noChangesRoots;
        GitRepositoryManager gitRepositoryManager2 = repositoryManager;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VcsRoot it = (VcsRoot)element$iv$iv;
            boolean bl2 = false;
            if ((Intrinsics.areEqual((Object)it.getVcs(), (Object)((Object)vcs)) ? it.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection<GitRepository> collection = GitUtil.getRepositoriesFromRoots(gitRepositoryManager2, (List)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositoriesFromRoots(...)");
        Collection<GitRepository> noChangesRepositories = collection;
        List<GitRepository> list2 = repositoryManager.sortByDependency(ContainerUtil.union(changesRepositories, noChangesRepositories));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"sortByDependency(...)");
        return list2;
    }

    private final GitCommitOptions createCommitOptions() {
        return new GitCommitOptions(this.myNextCommitAmend, this.myNextCommitSignOff, this.myNextCommitSkipHook, this.myNextCommitAuthor, this.myNextCommitAuthorDate, this.myNextCleanupCommitMessage);
    }

    @NotNull
    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> files) {
        Map<VirtualFile, List<FilePath>> object3;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        List rc = new ArrayList();
        try {
            object3 = GitUtil.sortFilePathsByGitRoot(this.myProject, (Collection<? extends FilePath>)files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        Map<VirtualFile, List<FilePath>> map2 = object3;
        Intrinsics.checkNotNull(map2);
        Map<VirtualFile, List<FilePath>> sortedFiles = map2;
        for (Map.Entry entry : sortedFiles.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List value = (List)entry.getValue();
            try {
                GitFileUtils.deletePaths(this.myProject, root, value, new String[0]);
                Intrinsics.checkNotNull((Object)root);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    @NotNull
    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> object3;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        List rc = new ArrayList();
        try {
            object3 = GitUtil.sortFilesByGitRoot(this.myProject, (Collection<? extends VirtualFile>)files);
        }
        catch (VcsException e) {
            rc.add(e);
            return rc;
        }
        Map<VirtualFile, List<VirtualFile>> map2 = object3;
        Intrinsics.checkNotNull(map2);
        Map<VirtualFile, List<VirtualFile>> sortedFiles = map2;
        for (Map.Entry entry : sortedFiles.entrySet()) {
            VirtualFile root = (VirtualFile)entry.getKey();
            List value = (List)entry.getValue();
            try {
                GitFileUtils.addFiles(this.myProject, root, value);
                Intrinsics.checkNotNull((Object)root);
                this.markRootDirty(root);
            }
            catch (VcsException ex) {
                rc.add(ex);
            }
        }
        return rc;
    }

    private final void markRootDirty(VirtualFile root) {
        VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
    }

    @NotNull
    public PostCommitChangeConverter getPostCommitChangeConverter() {
        return new GitPostCommitChangeConverter(this.myProject);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsException> commitUsingIndex(@NotNull Project project, @NotNull GitRepository repository, @NotNull Collection<? extends ChangedPath> rootChanges, @NotNull Set<? extends ChangedPath> changedWithIndex, @NotNull File messageFile, @NotNull GitCommitOptions commitOptions) {
        return Companion.commitUsingIndex(project, repository, rootChanges, changedWithIndex, messageFile, commitOptions);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertDocumentContentToBytesWithBOM(@NotNull GitRepository repository, @NotNull String documentContent, @NotNull VirtualFile file2) {
        return Companion.convertDocumentContentToBytesWithBOM(repository, documentContent, file2);
    }

    @JvmStatic
    @NotNull
    public static final File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) throws IOException {
        return Companion.createCommitMessageFile(project, root, message);
    }

    @JvmStatic
    public static final void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message, @NotNull ThrowableConsumer<? super File, ? extends VcsException> task) throws VcsException {
        Companion.runWithMessageFile(project, root, message, task);
    }

    static {
        Logger logger = Logger.getInstance(GitCheckinEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        GIT_COMMIT_MSG_FILE_PREFIX = "git-commit-msg-";
        GIT_COMMIT_MSG_FILE_EXT = ".txt";
        COMMIT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lgit4idea/checkin/GitCheckinEnvironment$ChangedPath;", "", "beforePath", "Lcom/intellij/openapi/vcs/FilePath;", "afterPath", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/FilePath;)V", "getAfterPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getBeforePath", "isMove", "", "()Z", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    public static class ChangedPath {
        @Nullable
        private final FilePath beforePath;
        @Nullable
        private final FilePath afterPath;

        public ChangedPath(@Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            boolean bl;
            this.beforePath = beforePath;
            this.afterPath = afterPath;
            boolean bl2 = bl = this.beforePath != null || this.afterPath != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @Nullable
        public final FilePath getBeforePath() {
            return this.beforePath;
        }

        @Nullable
        public final FilePath getAfterPath() {
            return this.afterPath;
        }

        public final boolean isMove() {
            if (this.beforePath == null || this.afterPath == null) {
                return false;
            }
            return !ChangesUtil.equalsCaseSensitive((FilePath)this.beforePath, (FilePath)this.afterPath);
        }

        @NotNull
        public String toString() {
            String string = "%s -> %s";
            Object[] objectArray = new Object[]{this.beforePath, this.afterPath};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0015\u001a\u00070\n\u00a2\u0006\u0002\b\u0016H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitCheckinEnvironment$CommitChange;", "Lgit4idea/checkin/GitCheckinEnvironment$ChangedPath;", "beforePath", "Lcom/intellij/openapi/vcs/FilePath;", "afterPath", "beforeRevision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "afterRevision", "changelistIds", "", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getAfterRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "getBeforeRevision", "getChangelistIds", "()Ljava/util/List;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    private static final class CommitChange
    extends ChangedPath {
        @Nullable
        private final VcsRevisionNumber beforeRevision;
        @Nullable
        private final VcsRevisionNumber afterRevision;
        @Nullable
        private final List<String> changelistIds;
        @Nullable
        private final VirtualFile virtualFile;

        public CommitChange(@Nullable FilePath beforePath, @Nullable FilePath afterPath, @Nullable VcsRevisionNumber beforeRevision, @Nullable VcsRevisionNumber afterRevision, @Nullable List<String> changelistIds, @Nullable VirtualFile virtualFile) {
            super(beforePath, afterPath);
            this.beforeRevision = beforeRevision;
            this.afterRevision = afterRevision;
            this.changelistIds = changelistIds;
            this.virtualFile = virtualFile;
        }

        @Nullable
        public final VcsRevisionNumber getBeforeRevision() {
            return this.beforeRevision;
        }

        @Nullable
        public final VcsRevisionNumber getAfterRevision() {
            return this.afterRevision;
        }

        @Nullable
        public final List<String> getChangelistIds() {
            return this.changelistIds;
        }

        @Nullable
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + ", changelists: " + this.changelistIds;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u001f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0002JB\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0002JF\u0010 \u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001dH\u0002J6\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180!2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u0018H\u0002J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00182\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020,0\u001dH\u0002JK\u0010-\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00180!2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u000b\u0010.\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010/\u001a\u000200H\u0002JA\u00101\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u000b\u0010.\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u00102\u001a\u0002032\u0006\u0010/\u001a\u000200H\u0002JJ\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u00107\u001a\u0002082\u0006\u0010/\u001a\u000200H\u0007J+\u00109\u001a\u0004\u0018\u0001H:\"\u0004\b\u0000\u0010:2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<H\u0002\u00a2\u0006\u0002\u0010=J%\u0010>\u001a\u00020?2\u0006\u0010\u001a\u001a\u00020\u001b2\u000b\u0010@\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010A\u001a\u00020\u0011H\u0002J%\u0010B\u001a\u00020?2\u0006\u0010\u001a\u001a\u00020\u001b2\u000b\u0010@\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010A\u001a\u00020\u0011H\u0007J\u0010\u0010C\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020,H\u0002J%\u0010D\u001a\u0002082\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010.\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0007J*\u0010E\u001a\b\u0012\u0004\u0012\u00020#0\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002J\u0018\u0010F\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0006H\u0002J#\u0010G\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J\u001a\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0019H\u0002J\u0010\u0010L\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002Jn\u0010M\u001a\u00020'2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020N0\u001d2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020I0\u001f2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020I0\u001f2:\u0010Q\u001a6\u0012\u0015\u0012\u0013\u0018\u00010I\u00a2\u0006\f\bS\u0012\b\bT\u0012\u0004\b\b(U\u0012\u0015\u0012\u0013\u0018\u00010I\u00a2\u0006\f\bS\u0012\b\bT\u0012\u0004\b\b(V\u0012\u0004\u0012\u00020'0RH\u0002J&\u0010W\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0002J4\u0010X\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020I0\u001fH\u0002J=\u0010Z\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000b\u0010.\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0016\u0010[\u001a\u0012\u0012\u0006\b\u0000\u0012\u000208\u0012\u0006\b\u0001\u0012\u00020\u00160\\H\u0007J@\u0010]\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0_0^2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020,0\u00182\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0002JD\u0010`\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010O\u001a\b\u0012\u0004\u0012\u00020I0\u001d2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020I0\u001d2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lgit4idea/checkin/GitCheckinEnvironment$Companion;", "", "()V", "COMMIT_DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "GIT_COMMIT_MSG_FILE_EXT", "", "Lorg/jetbrains/annotations/NonNls;", "GIT_COMMIT_MSG_FILE_PREFIX", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addAsCaseOnlyRename", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "change", "Lgit4idea/checkin/GitCheckinEnvironment$ChangedPath;", "exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "addCaseOnlyRenamesToIndex", "", "Lgit4idea/checkin/GitCheckinEnvironment$CommitChange;", "repository", "Lgit4idea/repo/GitRepository;", "changes", "", "alreadyProcessed", "", "addExplicitMovementsToIndex", "Lkotlin/Pair;", "explicitMoves", "Lgit4idea/checkin/GitCheckinExplicitMovementProvider$Movement;", "addPartialChangesToIndex", "Lcom/intellij/openapi/vcs/ex/PartialCommitHelper;", "applyPartialChanges", "", "partialCommitHelpers", "collectActiveMovementProviders", "Lgit4idea/checkin/GitCheckinExplicitMovementProvider;", "collectChangesToCommit", "Lcom/intellij/openapi/vcs/changes/Change;", "commitExplicitRenames", "message", "commitOptions", "Lgit4idea/checkin/GitCommitOptions;", "commitRepository", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "commitUsingIndex", "rootChanges", "changedWithIndex", "messageFile", "Ljava/io/File;", "computeAfterLSTManagerUpdate", "T", "computation", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "convertDocumentContentToBytes", "", "documentContent", "file", "convertDocumentContentToBytesWithBOM", "createCommitChange", "createCommitMessageFile", "filterExcludedChanges", "getIssueLinks", "getLogString", "getPaths", "Lcom/intellij/openapi/vcs/FilePath;", "getStagedFile", "Lgit4idea/index/GitIndexUtil$StagedFile;", "isCaseOnlyRename", "processExcludedPaths", "Lgit4idea/changes/GitChangeUtils$GitDiffChange;", "added", "removed", "function", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "before", "after", "resetExcluded", "restoreExcluded", "unstagedDeletions", "runWithMessageFile", "task", "Lcom/intellij/util/ThrowableConsumer;", "sortChangesByGitRoot", "", "", "updateIndex", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitCheckinEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckinEnvironment.kt\ngit4idea/checkin/GitCheckinEnvironment$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1103:1\n1611#2:1104\n1855#2:1105\n1856#2:1107\n1612#2:1108\n1611#2:1109\n1855#2:1110\n1856#2:1112\n1612#2:1113\n2624#2,3:1114\n766#2:1117\n857#2,2:1118\n1549#2:1120\n1620#2,3:1121\n1549#2:1124\n1620#2,3:1125\n766#2:1128\n857#2,2:1129\n1603#2,9:1131\n1855#2:1140\n1856#2:1142\n1612#2:1143\n1603#2,9:1144\n1855#2:1153\n1856#2:1155\n1612#2:1156\n1549#2:1157\n1620#2,3:1158\n1549#2:1161\n1620#2,3:1162\n766#2:1169\n857#2,2:1170\n1747#2,3:1172\n1747#2,3:1175\n1747#2,3:1178\n1747#2,3:1181\n1549#2:1184\n1620#2,3:1185\n766#2:1188\n857#2,2:1189\n1603#2,9:1191\n1855#2:1200\n1856#2:1202\n1612#2:1203\n1603#2,9:1204\n1855#2:1213\n1856#2:1215\n1612#2:1216\n766#2:1217\n857#2,2:1218\n1#3:1106\n1#3:1111\n1#3:1141\n1#3:1154\n1#3:1201\n1#3:1214\n215#4,2:1165\n215#4,2:1167\n*S KotlinDebug\n*F\n+ 1 GitCheckinEnvironment.kt\ngit4idea/checkin/GitCheckinEnvironment$Companion\n*L\n323#1:1104\n323#1:1105\n323#1:1107\n323#1:1108\n324#1:1109\n324#1:1110\n324#1:1112\n324#1:1113\n396#1:1114,3\n539#1:1117\n539#1:1118,2\n545#1:1120\n545#1:1121,3\n546#1:1124\n546#1:1125,3\n600#1:1128\n600#1:1129,2\n606#1:1131,9\n606#1:1140\n606#1:1142\n606#1:1143\n607#1:1144,9\n607#1:1153\n607#1:1155\n607#1:1156\n631#1:1157\n631#1:1158,3\n686#1:1161\n686#1:1162,3\n756#1:1169\n756#1:1170,2\n783#1:1172,3\n789#1:1175,3\n790#1:1178,3\n791#1:1181,3\n794#1:1184\n794#1:1185,3\n1017#1:1188\n1017#1:1189,2\n1021#1:1191,9\n1021#1:1200\n1021#1:1202\n1021#1:1203\n1022#1:1204,9\n1022#1:1213\n1022#1:1215\n1022#1:1216\n1024#1:1217\n1024#1:1218,2\n323#1:1106\n324#1:1111\n606#1:1141\n607#1:1154\n1021#1:1201\n1022#1:1214\n727#1:1165,2\n732#1:1167,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<VcsException> commitRepository(GitRepository repository, Collection<CommitChange> changes, String message, CommitContext commitContext, GitCommitOptions commitOptions) {
            List exceptions = new ArrayList();
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            VirtualFile root = virtualFile;
            try {
                Pair<List<PartialCommitHelper>, List<CommitChange>> pair = this.addPartialChangesToIndex(repository, changes);
                List partialCommitHelpers = (List)pair.component1();
                List partialChanges = (List)pair.component2();
                HashSet<CommitChange> changedWithIndex = new HashSet<CommitChange>(partialChanges);
                List<CommitChange> caseOnlyRenameChanges = this.addCaseOnlyRenamesToIndex(repository, changes, (Set<CommitChange>)changedWithIndex, exceptions);
                if (!exceptions.isEmpty()) {
                    return exceptions;
                }
                changedWithIndex.addAll((Collection)caseOnlyRenameChanges);
                this.runWithMessageFile(project2, root, message, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)arg_0 -> Companion.commitRepository$lambda$0((Function1)new Function1<File, Unit>((List<VcsException>)exceptions, project2, repository, changes, changedWithIndex, commitOptions){
                    final /* synthetic */ List<VcsException> $exceptions;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GitRepository $repository;
                    final /* synthetic */ Collection<CommitChange> $changes;
                    final /* synthetic */ HashSet<CommitChange> $changedWithIndex;
                    final /* synthetic */ GitCommitOptions $commitOptions;
                    {
                        this.$exceptions = $exceptions;
                        this.$project = $project;
                        this.$repository = $repository;
                        this.$changes = $changes;
                        this.$changedWithIndex = $changedWithIndex;
                        this.$commitOptions = $commitOptions;
                        super(1);
                    }

                    public final void invoke(@NotNull File messageFile) {
                        Intrinsics.checkNotNullParameter((Object)messageFile, (String)"messageFile");
                        this.$exceptions.addAll((Collection<VcsException>)GitCheckinEnvironment.Companion.commitUsingIndex(this.$project, this.$repository, this.$changes, (Set<? extends ChangedPath>)this.$changedWithIndex, messageFile, this.$commitOptions));
                    }
                }, arg_0)));
                if (!exceptions.isEmpty()) {
                    return exceptions;
                }
                this.applyPartialChanges(partialCommitHelpers);
                repository.update();
                if (GitSubmoduleKt.isSubmodule(repository)) {
                    VcsDirtyScopeManager.getInstance((Project)project2).dirDirtyRecursively(repository.getRoot().getParent());
                }
                GitPostCommitChangeConverter.Companion.markRepositoryCommit(commitContext, repository);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            return exceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<VcsException> commitUsingIndex(@NotNull Project project, @NotNull GitRepository repository, @NotNull Collection<? extends ChangedPath> rootChanges, @NotNull Set<? extends ChangedPath> changedWithIndex, @NotNull File messageFile, @NotNull GitCommitOptions commitOptions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter(rootChanges, (String)"rootChanges");
            Intrinsics.checkNotNullParameter(changedWithIndex, (String)"changedWithIndex");
            Intrinsics.checkNotNullParameter((Object)messageFile, (String)"messageFile");
            Intrinsics.checkNotNullParameter((Object)commitOptions, (String)"commitOptions");
            List exceptions = new ArrayList();
            try {
                void $this$mapNotNullTo$iv;
                Object element$iv$iv2;
                void $this$mapNotNullTo$iv2;
                Iterable iterable = rootChanges;
                Iterable<FilePath> destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv2 : $this$forEach$iv$iv) {
                    FilePath it$iv;
                    Object element$iv = element$iv$iv2;
                    boolean bl = false;
                    ChangedPath it = (ChangedPath)element$iv;
                    boolean bl2 = false;
                    if (it.getAfterPath() == null) continue;
                    boolean bl3 = false;
                    destination$iv.add(it$iv);
                }
                Set added = (Set)destination$iv;
                destination$iv = rootChanges;
                Collection destination$iv2 = new HashSet();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                element$iv$iv2 = $this$forEach$iv$iv2.iterator();
                while (element$iv$iv2.hasNext()) {
                    FilePath it$iv;
                    Object element$iv$iv3;
                    Object element$iv = element$iv$iv3 = element$iv$iv2.next();
                    boolean bl = false;
                    ChangedPath it = (ChangedPath)element$iv;
                    boolean bl4 = false;
                    if (it.getBeforePath() == null) continue;
                    boolean bl5 = false;
                    destination$iv2.add(it$iv);
                }
                Set removed = (Set)destination$iv2;
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                VirtualFile root = virtualFile;
                String string = root.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String rootPath = string;
                List<FilePath> list2 = GitChangeUtils.getUnmergedFiles(repository);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getUnmergedFiles(...)");
                List<FilePath> unmergedFiles = list2;
                if (!unmergedFiles.isEmpty()) {
                    throw new VcsException(GitBundle.message("error.commit.cant.commit.with.unmerged.paths", new Object[0]));
                }
                Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(project, root);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
                Collection<GitChangeUtils.GitDiffChange> stagedChanges2 = collection;
                LOG.debug("Found staged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, stagedChanges2));
                List excludedStagedChanges = new ArrayList();
                List excludedStagedAdditions = new ArrayList();
                this.processExcludedPaths(stagedChanges2, added, removed, (Function2<? super FilePath, ? super FilePath, Unit>)((Function2)new Function2<FilePath, FilePath, Unit>((List<ChangedPath>)excludedStagedChanges, (List<FilePath>)excludedStagedAdditions){
                    final /* synthetic */ List<ChangedPath> $excludedStagedChanges;
                    final /* synthetic */ List<FilePath> $excludedStagedAdditions;
                    {
                        this.$excludedStagedChanges = $excludedStagedChanges;
                        this.$excludedStagedAdditions = $excludedStagedAdditions;
                        super(2);
                    }

                    public final void invoke(@Nullable FilePath before, @Nullable FilePath after) {
                        if (before != null || after != null) {
                            this.$excludedStagedChanges.add(new ChangedPath(before, after));
                        }
                        if (before == null && after != null) {
                            this.$excludedStagedAdditions.add(after);
                        }
                    }
                }));
                Collection<GitChangeUtils.GitDiffChange> collection2 = GitChangeUtils.getUnstagedChanges(project, root, excludedStagedAdditions, false);
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getUnstagedChanges(...)");
                Collection<GitChangeUtils.GitDiffChange> unstagedChanges = collection2;
                LOG.debug("Found unstaged changes: " + GitUtil.getLogStringGitDiffChanges(rootPath, unstagedChanges));
                HashSet<FilePath> excludedUnstagedDeletions = new HashSet<FilePath>();
                this.processExcludedPaths(unstagedChanges, added, removed, (Function2<? super FilePath, ? super FilePath, Unit>)((Function2)new Function2<FilePath, FilePath, Unit>(excludedUnstagedDeletions){
                    final /* synthetic */ HashSet<FilePath> $excludedUnstagedDeletions;
                    {
                        this.$excludedUnstagedDeletions = $excludedUnstagedDeletions;
                        super(2);
                    }

                    public final void invoke(@Nullable FilePath before, @Nullable FilePath after) {
                        if (before != null && after == null) {
                            this.$excludedUnstagedDeletions.add(before);
                        }
                    }
                }));
                if (!excludedStagedChanges.isEmpty()) {
                    LOG.info("Staged changes excluded for commit: " + this.getLogString(rootPath, excludedStagedChanges));
                    this.resetExcluded(project, root, excludedStagedChanges);
                }
                try {
                    List<FilePath> alreadyHandledPaths = this.getPaths((Collection<? extends ChangedPath>)changedWithIndex);
                    HashSet toAdd = new HashSet(added);
                    toAdd.removeAll((Collection)alreadyHandledPaths);
                    HashSet toRemove = new HashSet(removed);
                    toRemove.removeAll(toAdd);
                    toRemove.removeAll((Collection)alreadyHandledPaths);
                    Logger logger = LOG;
                    String string2 = "Updating index: added: %s, removed: %s";
                    Object[] objectArray = new Object[]{toAdd, toRemove};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    logger.debug(string3);
                    this.updateIndex(project, root, toAdd, toRemove, exceptions);
                    if (!exceptions.isEmpty()) {
                        List it$iv = exceptions;
                        return it$iv;
                    }
                    LOG.debug("Performing commit...");
                    GitRepositoryCommitter committer = new GitRepositoryCommitter(repository, commitOptions);
                    committer.commitStaged(messageFile);
                }
                finally {
                    if (!excludedStagedChanges.isEmpty()) {
                        this.restoreExcluded(project, root, excludedStagedChanges, (Set<? extends FilePath>)excludedUnstagedDeletions);
                    }
                }
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            return exceptions;
        }

        private final Pair<List<PartialCommitHelper>, List<CommitChange>> addPartialChangesToIndex(GitRepository repository, Collection<CommitChange> changes) throws VcsException {
            String[] it;
            boolean bl;
            Project project;
            block8: {
                Project project2 = repository.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                Iterable $this$none$iv = changes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (CommitChange)element$iv;
                        boolean bl2 = false;
                        if (!(it.getChangelistIds() != null)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return new Pair((Object)CollectionsKt.emptyList(), (Object)CollectionsKt.emptyList());
            }
            Pair pair = (Pair)this.computeAfterLSTManagerUpdate(project, () -> Companion.addPartialChangesToIndex$lambda$4(changes, project));
            if (pair == null) {
                throw new VcsException(GitBundle.message("error.commit.cant.collect.partial.changes", new Object[0]));
            }
            Pair pair2 = pair;
            List helpers = (List)pair2.component1();
            List partialChanges = (List)pair2.component2();
            List pathsToDelete = new ArrayList();
            for (CommitChange change : partialChanges) {
                if (!change.isMove()) continue;
                FilePath filePath = change.getBeforePath();
                Intrinsics.checkNotNull((Object)filePath);
                pathsToDelete.add(filePath);
            }
            Logger logger = LOG;
            String string = "Updating index for partial changes: removing: %s";
            Object[] objectArray = new Object[]{pathsToDelete};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            it = new String[]{"--ignore-unmatch"};
            GitFileUtils.deletePaths(project, repository.getRoot(), pathsToDelete, it);
            Logger logger2 = LOG;
            string = "Updating index for partial changes: changes: %s";
            objectArray = new Object[]{partialChanges};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            logger2.debug(string3);
            int n = partialChanges.size();
            for (int i = 0; i < n; ++i) {
                VirtualFile file2;
                FilePath path;
                CommitChange change = (CommitChange)partialChanges.get(i);
                Intrinsics.checkNotNull((Object)change.getAfterPath());
                PartialCommitHelper helper = (PartialCommitHelper)helpers.get(i);
                if (change.getVirtualFile() == null) {
                    Object[] objectArray2 = new Object[]{path.getPresentableUrl()};
                    throw new VcsException(DiffBundle.message((String)"cannot.find.file.error", (Object[])objectArray2));
                }
                GitIndexUtil.StagedFile stagedFile = this.getStagedFile(repository, change);
                boolean isExecutable = stagedFile != null && stagedFile.isExecutable();
                byte[] fileContent = this.convertDocumentContentToBytesWithBOM(repository, helper.getContent(), file2);
                GitIndexUtil.write(repository, path, fileContent, isExecutable);
            }
            return new Pair((Object)helpers, (Object)partialChanges);
        }

        private final void applyPartialChanges(List<? extends PartialCommitHelper> partialCommitHelpers) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.applyPartialChanges$lambda$5(partialCommitHelpers));
        }

        private final byte[] convertDocumentContentToBytes(GitRepository repository, String documentContent, VirtualFile file2) {
            String string;
            String string2 = FileDocumentManager.getInstance().getLineSeparator(file2, repository.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLineSeparator(...)");
            String lineSeparator = string2;
            if (Intrinsics.areEqual((Object)lineSeparator, (Object)"\n")) {
                string = documentContent;
            } else {
                String string3 = StringUtil.convertLineSeparators((String)documentContent, (String)lineSeparator);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            }
            String text2 = string;
            Object object = LoadTextUtil.charsetForWriting((Project)repository.getProject(), (VirtualFile)file2, (String)text2, (Charset)file2.getCharset()).second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            return (byte[])object;
        }

        @JvmStatic
        @NotNull
        public final byte[] convertDocumentContentToBytesWithBOM(@NotNull GitRepository repository, @NotNull String documentContent, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)documentContent, (String)"documentContent");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            byte[] fileContent = this.convertDocumentContentToBytes(repository, documentContent, file2);
            byte[] bom = file2.getBOM();
            if (bom != null && !ArrayUtil.startsWith((byte[])fileContent, (byte[])bom)) {
                byte[] byArray = ArrayUtil.mergeArrays((byte[])bom, (byte[])fileContent);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mergeArrays(...)");
                fileContent = byArray;
            }
            return fileContent;
        }

        private final GitIndexUtil.StagedFile getStagedFile(GitRepository repository, CommitChange change) throws VcsException {
            GitIndexUtil.StagedFile file2;
            GitIndexUtil.StagedFile file3;
            FilePath bPath = change.getBeforePath();
            if (bPath != null && (file3 = GitIndexUtil.listStaged(repository, bPath)) != null) {
                return file3;
            }
            FilePath aPath = change.getAfterPath();
            if (aPath != null && (file2 = GitIndexUtil.listStaged(repository, aPath)) != null) {
                return file2;
            }
            return null;
        }

        private final <T> T computeAfterLSTManagerUpdate(Project project, Computable<T> computation) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            CompletableFuture ref = new CompletableFuture();
            LineStatusTrackerManager.Companion.getInstance(project).invokeAfterUpdate(() -> Companion.computeAfterLSTManagerUpdate$lambda$6(ref, computation));
            try {
                return (T)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)ref);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn(e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<CommitChange> addCaseOnlyRenamesToIndex(GitRepository repository, Collection<CommitChange> changes, Set<CommitChange> alreadyProcessed, List<? super VcsException> exceptions) {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$filterTo$iv$iv;
            if (SystemInfo.isFileSystemCaseSensitive) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = changes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CommitChange change = (CommitChange)element$iv$iv;
                boolean bl = false;
                if (!(!alreadyProcessed.contains(change) && Companion.isCaseOnlyRename(change))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List caseOnlyRenames = (List)destination$iv$iv;
            if (caseOnlyRenames.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Logger logger = LOG;
            String string = repository.getRoot().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            logger.info("Committing case only rename: " + this.getLogString(string, caseOnlyRenames) + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
            Iterable $this$map$iv = caseOnlyRenames;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                CommitChange bl = (CommitChange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                FilePath filePath = it.getAfterPath();
                Intrinsics.checkNotNull((Object)filePath);
                collection.add(filePath);
            }
            List pathsToAdd = (List)destination$iv$iv2;
            Iterable $this$map$iv2 = caseOnlyRenames;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommitChange bl2 = (CommitChange)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                FilePath filePath = it.getBeforePath();
                Intrinsics.checkNotNull((Object)filePath);
                collection.add(filePath);
            }
            List pathsToDelete = (List)destination$iv$iv3;
            Logger logger2 = LOG;
            String string2 = "Updating index for case only changes: added: %s,\n removed: %s";
            Object[] objectArray = new Object[]{pathsToAdd, pathsToDelete};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            logger2.debug(string3);
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            this.updateIndex(project, virtualFile, pathsToAdd, pathsToDelete, exceptions);
            return caseOnlyRenames;
        }

        private final boolean isCaseOnlyRename(ChangedPath change) {
            if (SystemInfo.isFileSystemCaseSensitive) {
                return false;
            }
            if (!change.isMove()) {
                return false;
            }
            FilePath filePath = change.getAfterPath();
            Intrinsics.checkNotNull((Object)filePath);
            FilePath afterPath = filePath;
            FilePath filePath2 = change.getBeforePath();
            Intrinsics.checkNotNull((Object)filePath2);
            FilePath beforePath = filePath2;
            return GitUtil.isCaseOnlyChange(beforePath.getPath(), afterPath.getPath());
        }

        private final List<FilePath> getPaths(Collection<? extends ChangedPath> changes) {
            List files = new ArrayList();
            for (ChangedPath changedPath : changes) {
                if (ChangesUtil.equalsCaseSensitive((FilePath)changedPath.getBeforePath(), (FilePath)changedPath.getAfterPath())) {
                    UtilKt.addIfNotNull((List)files, (Object)changedPath.getBeforePath());
                    continue;
                }
                UtilKt.addIfNotNull((List)files, (Object)changedPath.getBeforePath());
                UtilKt.addIfNotNull((List)files, (Object)changedPath.getAfterPath());
            }
            return files;
        }

        private final void processExcludedPaths(Collection<? extends GitChangeUtils.GitDiffChange> changes, Set<? extends FilePath> added, Set<? extends FilePath> removed, Function2<? super FilePath, ? super FilePath, Unit> function) {
            for (GitChangeUtils.GitDiffChange gitDiffChange : changes) {
                FilePath before = gitDiffChange.getBeforePath();
                FilePath after = gitDiffChange.getAfterPath();
                if (CollectionsKt.contains((Iterable)removed, (Object)before)) {
                    before = null;
                }
                if (CollectionsKt.contains((Iterable)added, (Object)after)) {
                    after = null;
                }
                function.invoke((Object)before, (Object)after);
            }
        }

        private final String getLogString(String root, Collection<? extends ChangedPath> changes) {
            String string = GitUtil.getLogString(root, changes, arg_0 -> Companion.getLogString$lambda$10(getLogString.1.INSTANCE, arg_0), arg_0 -> Companion.getLogString$lambda$11(getLogString.2.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Collection<CommitChange>, List<VcsException>> commitExplicitRenames(GitRepository repository, Collection<CommitChange> changes, String message, GitCommitOptions commitOptions) {
            void $this$mapNotNullTo$iv$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv;
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile virtualFile = repository.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            VirtualFile root = virtualFile;
            Iterable $this$filter$iv = GitCheckinExplicitMovementProvider.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                GitCheckinExplicitMovementProvider it = (GitCheckinExplicitMovementProvider)element$iv$iv2;
                boolean bl = false;
                if (!it.isEnabled(project2)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List providers = (List)destination$iv$iv;
            List exceptions = new ArrayList();
            Object newMessage = message;
            String issueLinks = this.getIssueLinks(project2, (String)newMessage);
            Iterable $this$mapNotNull$iv = changes;
            boolean $i$f$mapNotNull = false;
            element$iv$iv2 = $this$mapNotNull$iv;
            Iterable<FilePath> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                FilePath it$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv2;
                boolean bl = false;
                CommitChange it = (CommitChange)element$iv$iv3;
                boolean bl2 = false;
                if (it.getBeforePath() == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List beforePaths = (List)destination$iv$iv2;
            Iterable $this$mapNotNull$iv2 = changes;
            boolean $i$f$mapNotNull22 = false;
            destination$iv$iv2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                FilePath it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv4 = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                CommitChange it = (CommitChange)element$iv$iv4;
                boolean bl4 = false;
                if (it.getAfterPath() == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List afterPaths = (List)destination$iv$iv3;
            HashSet<GitCheckinExplicitMovementProvider.Movement> movedPaths = new HashSet<GitCheckinExplicitMovementProvider.Movement>();
            for (GitCheckinExplicitMovementProvider provider : providers) {
                Collection<GitCheckinExplicitMovementProvider.Movement> providerMovements;
                Intrinsics.checkNotNullExpressionValue(provider.collectExplicitMovements(project2, beforePaths, afterPaths), (String)"collectExplicitMovements(...)");
                if (providerMovements.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)provider.getCommitMessage((String)newMessage), (String)"getCommitMessage(...)");
                movedPaths.addAll(providerMovements);
            }
            if (!StringsKt.isBlank((CharSequence)issueLinks)) {
                newMessage = (String)newMessage + "\n\n" + issueLinks;
            }
            try {
                void $this$mapTo$iv$iv;
                Pair<List<CommitChange>, List<CommitChange>> pair = this.addExplicitMovementsToIndex(repository, changes, (Collection<? extends GitCheckinExplicitMovementProvider.Movement>)movedPaths);
                if (pair == null) {
                    return new Pair(changes, (Object)exceptions);
                }
                Iterator $i$f$mapNotNull22 = pair;
                List movedChanges = (List)$i$f$mapNotNull22.component1();
                List newRootChanges = (List)$i$f$mapNotNull22.component2();
                this.runWithMessageFile(project2, root, (String)newMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)arg_0 -> Companion.commitExplicitRenames$lambda$15((Function1)new Function1<File, Unit>((List<VcsException>)exceptions, project2, repository, (List<CommitChange>)movedChanges, commitOptions){
                    final /* synthetic */ List<VcsException> $exceptions;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GitRepository $repository;
                    final /* synthetic */ List<CommitChange> $movedChanges;
                    final /* synthetic */ GitCommitOptions $commitOptions;
                    {
                        this.$exceptions = $exceptions;
                        this.$project = $project;
                        this.$repository = $repository;
                        this.$movedChanges = $movedChanges;
                        this.$commitOptions = $commitOptions;
                        super(1);
                    }

                    public final void invoke(File moveMessageFile) {
                        Collection collection = this.$movedChanges;
                        Set set = new HashSet<E>(this.$movedChanges);
                        Intrinsics.checkNotNull((Object)moveMessageFile);
                        this.$exceptions.addAll((Collection<VcsException>)GitCheckinEnvironment.Companion.commitUsingIndex(this.$project, this.$repository, collection, set, moveMessageFile, this.$commitOptions));
                    }
                }, arg_0)));
                Iterable $this$map$iv = movedChanges;
                boolean $i$f$map = false;
                element$iv$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CommitChange bl4 = (CommitChange)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl = false;
                    collection.add(Couple.of((Object)it.getBeforePath(), (Object)it.getAfterPath()));
                }
                List committedMovements = (List)destination$iv$iv4;
                for (GitCheckinExplicitMovementProvider provider : providers) {
                    provider.afterMovementsCommitted(project2, committedMovements);
                }
                return new Pair((Object)newRootChanges, (Object)exceptions);
            }
            catch (VcsException e) {
                exceptions.add(e);
                return new Pair(changes, (Object)exceptions);
            }
        }

        private final String getIssueLinks(Project project, String message) {
            List matches = IssueNavigationConfiguration.getInstance((Project)project).findIssueLinks((CharSequence)message);
            StringBuilder builder = new StringBuilder();
            for (IssueNavigationConfiguration.LinkMatch match2 : matches) {
                String issueId;
                Intrinsics.checkNotNullExpressionValue((Object)match2.getRange().substring(message), (String)"substring(...)");
                builder.append(issueId).append("\n");
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<List<CommitChange>, List<CommitChange>> addExplicitMovementsToIndex(GitRepository repository, Collection<CommitChange> changes, Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves) throws VcsException {
            Map.Entry element$iv;
            Object[] $this$mapTo$iv$iv;
            List<GitCheckinExplicitMovementProvider.Movement> explicitMoves2 = this.filterExcludedChanges(explicitMoves, changes);
            if (explicitMoves2.isEmpty()) {
                return null;
            }
            LOG.info("Committing explicit rename: " + explicitMoves2 + " in " + DvcsUtil.getShortRepositoryName((Repository)repository));
            HashMap movesMap = new HashMap();
            for (GitCheckinExplicitMovementProvider.Movement move : explicitMoves2) {
                Map map2 = movesMap;
                FilePath filePath = move.getBefore();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getBefore(...)");
                map2.put(filePath, move);
                map2 = movesMap;
                FilePath filePath2 = move.getAfter();
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getAfter(...)");
                map2.put(filePath2, move);
            }
            List nextCommitChanges = new ArrayList();
            List movedChanges = new ArrayList();
            HashMap affectedBeforePaths = new HashMap();
            HashMap affectedAfterPaths = new HashMap();
            for (CommitChange change2 : changes) {
                if (!((Map)movesMap).containsKey(change2.getBeforePath()) && !((Map)movesMap).containsKey(change2.getAfterPath())) {
                    nextCommitChanges.add(change2);
                    continue;
                }
                if (change2.getBeforePath() != null) {
                    ((Map)affectedBeforePaths).put(change2.getBeforePath(), change2);
                }
                if (change2.getAfterPath() == null) continue;
                ((Map)affectedAfterPaths).put(change2.getAfterPath(), change2);
            }
            Object $this$map$iv = (String[])explicitMoves2;
            boolean $i$f$map232 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void move;
                GitCheckinExplicitMovementProvider.Movement movement = (GitCheckinExplicitMovementProvider.Movement)t;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(move.getBefore());
            }
            List pathsToDelete = (List)destination$iv$iv;
            Logger logger = LOG;
            String $i$f$map232 = "Updating index for explicit movements: removing: %s";
            $this$mapTo$iv$iv = new Object[]{pathsToDelete};
            String string = String.format($i$f$map232, Arrays.copyOf($this$mapTo$iv$iv, $this$mapTo$iv$iv.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            logger.debug(string);
            $this$map$iv = new String[]{"--ignore-unmatch"};
            GitFileUtils.deletePaths(repository.getProject(), repository.getRoot(), pathsToDelete, (String[])$this$map$iv);
            for (GitCheckinExplicitMovementProvider.Movement move : explicitMoves2) {
                Hash hash;
                Object[] objectArray;
                FilePath afterFilePath;
                FilePath beforeFilePath;
                Intrinsics.checkNotNullExpressionValue((Object)move.getBefore(), (String)"getBefore(...)");
                Intrinsics.checkNotNullExpressionValue((Object)move.getAfter(), (String)"getAfter(...)");
                Object v = affectedBeforePaths.get(beforeFilePath);
                Intrinsics.checkNotNull(v);
                CommitChange bChange = (CommitChange)v;
                Object v2 = affectedAfterPaths.get(afterFilePath);
                Intrinsics.checkNotNull(v2);
                CommitChange aChange = (CommitChange)v2;
                VcsRevisionNumber vcsRevisionNumber = bChange.getBeforeRevision();
                if (vcsRevisionNumber == null) {
                    Logger logger2 = LOG;
                    String bl = "Unknown before revision: %s, %s";
                    Object[] objectArray2 = new Object[]{bChange, aChange};
                    String string2 = String.format(bl, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    logger2.warn(string2);
                    continue;
                }
                GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listTree(repository, beforeFilePath, vcsRevisionNumber);
                if (stagedFile == null) {
                    Logger logger3 = LOG;
                    String string3 = "Can't get revision for explicit move: %s -> %s";
                    objectArray = new Object[]{beforeFilePath, afterFilePath};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                    logger3.warn(string4);
                    continue;
                }
                Logger logger4 = LOG;
                String string5 = "Updating index for explicit movements: adding movement: %s -> %s";
                objectArray = new Object[]{beforeFilePath, afterFilePath};
                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                logger4.debug(string6);
                Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)stagedFile.getBlobHash()), (String)"build(...)");
                boolean isExecutable = stagedFile.isExecutable();
                GitIndexUtil.updateIndex(repository, afterFilePath, hash, isExecutable);
                nextCommitChanges.add(new CommitChange(afterFilePath, afterFilePath, null, null, aChange.getChangelistIds(), aChange.getVirtualFile()));
                movedChanges.add(new CommitChange(beforeFilePath, afterFilePath, null, null, null, null));
                affectedBeforePaths.remove(beforeFilePath);
                affectedAfterPaths.remove(afterFilePath);
            }
            Map $this$forEach$iv = affectedBeforePaths;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                CommitChange commitChange = (CommitChange)entry.getValue();
                nextCommitChanges.add(new CommitChange(commitChange.getBeforePath(), null, commitChange.getBeforeRevision(), null, commitChange.getChangelistIds(), commitChange.getVirtualFile()));
            }
            $this$forEach$iv = affectedAfterPaths;
            $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                CommitChange commitChange = (CommitChange)entry.getValue();
                nextCommitChanges.add(new CommitChange(null, commitChange.getAfterPath(), null, commitChange.getAfterRevision(), commitChange.getChangelistIds(), commitChange.getVirtualFile()));
            }
            if (movedChanges.isEmpty()) {
                return null;
            }
            return new Pair((Object)movedChanges, (Object)nextCommitChanges);
        }

        /*
         * WARNING - void declaration
         */
        private final List<GitCheckinExplicitMovementProvider.Movement> filterExcludedChanges(Collection<? extends GitCheckinExplicitMovementProvider.Movement> explicitMoves, Collection<CommitChange> changes) {
            void $this$filterTo$iv$iv;
            HashMultiset movedPathsMultiSet = HashMultiset.create();
            for (GitCheckinExplicitMovementProvider.Movement movement : explicitMoves) {
                movedPathsMultiSet.add((Object)movement.getBefore());
                movedPathsMultiSet.add((Object)movement.getAfter());
            }
            HashMultiset beforePathsMultiSet = HashMultiset.create();
            HashMultiset hashMultiset = HashMultiset.create();
            for (CommitChange change : changes) {
                ContainerUtil.addIfNotNull((Collection)((Collection)beforePathsMultiSet), (Object)change.getBeforePath());
                ContainerUtil.addIfNotNull((Collection)((Collection)hashMultiset), (Object)change.getAfterPath());
            }
            Iterable $this$filter$iv = explicitMoves;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitCheckinExplicitMovementProvider.Movement move = (GitCheckinExplicitMovementProvider.Movement)element$iv$iv;
                boolean bl = false;
                boolean bl2 = movedPathsMultiSet.count((Object)move.getBefore()) == 1 && movedPathsMultiSet.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getBefore()) == 1 && hashMultiset.count((Object)move.getAfter()) == 1 && beforePathsMultiSet.count((Object)move.getAfter()) == 0 && hashMultiset.count((Object)move.getBefore()) == 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<CommitChange> collectChangesToCommit(Collection<? extends Change> changes) {
            List result2 = new ArrayList();
            MultiMap map2 = new MultiMap();
            for (Change entry : changes) {
                CommitChange commitChange = this.createCommitChange(entry);
                if (commitChange.getVirtualFile() != null) {
                    map2.putValue((Object)commitChange.getVirtualFile(), (Object)commitChange);
                    continue;
                }
                result2.add(commitChange);
            }
            for (Map.Entry entry : map2.entrySet()) {
                FilePath afterPath;
                boolean hasAdditions;
                Iterable $this$any$iv;
                boolean hasDeletions;
                boolean hasNonChangelists;
                Collection fileCommitChanges;
                VirtualFile virtualFile;
                block25: {
                    boolean bl;
                    block24: {
                        boolean bl2;
                        block23: {
                            boolean hasSpecificChangelists;
                            block22: {
                                Intrinsics.checkNotNull((Object)entry);
                                virtualFile = (VirtualFile)entry.getKey();
                                fileCommitChanges = (Collection)entry.getValue();
                                if (fileCommitChanges.size() < 2) {
                                    Intrinsics.checkNotNull((Object)fileCommitChanges);
                                    result2.addAll(fileCommitChanges);
                                    continue;
                                }
                                Intrinsics.checkNotNull((Object)fileCommitChanges);
                                Iterable $this$any$iv2 = fileCommitChanges;
                                boolean $i$f$any = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    v0 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv2) {
                                        CommitChange change = (CommitChange)element$iv;
                                        boolean bl3 = false;
                                        if (!(change.getChangelistIds() != null)) continue;
                                        v0 = true;
                                        break block22;
                                    }
                                    v0 = hasSpecificChangelists = false;
                                }
                            }
                            if (!hasSpecificChangelists) {
                                result2.addAll(fileCommitChanges);
                                continue;
                            }
                            Iterable $this$any$iv3 = fileCommitChanges;
                            boolean $i$f$any = false;
                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                bl2 = false;
                            } else {
                                Object element$iv;
                                element$iv = $this$any$iv3.iterator();
                                while (element$iv.hasNext()) {
                                    Object element$iv2 = element$iv.next();
                                    CommitChange change = (CommitChange)element$iv2;
                                    boolean bl4 = false;
                                    if (!(change.getChangelistIds() == null)) continue;
                                    bl2 = true;
                                    break block23;
                                }
                                bl2 = false;
                            }
                        }
                        hasNonChangelists = bl2;
                        Iterable $this$any$iv4 = fileCommitChanges;
                        boolean $i$f$any = false;
                        if ($this$any$iv4 instanceof Collection && ((Collection)$this$any$iv4).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv4) {
                                CommitChange change = (CommitChange)element$iv;
                                boolean bl5 = false;
                                if (!(change.getAfterPath() == null)) continue;
                                bl = true;
                                break block24;
                            }
                            bl = false;
                        }
                    }
                    hasDeletions = bl;
                    $this$any$iv = fileCommitChanges;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CommitChange change = (CommitChange)element$iv;
                            boolean bl6 = false;
                            if (!(change.getBeforePath() == null)) continue;
                            v3 = true;
                            break block25;
                        }
                        v3 = hasAdditions = false;
                    }
                }
                if (hasNonChangelists || hasDeletions) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Logger logger = LOG;
                    String $i$f$any = "Ignoring changelists on commit of %s: %s";
                    Object[] element$iv = new Object[]{virtualFile, fileCommitChanges};
                    String string = String.format($i$f$any, Arrays.copyOf(element$iv, element$iv.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    logger.warn(string);
                    $this$any$iv = fileCommitChanges;
                    List list2 = result2;
                    boolean $i$f$map = false;
                    element$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void change;
                        CommitChange commitChange = (CommitChange)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new CommitChange(change.getBeforePath(), change.getAfterPath(), change.getBeforeRevision(), change.getAfterRevision(), null, change.getVirtualFile()));
                    }
                    list2.addAll((List)destination$iv$iv);
                    continue;
                }
                CommitChange firstChange = (CommitChange)CollectionsKt.first((Iterable)fileCommitChanges);
                FilePath beforePath = hasAdditions ? null : firstChange.getBeforePath();
                Intrinsics.checkNotNull((Object)firstChange.getAfterPath());
                VcsRevisionNumber beforeRevision = firstChange.getBeforeRevision();
                VcsRevisionNumber afterRevision = firstChange.getAfterRevision();
                HashSet combinedChangeListIds = new HashSet();
                boolean hasMismatch = false;
                for (CommitChange change : fileCommitChanges) {
                    List list3 = change.getChangelistIds();
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    combinedChangeListIds.addAll(list3);
                    if (Intrinsics.areEqual((Object)beforePath, (Object)change.getBeforePath()) && Intrinsics.areEqual((Object)afterPath, (Object)change.getAfterPath())) continue;
                    hasMismatch = true;
                }
                if (hasMismatch) {
                    Logger logger = LOG;
                    String string = "Change mismatch on commit of %s: %s";
                    Object[] objectArray = new Object[]{virtualFile, fileCommitChanges};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    logger.error(string2);
                }
                result2.add(new CommitChange(beforePath, afterPath, beforeRevision, afterRevision, new ArrayList(combinedChangeListIds), virtualFile));
            }
            return result2;
        }

        private final CommitChange createCommitChange(Change change) {
            FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            ContentRevision bRev = change.getBeforeRevision();
            ContentRevision aRev = change.getAfterRevision();
            ContentRevision contentRevision = bRev;
            VcsRevisionNumber beforeRevision = contentRevision != null ? contentRevision.getRevisionNumber() : null;
            ContentRevision contentRevision2 = aRev;
            VcsRevisionNumber afterRevision = contentRevision2 != null ? contentRevision2.getRevisionNumber() : null;
            List changelistIds = change instanceof ChangeListChange ? CollectionsKt.listOf((Object)((ChangeListChange)change).getChangeListId()) : null;
            VirtualFile virtualFile = aRev instanceof CurrentContentRevision ? ((CurrentContentRevision)aRev).getVirtualFile() : null;
            return new CommitChange(beforePath, afterPath, beforeRevision, afterRevision, changelistIds, virtualFile);
        }

        private final void resetExcluded(Project project, VirtualFile root, Collection<? extends ChangedPath> changes) throws VcsException {
            Set set = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCustomHashingStrategySet(...)");
            Set allPaths = set;
            for (ChangedPath changedPath : changes) {
                ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.getAfterPath());
                ContainerUtil.addIfNotNull((Collection)allPaths, (Object)changedPath.getBeforePath());
            }
            for (List list2 : VcsFileUtil.chunkPaths((VirtualFile)root, (Collection)allPaths)) {
                GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
                handler.endOptions();
                handler.addParameters(list2);
                Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            }
        }

        private final void restoreExcluded(Project project, VirtualFile root, Collection<? extends ChangedPath> changes, Set<? extends FilePath> unstagedDeletions) {
            List restoreExceptions = new ArrayList();
            HashSet toAdd = new HashSet();
            HashSet toRemove = new HashSet();
            for (ChangedPath changedPath : changes) {
                if (this.addAsCaseOnlyRename(project, root, changedPath, restoreExceptions)) continue;
                if (changedPath.getBeforePath() == null && CollectionsKt.contains((Iterable)unstagedDeletions, (Object)changedPath.getAfterPath())) {
                    LOG.info("Ignored added-deleted staged change in " + changedPath.getAfterPath());
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)toAdd, (Object)changedPath.getAfterPath());
                ContainerUtil.addIfNotNull((Collection)toRemove, (Object)changedPath.getBeforePath());
            }
            toRemove.removeAll(toAdd);
            Logger logger = LOG;
            String string = "Restoring staged changes after commit: added: %s, removed: %s";
            Object[] objectArray = new Object[]{toAdd, toRemove};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.debug(string2);
            this.updateIndex(project, root, toAdd, toRemove, restoreExceptions);
            for (VcsException vcsException : restoreExceptions) {
                LOG.warn((Throwable)vcsException);
            }
        }

        private final boolean addAsCaseOnlyRename(Project project, VirtualFile root, ChangedPath change, List<? super VcsException> exceptions) {
            try {
                if (!this.isCaseOnlyRename(change)) {
                    return false;
                }
                FilePath filePath = change.getBeforePath();
                Intrinsics.checkNotNull((Object)filePath);
                FilePath beforePath = filePath;
                FilePath filePath2 = change.getAfterPath();
                Intrinsics.checkNotNull((Object)filePath2);
                FilePath afterPath = filePath2;
                Logger logger = LOG;
                String[] stringArray = "Restoring staged case-only rename after commit: %s";
                Object[] objectArray = new Object[]{change};
                String string = String.format((String)stringArray, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                logger.debug(string);
                GitLineHandler h = new GitLineHandler(project, root, GitCommand.MV);
                stringArray = new String[]{"-f", beforePath.getPath(), afterPath.getPath()};
                h.addParameters(stringArray);
                Git.getInstance().runCommandWithoutCollectingOutput(h).throwOnError(new int[0]);
                return true;
            }
            catch (VcsException e) {
                exceptions.add(e);
                return false;
            }
        }

        private final void updateIndex(Project project, VirtualFile root, Collection<? extends FilePath> added, Collection<? extends FilePath> removed, List<? super VcsException> exceptions) {
            if (!removed.isEmpty()) {
                try {
                    String[] stringArray = new String[]{"--ignore-unmatch", "--cached", "-r"};
                    GitFileUtils.deletePaths(project, root, removed, stringArray);
                }
                catch (VcsException ex) {
                    exceptions.add(ex);
                }
            }
            if (!added.isEmpty()) {
                try {
                    GitFileUtils.addPathsForce(project, root, added);
                }
                catch (VcsException ex) {
                    exceptions.add(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final File createCommitMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message) throws IOException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            File file2 = FileUtil.createTempFile((String)GIT_COMMIT_MSG_FILE_PREFIX, (String)GIT_COMMIT_MSG_FILE_EXT);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
            File file3 = file2;
            file3.deleteOnExit();
            String string = GitConfigUtil.getCommitEncoding(project, root);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommitEncoding(...)");
            String encoding = string;
            Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(file3), encoding);
            Throwable throwable = null;
            try {
                OutputStreamWriter out = (OutputStreamWriter)closeable;
                boolean bl = false;
                out.write(message);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return file3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void runWithMessageFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull String message, @NotNull ThrowableConsumer<? super File, ? extends VcsException> task) throws VcsException {
            File file2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            try {
                file2 = this.createCommitMessageFile(project, root, message);
            }
            catch (IOException ex) {
                throw new VcsException(GitBundle.message("error.commit.cant.create.message.file", new Object[0]), (Throwable)ex);
            }
            File messageFile = file2;
            try {
                task.consume((Object)messageFile);
            }
            finally {
                if (!messageFile.delete()) {
                    LOG.warn("Failed to remove temporary file: " + messageFile);
                }
            }
        }

        private final Map<GitRepository, Collection<Change>> sortChangesByGitRoot(Project project, List<? extends Change> changes, List<? super VcsException> exceptions) {
            HashMap<Object, Collection> result2 = new HashMap<Object, Collection>();
            for (Change change : changes) {
                try {
                    Collection changeList2;
                    GitRepository repository;
                    FilePath filePath;
                    Intrinsics.checkNotNullExpressionValue((Object)ChangesUtil.getFilePath((Change)change), (String)"getFilePath(...)");
                    FilePath filePath2 = filePath.getParentPath();
                    Intrinsics.checkNotNull((Object)filePath2);
                    Intrinsics.checkNotNullExpressionValue((Object)GitUtil.getRepositoryForFile(project, filePath2), (String)"getRepositoryForFile(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)result2.computeIfAbsent(repository, arg_0 -> Companion.sortChangesByGitRoot$lambda$27(sortChangesByGitRoot.changeList.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                    changeList2.add(change);
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<GitCheckinExplicitMovementProvider> collectActiveMovementProviders(@NotNull Project project) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object element$iv$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List allProviders = GitCheckinExplicitMovementProvider.EP_NAME.getExtensionList();
            Iterable $this$filter$iv = allProviders;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                GitCheckinExplicitMovementProvider it = (GitCheckinExplicitMovementProvider)element$iv$iv;
                boolean bl = false;
                if (!it.isEnabled(project)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List enabledProviders = (List)destination$iv$iv;
            if (enabledProviders.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Collection collection = ChangeListManager.getInstance((Project)project).getAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
            List<CommitChange> changes = this.collectChangesToCommit(collection);
            Iterable $this$mapNotNull$iv = changes;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$filterTo22 = $this$mapNotNull$iv;
            Iterable<FilePath> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                FilePath it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv2;
                boolean bl = false;
                CommitChange it = (CommitChange)element$iv$iv;
                boolean bl2 = false;
                if (it.getBeforePath() == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List beforePaths = (List)destination$iv$iv2;
            Iterable $this$mapNotNull$iv2 = changes;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                FilePath it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                CommitChange it = (CommitChange)element$iv$iv;
                boolean bl4 = false;
                if (it.getAfterPath() == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List afterPaths = (List)destination$iv$iv3;
            Iterable $this$filter$iv2 = enabledProviders;
            boolean $i$f$filter2 = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv2;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Collection<GitCheckinExplicitMovementProvider.Movement> movements;
                GitCheckinExplicitMovementProvider provider = (GitCheckinExplicitMovementProvider)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(provider.collectExplicitMovements(project, beforePaths, afterPaths), (String)"collectExplicitMovements(...)");
                boolean bl6 = !((Collection)Companion.filterExcludedChanges(movements, (Collection<CommitChange>)changes)).isEmpty();
                if (!bl6) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            return (List)destination$iv$iv3;
        }

        private static final void commitRepository$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final Pair addPartialChangesToIndex$lambda$4(Collection $changes, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$changes, (String)"$changes");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            List helpers = new ArrayList();
            List partialChanges = new ArrayList();
            for (CommitChange change : $changes) {
                PartialLocalLineStatusTracker tracker;
                if (change.getChangelistIds() == null || change.getVirtualFile() == null || change.getBeforePath() == null || change.getAfterPath() == null || (tracker = PartialChangesUtil.getPartialTracker((Project)$project, (VirtualFile)change.getVirtualFile())) == null || !tracker.hasPartialChangesToCommit()) continue;
                if (!tracker.isOperational()) {
                    LOG.warn("Tracker is not operational for " + tracker.getVirtualFile().getPresentableUrl());
                    return null;
                }
                helpers.add(tracker.handlePartialCommit(Side.LEFT, change.getChangelistIds(), true));
                partialChanges.add(change);
            }
            return new Pair((Object)helpers, (Object)partialChanges);
        }

        private static final void applyPartialChanges$lambda$5(List $partialCommitHelpers) {
            Intrinsics.checkNotNullParameter((Object)$partialCommitHelpers, (String)"$partialCommitHelpers");
            for (PartialCommitHelper helper : $partialCommitHelpers) {
                try {
                    helper.applyChanges();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static final void computeAfterLSTManagerUpdate$lambda$6(CompletableFuture $ref, Computable $computation) {
            Intrinsics.checkNotNullParameter((Object)$ref, (String)"$ref");
            Intrinsics.checkNotNullParameter((Object)$computation, (String)"$computation");
            try {
                $ref.complete($computation.compute());
            }
            catch (Throwable e) {
                $ref.completeExceptionally(e);
            }
        }

        private static final FilePath getLogString$lambda$10(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (FilePath)$tmp0.invoke(p0);
        }

        private static final FilePath getLogString$lambda$11(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (FilePath)$tmp0.invoke(p0);
        }

        private static final void commitExplicitRenames$lambda$15(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final Collection sortChangesByGitRoot$lambda$27(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Collection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/checkin/GitCheckinEnvironment$GitCheckinOptions;", "Lcom/intellij/openapi/vcs/checkin/CheckinChangeListSpecificComponent;", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "Lcom/intellij/openapi/Disposable;", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "showAmendOption", "", "(Lgit4idea/checkin/GitCheckinEnvironment;Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/vcs/changes/CommitContext;Z)V", "myOptionsUi", "Lgit4idea/checkin/GitCommitOptionsUi;", "dispose", "", "getAuthor", "", "getComponent", "Ljavax/swing/JComponent;", "isAmend", "onChangeListSelected", "list", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "restoreState", "saveState", "intellij.vcs.git"})
    public final class GitCheckinOptions
    implements CheckinChangeListSpecificComponent,
    RefreshableOnComponent,
    Disposable {
        @NotNull
        private final GitCommitOptionsUi myOptionsUi;

        public GitCheckinOptions(@NotNull CheckinProjectPanel commitPanel, CommitContext commitContext, boolean showAmendOption) {
            Intrinsics.checkNotNullParameter((Object)commitPanel, (String)"commitPanel");
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            this.myOptionsUi = new GitCommitOptionsUi(commitPanel, commitContext, showAmendOption);
            Disposer.register((Disposable)this, (Disposable)this.myOptionsUi);
        }

        @Nullable
        public final String getAuthor() {
            VcsUser author;
            VcsUser vcsUser = author = this.myOptionsUi.getAuthor();
            return vcsUser != null ? vcsUser.toString() : null;
        }

        public final boolean isAmend() {
            return this.myOptionsUi.getAmendHandler().isAmendCommitMode();
        }

        @NotNull
        public JComponent getComponent() {
            return this.myOptionsUi.getComponent();
        }

        public void restoreState() {
            this.myOptionsUi.restoreState();
        }

        public void saveState() {
            this.myOptionsUi.saveState();
        }

        public void onChangeListSelected(@NotNull LocalChangeList list2) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            this.myOptionsUi.onChangeListSelected(list2);
        }

        public void dispose() {
        }
    }
}

