/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithAction;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCompareWithTagAction
extends DvcsCompareWithAction<GitRepository> {
    protected boolean nothingToCompare(@NotNull GitRepository repository) {
        if (repository == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(1);
        }
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        if (gitRepositoryManager == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(2);
        }
        return gitRepositoryManager;
    }

    @Nullable
    protected JBPopup createPopup(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2) {
        List tags2;
        if (project == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(5);
        }
        try {
            tags2 = (List)VcsUtil.computeWithModalProgress((Project)project, (String)GitBundle.message("git.compare.with.tag.modal.progress.loading.tags", new Object[0]), (boolean)true, indicator -> GitBranchUtil.getAllTags(project, repository.getRoot()));
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)project).notifyError("git.tags.loading.failed", GitBundle.message("git.compare.with.tag.loading.error.title", new Object[0]), e.getMessage());
            return null;
        }
        return GitCompareWithTagAction.createPopup((String)GitBundle.message("git.compare.with.tag.popup.title", new Object[0]), (List)tags2, selected -> GitCompareWithTagAction.showDiffWithTag(project, repository, file2, selected));
    }

    private static void showDiffWithTag(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2, @NotNull @NlsSafe String tagName) {
        if (project == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(6);
        }
        if (repository == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(8);
        }
        if (tagName == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(9);
        }
        String presentableRevisionName = GitCompareWithTagAction.getPresentableCurrentBranchName((Repository)repository);
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle((String)tagName, (boolean)false);
        String revNumTitle2 = VcsDiffUtil.getRevisionTitle((String)presentableRevisionName, (boolean)true);
        GitCompareWithTagAction.showDiffBetweenRevision((Project)project, (VirtualFile)file2, (String)revNumTitle1, (String)revNumTitle2, () -> GitCompareWithTagAction.getDiffChanges(project, repository, file2, tagName));
    }

    @NotNull
    private static Collection<Change> getDiffChanges(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile file2, @NotNull String tagName) throws VcsException {
        if (project == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(10);
        }
        if (repository == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(12);
        }
        if (tagName == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(13);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        String refToCompare = "refs/tags/" + tagName;
        GitRevisionNumber revisionNumber = new GitRevisionNumber(refToCompare);
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, repository.getRoot(), refToCompare, Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, refToCompare) == null) {
            throw new VcsException(GitBundle.message("git.compare.with.tag.file.not.found.in.tag", file2.isDirectory() ? 2 : 1, file2.getPresentableUrl(), tagName));
        }
        ContentRevision revision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, project);
        List list2 = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)revision) : changes;
        if (list2 == null) {
            GitCompareWithTagAction.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitCompareWithTagAction";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitCompareWithTagAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nothingToCompare";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithTag";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDiffChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 14 -> new IllegalStateException(string);
        };
    }
}

