/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspacePersistedSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;

@State(name="MavenImportPreferences", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class MavenWorkspaceSettingsComponent
implements PersistentStateComponent<MavenWorkspacePersistedSettings> {
    private MavenWorkspacePersistedSettings mySettings;
    private final Project myProject;

    public MavenWorkspaceSettingsComponent(@NotNull Project project2) {
        if (project2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.mySettings = new MavenWorkspacePersistedSettings(new MavenWorkspaceSettings());
        this.mySettings.getGeneralSettings().setProject(project2);
        this.applyDefaults(this.mySettings.getRealSettings());
    }

    public static MavenWorkspaceSettingsComponent getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(1);
        }
        return (MavenWorkspaceSettingsComponent)project2.getService(MavenWorkspaceSettingsComponent.class);
    }

    @NotNull
    public MavenWorkspacePersistedSettings getState() {
        MavenExplicitProfiles profiles2 = MavenProjectsManager.getInstance(this.myProject).getExplicitProfiles();
        this.mySettings.setEnabledProfiles(profiles2.getEnabledProfiles());
        this.mySettings.setDisabledProfiles(profiles2.getDisabledProfiles());
        MavenWorkspacePersistedSettings mavenWorkspacePersistedSettings = this.mySettings;
        if (mavenWorkspacePersistedSettings == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(2);
        }
        return mavenWorkspacePersistedSettings;
    }

    public void loadState(@NotNull MavenWorkspacePersistedSettings state2) {
        if (state2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(3);
        }
        this.mySettings = state2;
        this.applyDefaults(this.mySettings.getRealSettings());
        this.migrateSettings(this.mySettings.getRealSettings());
    }

    public MavenWorkspaceSettings getSettings() {
        return this.mySettings.getRealSettings();
    }

    private void applyDefaults(MavenWorkspaceSettings settings) {
        settings.getGeneralSettings().setProject(this.myProject);
    }

    private void migrateSettings(MavenWorkspaceSettings settings) {
        MavenImportingSettings importingSettings = settings.getImportingSettings();
        if (importingSettings.isImportAutomatically()) {
            importingSettings.setImportAutomatically(false);
            ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)this.myProject);
            projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.ALL);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

