/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.MavenSyncSpec;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.CacheForCompilerErrorMessages;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceProjectImporterKt;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenAsyncProjectsManager;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenModificationTracker;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerUtilKt;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.MavenWrapper;
import org.jetbrains.idea.maven.project.auto.reload.MavenProjectManagerWatcher;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

@State(name="MavenProjectsManager")
public abstract class MavenProjectsManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponentJavaAdapter,
Disposable,
MavenAsyncProjectsManager {
    private final ReentrantLock initLock;
    private final AtomicBoolean projectsTreeInitialized;
    private final AtomicBoolean isInitialized;
    private final AtomicBoolean isActivated;
    @NotNull
    private MavenProjectsManagerState myState;
    private final MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectManagerWatcher myWatcher;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher;
    private final List<Listener> myManagerListeners;
    private final ModificationTracker myModificationTracker;
    private final AtomicReference<MavenSyncConsole> mySyncConsole;
    private final MavenMergingUpdateQueue mySaveQueue;
    private static final int SAVE_DELAY = 1000;
    protected Module myPreviewModule;
    private transient boolean forceUpdateSnapshots;

    public static MavenProjectsManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(0);
        }
        return (MavenProjectsManager)project2.getService(MavenProjectsManager.class);
    }

    @Nullable
    public static MavenProjectsManager getInstanceIfCreated(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(1);
        }
        return (MavenProjectsManager)project2.getServiceIfCreated(MavenProjectsManager.class);
    }

    public MavenProjectsManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(2);
        }
        super(project2);
        this.initLock = new ReentrantLock();
        this.projectsTreeInitialized = new AtomicBoolean();
        this.isInitialized = new AtomicBoolean();
        this.isActivated = new AtomicBoolean();
        this.myState = new MavenProjectsManagerState();
        this.myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
        this.myManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mySyncConsole = new AtomicReference();
        this.forceUpdateSnapshots = false;
        this.myEmbeddersManager = new MavenEmbeddersManager(project2);
        this.myModificationTracker = new MavenModificationTracker(this);
        this.mySaveQueue = new MavenMergingUpdateQueue("Maven save queue", 1000, !MavenUtil.isMavenUnitTestModeEnabled(), this);
        MavenRehighlighter.install(project2, this);
        Disposer.register((Disposable)this, this::projectClosed);
        CacheForCompilerErrorMessages.connectToJdkListener(project2, this);
    }

    @NotNull
    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        MavenProjectsManagerState mavenProjectsManagerState = this.myState;
        if (mavenProjectsManagerState == null) {
            MavenProjectsManager.$$$reportNull$$$0(3);
        }
        return mavenProjectsManagerState;
    }

    public void loadState(@NotNull MavenProjectsManagerState state2) {
        if (state2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(4);
        }
        this.myState = state2;
        if (this.isInitialized()) {
            MavenProjectsManager.applyStateToTree(this.getProjectsTree(), this);
            this.scheduleUpdateAllMavenProjects(MavenSyncSpec.incremental("MavenProjectsManager.loadState"));
        }
    }

    public void dispose() {
        this.mySyncConsole.set(null);
        this.myManagerListeners.clear();
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public MavenGeneralSettings getGeneralSettings() {
        MavenGeneralSettings generalSettings = this.getWorkspaceSettings().getGeneralSettings();
        generalSettings.setProject(this.myProject);
        return generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().getImportingSettings();
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        return MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    @ApiStatus.Internal
    public int getFilterConfigCrc(@NotNull ProjectFileIndex projectFileIndex) {
        if (projectFileIndex == null) {
            MavenProjectsManager.$$$reportNull$$$0(5);
        }
        return this.getProjectsTree().getFilterConfigCrc(projectFileIndex);
    }

    @TestOnly
    public void initForTests() {
        this.initProjectsTree();
        this.doInit();
    }

    private void doInit() {
        this.initLock.lock();
        try {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initPreloadMavenServices();
            this.initWorkers();
            this.updateTabTitles();
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void doActivate() {
        if (this.isActivated.getAndSet(true)) {
            return;
        }
        this.fireActivated();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.listenForExternalChanges();
            MavenIndicesManager.getInstance(this.myProject).scheduleUpdateIndicesList();
        }
    }

    protected void onProjectStartup() {
        boolean wasMavenized;
        if (!this.isNormalProject()) {
            return;
        }
        boolean bl = wasMavenized = !this.myState.originalFiles.isEmpty();
        if (!wasMavenized) {
            return;
        }
        this.initProjectsTree();
        this.doInit();
        this.doActivate();
        boolean forceImport = Boolean.TRUE.equals(this.myProject.getUserData(WorkspaceProjectImporterKt.getNOTIFY_USER_ABOUT_WORKSPACE_IMPORT_KEY()));
        if (forceImport) {
            this.scheduleUpdateAllMavenProjects(MavenSyncSpec.full("MavenProjectsManager.onProjectStartup"));
        }
    }

    private void initPreloadMavenServices() {
        MavenProjectsNavigator.getInstance(this.myProject);
        MavenTasksManager.getInstance(this.myProject);
        MavenShortcutsManager.getInstance(this.myProject);
    }

    private void updateTabTitles() {
        Application app = ApplicationManager.getApplication();
        if (MavenUtil.isMavenUnitTestModeEnabled() || app.isHeadlessEnvironment()) {
            return;
        }
        this.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(List<? extends Pair<MavenProject, MavenProjectChanges>> updated, List<? extends MavenProject> deleted) {
                MavenProjectsManager.updateTabName(MavenUtil.collectFirsts(updated), MavenProjectsManager.this.myProject);
            }
        });
    }

    private static void updateTabName(@NotNull List<MavenProject> projects2, @NotNull Project project2) {
        if (projects2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(7);
        }
        MavenUtil.invokeLater(project2, () -> {
            for (MavenProject each : projects2) {
                FileEditorManagerEx.getInstanceEx((Project)project2).updateFilePresentation(each.getFile());
            }
        });
    }

    public MavenSyncConsole getSyncConsole() {
        if (null == this.mySyncConsole.get()) {
            this.mySyncConsole.compareAndSet(null, new MavenSyncConsole(this.myProject));
        }
        return this.mySyncConsole.get();
    }

    private void initProjectsTree() {
        this.initLock.lock();
        try {
            if (this.projectsTreeInitialized.getAndSet(true)) {
                return;
            }
            if (!PlatformProjectOpenProcessor.Companion.isNewProject(this.myProject)) {
                this.loadTree();
            }
            if (this.myProjectsTree == null) {
                this.myProjectsTree = new MavenProjectsTree(this.myProject);
                MavenProjectsManager.applyStateToTree(this.myProjectsTree, this);
            }
            this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster(), this);
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void loadTree() {
        try {
            Path file = this.getProjectsTreeFile();
            if (Files.exists(file, new LinkOption[0])) {
                MavenProjectsTree readTree = MavenProjectsTree.read(this.myProject, file);
                if (null != readTree) {
                    this.myProjectsTree = readTree;
                } else {
                    MavenLog.LOG.warn("Could not load existing tree, read null");
                }
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
        }
    }

    private void applyTreeToState() {
        MavenProjectsTree tree = this.getProjectsTree();
        this.myState.originalFiles = tree.getManagedFilesPaths();
        this.myState.ignoredFiles = new HashSet<String>(tree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = tree.getIgnoredFilesPatterns();
    }

    private static void applyStateToTree(MavenProjectsTree tree, MavenProjectsManager manager) {
        MavenWorkspaceSettings settings = manager.getWorkspaceSettings();
        MavenExplicitProfiles explicitProfiles2 = new MavenExplicitProfiles(settings.enabledProfiles, settings.disabledProfiles);
        tree.resetManagedFilesPathsAndProfiles(manager.myState.originalFiles, explicitProfiles2);
        tree.setIgnoredFilesPaths(new ArrayList<String>(manager.myState.ignoredFiles));
        tree.setIgnoredFilesPatterns(manager.myState.ignoredPathMasks);
    }

    public void doSave() {
        this.mySaveQueue.queue(new Update(this){

            public void run() {
                try {
                    MavenProjectsTree tree = MavenProjectsManager.this.myProjectsTree;
                    if (tree == null) {
                        return;
                    }
                    tree.save(MavenProjectsManager.this.getProjectsTreeFile());
                }
                catch (IOException e) {
                    MavenLog.LOG.info((Throwable)e);
                }
            }
        });
    }

    @ApiStatus.Internal
    public Path getProjectsTreeFile() {
        return this.getProjectCacheDir().resolve("tree.dat");
    }

    @ApiStatus.Internal
    public Path getProjectCacheDir() {
        return MavenProjectsManager.getProjectsTreesDir().resolve(this.myProject.getLocationHash());
    }

    @NotNull
    @ApiStatus.Internal
    public static Path getProjectsTreesDir() {
        Path path2 = MavenUtil.getPluginSystemDir("Projects");
        if (path2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(8);
        }
        return path2;
    }

    private void initWorkers() {
        this.myWatcher = new MavenProjectManagerWatcher(this.myProject, this.myProjectsTree);
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    @TestOnly
    public void enableAutoImportInTests() {
        assert (this.isInitialized());
        this.listenForExternalChanges();
        this.myWatcher.enableAutoImportInTests();
    }

    private void projectClosed() {
        this.initLock.lock();
        try {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            this.myWatcher.stop();
            this.mySaveQueue.flush();
            if (MavenUtil.isMavenUnitTestModeEnabled()) {
                PathKt.delete((Path)MavenProjectsManager.getProjectsTreesDir());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    public MavenEmbeddersManager getEmbeddersManager() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return !this.initLock.isLocked() && this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    public boolean isMavenizedModule(@NotNull Module m) {
        if (m == null) {
            MavenProjectsManager.$$$reportNull$$$0(9);
        }
        return MavenUtil.isMavenizedModule(m);
    }

    protected void doAddManagedFilesWithProfiles(List<VirtualFile> files2, MavenExplicitProfiles profiles2, Module previewModuleToDelete) {
        this.myPreviewModule = previewModuleToDelete;
        if (!this.isInitialized()) {
            this.doInit();
            this.doActivate();
            String distributionUrl = MavenWrapperSupport.getWrapperDistributionUrl(ProjectUtil.guessProjectDir((Project)this.myProject));
            if (distributionUrl != null) {
                this.getGeneralSettings().setMavenHomeType(MavenWrapper.INSTANCE);
            }
        }
        this.getProjectsTree().addManagedFilesWithProfiles(files2, profiles2);
    }

    public void addManagedFiles(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(10);
        }
        this.doAddManagedFilesWithProfiles(files2, MavenExplicitProfiles.NONE, null);
        this.scheduleUpdateAllMavenProjects(MavenSyncSpec.incremental("MavenProjectsManager.addManagedFiles"));
    }

    public void addManagedFilesOrUnignoreNoUpdate(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(11);
        }
        this.removeIgnoredFilesPaths(MavenUtil.collectPaths(files2));
        this.doAddManagedFilesWithProfiles(files2, MavenExplicitProfiles.NONE, null);
    }

    public void addManagedFilesOrUnignore(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(12);
        }
        this.addManagedFilesOrUnignoreNoUpdate(files2);
        this.scheduleUpdateAllMavenProjects(MavenSyncSpec.incremental("MavenProjectsManager.addManagedFilesOrUnignore"));
    }

    public boolean isManagedFile(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(13);
        }
        return this.getProjectsTree().isManagedFile(f);
    }

    @NotNull
    public MavenExplicitProfiles getExplicitProfiles() {
        MavenExplicitProfiles mavenExplicitProfiles = this.getProjectsTree().getExplicitProfiles();
        if (mavenExplicitProfiles == null) {
            MavenProjectsManager.$$$reportNull$$$0(14);
        }
        return mavenExplicitProfiles;
    }

    @NotNull
    public Collection<String> getAvailableProfiles() {
        Set<String> set2 = this.getProjectsTree().getAvailableProfiles();
        if (set2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(15);
        }
        return set2;
    }

    @NotNull
    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        Collection<Pair<String, MavenProfileKind>> collection = this.getProjectsTree().getProfilesWithStates();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public boolean hasProjects() {
        return this.getProjectsTree().hasProjects();
    }

    @NotNull
    public List<MavenProject> getProjects() {
        List<MavenProject> list = this.getProjectsTree().getProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getRootProjects() {
        List<MavenProject> list = this.getProjectsTree().getRootProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getNonIgnoredProjects() {
        List<MavenProject> list = this.getProjectsTree().getNonIgnoredProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getProjectsFiles() {
        List<VirtualFile> list = this.getProjectsTree().getProjectsFiles();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Nullable
    public MavenProject findProject(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(21);
        }
        return this.getProjectsTree().findProject(f);
    }

    public MavenProject findSingleProjectInReactor(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(22);
        }
        return this.getProjectsTree().findSingleProjectInReactor(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(23);
        }
        return this.getProjectsTree().findProject(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenProjectsManager.$$$reportNull$$$0(24);
        }
        return this.getProjectsTree().findProject(artifact);
    }

    @Nullable
    public MavenProject findProject(@NotNull Module module2) {
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(25);
        }
        MavenProject mavenProject2 = this.getMavenProject(module2);
        String moduleName = module2.getName();
        if (mavenProject2 == null && MavenImportUtil.isMainOrTestSubmodule(moduleName)) {
            Module parentModule = ModuleManager.getInstance((Project)this.myProject).findModuleByName(MavenImportUtil.getParentModuleName(moduleName));
            mavenProject2 = parentModule != null ? this.getMavenProject(parentModule) : null;
        }
        return mavenProject2;
    }

    private MavenProject getMavenProject(@NotNull Module module2) {
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(26);
        }
        return (MavenProject)CachedValuesManager.getManager((Project)module2.getProject()).getCachedValue((UserDataHolder)module2, () -> {
            VirtualFile f = this.findPomFile(module2, new MavenModelsProvider(){

                @Override
                public Module[] getModules() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public VirtualFile[] getContentRoots(Module module2) {
                    return ModuleRootManager.getInstance((Module)module2).getContentRoots();
                }
            });
            MavenProject result2 = f == null ? null : this.findProject(f);
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @RequiresReadLock
    @Nullable
    public Module findModule(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project2.getFile());
    }

    @NotNull
    public Collection<MavenProject> findInheritors(@Nullable MavenProject parent) {
        if (parent == null) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(28);
            }
            return list;
        }
        Collection<MavenProject> collection = this.getProjectsTree().findInheritors(parent);
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(29);
        }
        return collection;
    }

    @Nullable
    public MavenProject findContainingProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectsManager.$$$reportNull$$$0(30);
        }
        if (!this.isInitialized()) {
            return null;
        }
        Module module2 = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module2 == null ? null : this.findProject(module2);
    }

    @Nullable
    private VirtualFile findPomFile(@NotNull Module module2, @NotNull MavenModelsProvider modelsProvider) {
        String pomFileUrl;
        if (module2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(31);
        }
        if (modelsProvider == null) {
            MavenProjectsManager.$$$reportNull$$$0(32);
        }
        if ((pomFileUrl = MavenPomPathModuleService.getInstance(module2).getPomFileUrl()) != null) {
            return VirtualFileManager.getInstance().findFileByUrl(pomFileUrl);
        }
        for (VirtualFile root : modelsProvider.getContentRoots(module2)) {
            List<VirtualFile> pomFiles = MavenUtil.streamPomFiles(module2.getProject(), root).toList();
            if (pomFiles.isEmpty()) continue;
            if (pomFiles.size() == 1) {
                return pomFiles.get(0);
            }
            for (VirtualFile file : pomFiles) {
                if (module2.getName().equals(file.getNameWithoutExtension())) {
                    return file;
                }
                MavenProject mavenProject2 = this.findProject(file);
                if (mavenProject2 == null || !module2.getName().equals(mavenProject2.getMavenId().getArtifactId())) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public MavenProject findAggregator(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(33);
        }
        return this.getProjectsTree().findAggregator(mavenProject2);
    }

    @Nullable
    public MavenProject findRootProject(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(34);
        }
        return this.getProjectsTree().findRootProject(mavenProject2);
    }

    @NotNull
    public List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        if (aggregator == null) {
            MavenProjectsManager.$$$reportNull$$$0(35);
        }
        List<MavenProject> list = this.getProjectsTree().getModules(aggregator);
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(36);
        }
        return list;
    }

    @NotNull
    public List<String> getIgnoredFilesPaths() {
        List<String> list = this.getProjectsTree().getIgnoredFilesPaths();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(37);
        }
        return list;
    }

    public void setIgnoredFilesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            MavenProjectsManager.$$$reportNull$$$0(38);
        }
        this.getProjectsTree().setIgnoredFilesPaths(paths);
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        this.getProjectsTree().removeIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(39);
        }
        return this.getProjectsTree().getIgnoredState(project2);
    }

    @ApiStatus.Internal
    public void setIgnoredStateForPoms(@NotNull List<String> pomPaths, boolean ignored) {
        if (pomPaths == null) {
            MavenProjectsManager.$$$reportNull$$$0(40);
        }
        this.getProjectsTree().setIgnoredStateForPoms(pomPaths, ignored);
    }

    public void setIgnoredState(@NotNull List<MavenProject> projects2, boolean ignored) {
        if (projects2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(41);
        }
        this.getProjectsTree().setIgnoredState(projects2, ignored);
    }

    @NotNull
    public List<String> getIgnoredFilesPatterns() {
        List<String> list = this.getProjectsTree().getIgnoredFilesPatterns();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(42);
        }
        return list;
    }

    public void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            MavenProjectsManager.$$$reportNull$$$0(43);
        }
        this.getProjectsTree().setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(44);
        }
        return this.getProjectsTree().isIgnored(project2);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        HashSet<MavenRemoteRepository> result2 = new HashSet<MavenRemoteRepository>();
        for (MavenProject each : this.getProjects()) {
            result2.addAll(each.getRemoteRepositories());
        }
        return result2;
    }

    @TestOnly
    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    @ApiStatus.Internal
    @NotNull
    public MavenProjectsTree getProjectsTree() {
        if (this.myProjectsTree == null) {
            this.initProjectsTree();
        }
        MavenProjectsTree mavenProjectsTree = this.myProjectsTree;
        if (mavenProjectsTree == null) {
            MavenProjectsManager.$$$reportNull$$$0(45);
        }
        return mavenProjectsTree;
    }

    @Deprecated(forRemoval=true)
    protected abstract List<Module> updateAllMavenProjectsSync(MavenImportSpec var1);

    public synchronized void removeManagedFiles(@NotNull @NotNull List<@NotNull VirtualFile> files2) {
        if (files2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(46);
        }
        this.getProjectsTree().removeManagedFiles(files2);
        this.scheduleUpdateAllMavenProjects(MavenSyncSpec.full("MavenProjectsManager.removeManagedFiles", true));
    }

    public synchronized void setExplicitProfiles(MavenExplicitProfiles profiles2) {
        this.getProjectsTree().setExplicitProfiles(profiles2);
    }

    @ApiStatus.Internal
    public void forceUpdateProjects() {
        this.scheduleUpdateAllMavenProjects(MavenSyncSpec.full("MavenProjectsManager.forceUpdateProjects", true));
    }

    @Deprecated
    public AsyncPromise<Void> forceUpdateProjects(@NotNull @NotNull Collection<@NotNull MavenProject> projects2) {
        if (projects2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(47);
        }
        return this.doForceUpdateProjects(projects2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected abstract AsyncPromise<Void> doForceUpdateProjects(@NotNull @NotNull Collection<@NotNull MavenProject> var1);

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        this.forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenSyncSpec.full("MavenProjectsManager.forceUpdateAllProjectsOrFindAllAvailablePomFiles", true));
    }

    @ApiStatus.Internal
    public void findAllAvailablePomFilesIfNotMavenized() {
        if (!this.isMavenizedProject()) {
            this.doAddManagedFilesWithProfiles(this.collectAllAvailablePomFiles(), MavenExplicitProfiles.NONE, null);
        }
    }

    private void forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenSyncSpec spec) {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
            return;
        }
        this.scheduleUpdateAllMavenProjects(spec);
    }

    @Deprecated
    public Promise<List<Module>> scheduleImportAndResolve() {
        AsyncPromise promise2 = new AsyncPromise();
        List<Module> modules = this.updateAllMavenProjectsSync(MavenImportSpec.IMPLICIT_IMPORT);
        promise2.setResult(modules);
        return promise2;
    }

    public void showServerException(Throwable e) {
        this.getSyncConsole().addException(e);
    }

    public void terminateImport(int exitCode) {
        this.getSyncConsole().terminated(exitCode);
    }

    @Deprecated
    public void scheduleFoldersResolveForAllProjects() {
        MavenProjectsManagerUtilKt.scheduleFoldersResolveForAllProjects(this.myProject);
    }

    @Deprecated(forRemoval=true)
    public void waitForPostImportTasksCompletion() {
    }

    public void updateProjectTargetFolders() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenProjectImporter.tryUpdateTargetFolders(this.myProject);
            VirtualFileManager.getInstance().asyncRefresh();
        });
    }

    @Deprecated(forRemoval=true)
    public List<Module> importProjects() {
        this.scheduleUpdateAllMavenProjects(MavenSyncSpec.full("MavenProjectsManager.importProjects"));
        return List.of();
    }

    @ApiStatus.Internal
    public Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        HashMap<VirtualFile, Module> result2 = new HashMap<VirtualFile, Module>();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = this.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result2.put(f, each);
        }
        return result2;
    }

    @ApiStatus.Internal
    public List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        MavenUtil.streamPomFiles(this.myProject, this.myProject.getBaseDir()).forEach(result2::add);
        return result2;
    }

    @Deprecated
    public void addManagerListener(Listener listener2) {
        this.myManagerListeners.add(listener2);
    }

    public void addManagerListener(Listener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(48);
        }
        this.myManagerListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myManagerListeners.remove(listener2));
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener2) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    public void addProjectsTreeListener(@NotNull MavenProjectsTree.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(49);
        }
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(50);
        }
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @TestOnly
    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    protected void fireImportAndResolveScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.importAndResolveScheduled();
        }
    }

    void fireProjectImportCompleted() {
        for (Listener each : this.myManagerListeners) {
            each.projectImportCompleted();
        }
    }

    public void setForceUpdateSnapshots(boolean forceUpdateSnapshots) {
        this.forceUpdateSnapshots = forceUpdateSnapshots;
    }

    public boolean getForceUpdateSnapshots() {
        return this.forceUpdateSnapshots;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresEdt
    public void removeManagedFiles(List<VirtualFile> list, @Nullable Consumer<MavenProject> consumer, @Nullable Predicate<List<String>> predicate) {
        void removeConfirmation;
        void selectedFiles;
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<VirtualFile> removableFiles = new ArrayList<VirtualFile>();
        ArrayList<String> filesToUnIgnore = new ArrayList<String>();
        ArrayList<Module> modulesToRemove = new ArrayList<Module>();
        for (VirtualFile pomXml : selectedFiles) {
            void removeNotification;
            if (this.isManagedFile(pomXml)) {
                MavenProject managedProject = this.findProject(pomXml);
                if (managedProject == null) continue;
                this.addModuleToRemoveList(modulesToRemove, managedProject);
                this.getModules(managedProject).forEach(mp -> {
                    this.addModuleToRemoveList((List<Module>)modulesToRemove, (MavenProject)mp);
                    filesToUnIgnore.add(mp.getFile().getPath());
                });
                removableFiles.add(pomXml);
                filesToUnIgnore.add(pomXml.getPath());
                continue;
            }
            if (removeNotification == null) continue;
            removeNotification.accept(this.findProject(pomXml));
        }
        if (removeConfirmation != null && !removeConfirmation.test(ContainerUtil.map(modulesToRemove, m -> m.getName()))) {
            return;
        }
        MavenProjectsManager.removeModules(ModuleManager.getInstance((Project)this.getProject()), modulesToRemove);
        this.removeManagedFiles(removableFiles);
        this.removeIgnoredFilesPaths(filesToUnIgnore);
    }

    private void addModuleToRemoveList(List<Module> modulesToRemove, MavenProject project2) {
        Module module2 = this.findModule(project2);
        if (module2 == null) {
            return;
        }
        modulesToRemove.add(module2);
    }

    private static void removeModules(ModuleManager moduleManager, List<Module> modulesToRemove) {
        WriteAction.run(() -> {
            SmartList usingModels = new SmartList();
            block0: for (Module module2 : modulesToRemove) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                    if (!(entry instanceof ModuleOrderEntry)) continue;
                    usingModels.add(moduleRootManager.getModifiableModel());
                    continue block0;
                }
            }
            ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
            for (Module module3 : modulesToRemove) {
                ModuleDeleteProvider.removeModule((Module)module3, (Collection)usingModels, (ModifiableModuleModel)moduleModel);
            }
            ModifiableModelCommitter.multiCommit((Collection)usingModels, (ModifiableModuleModel)moduleModel);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 14, 15, 16, 17, 18, 19, 20, 28, 29, 36, 37, 42, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 6: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 25: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomPaths";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTreesDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitProfiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProfiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesWithStates";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProjects";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredProjects";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsFiles";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findInheritors";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPaths";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPatterns";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilterConfigCrc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateTabName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFilesOrUnignoreNoUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFilesOrUnignore";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isManagedFile";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSingleProjectInReactor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProject";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProject";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findPomFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findAggregator";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPaths";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredState";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredStateForPoms";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredState";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPatterns";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeManagedFiles";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProjects";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addManagerListener";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addProjectsTreeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 14, 15, 16, 17, 18, 19, 20, 28, 29, 36, 37, 42, 45 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        default public void activated() {
        }

        default public void importAndResolveScheduled() {
        }

        default public void projectImportCompleted() {
        }
    }
}

