/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenSyncListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/project/MavenImportListenerBridge;", "Lorg/jetbrains/idea/maven/project/MavenSyncListener;", "()V", "importFinished", "", "project", "Lcom/intellij/openapi/project/Project;", "importedProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "newModules", "", "Lcom/intellij/openapi/module/Module;", "importStarted", "intellij.maven"})
public final class MavenImportListenerBridge
implements MavenSyncListener {
    @Override
    public void importStarted(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MessageBus messageBus = project2.getMessageBus();
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((MavenImportListener)messageBus.syncPublisher(topic)).importStarted();
    }

    @Override
    public void importFinished(@NotNull Project project2, @NotNull Collection<? extends MavenProject> importedProjects, @NotNull List<? extends Module> newModules) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
        Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
        MessageBus messageBus = project2.getMessageBus();
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((MavenImportListener)messageBus.syncPublisher(topic)).importFinished(importedProjects, newModules);
    }
}

