/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.onlinecompletion.ProjectModulesCompletionProvider;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/onlinecompletion/ProjectModulesCompletionProvider;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "fulltextSearch", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "searchString", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocal", "isLocal", "", "suggestPrefix", "groupId", "artifactId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.maven"})
public final class ProjectModulesCompletionProvider
implements DependencySearchProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String cacheKey;

    public ProjectModulesCompletionProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.cacheKey = "ProjectModulesCompletionProvider";
    }

    @Nullable
    public Object fulltextSearch(@NotNull String searchString, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.getLocal();
    }

    @Nullable
    public Object suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.getLocal();
    }

    private final List<RepositoryArtifactData> getLocal() {
        MavenLog.LOG.debug("Project: get local maven artifacts started");
        List<MavenProject> list = MavenProjectsManager.getInstance(this.myProject).getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
        List result2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getLocal.result.1.INSTANCE), (Function1)getLocal.result.2.INSTANCE), (Function1)getLocal.result.3.INSTANCE));
        MavenLog.LOG.debug("Project: get local maven artifacts finished: " + result2.size());
        return result2;
    }

    public boolean isLocal() {
        return true;
    }

    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }
}

