/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.target;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTypeConstants;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 L2\u00020\u0001:\u0001LB\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050$0\u0013H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020-H\u0002J\u0018\u00100\u001a\u0004\u0018\u00010\u00052\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\u0005022\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020-H\u0002J\u001b\u00104\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000506H\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020\u001aJ\u001a\u0010?\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010@\u001a\u00020AH\u0007J\b\u0010B\u001a\u00020\u0015H\u0002J\b\u0010C\u001a\u00020\u0015H\u0002J$\u0010D\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050$0\u0013H\u0002J\u0010\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020;H\u0002J\u0010\u0010G\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0005H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/TargetEnvironmentRequest;)V", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLine", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "defaultJavaRuntimeConfiguration", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "defaultMavenRuntimeConfiguration", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "platform", "Lcom/intellij/execution/Platform;", "Lorg/jetbrains/annotations/NotNull;", "getPlatform", "()Lcom/intellij/execution/Platform;", "addMavenParameters", "settings", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings;", "mavenOptsValues", "Lcom/intellij/execution/target/value/TargetValue;", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "volumeDescriptor", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "localRootPath", "Ljava/nio/file/Path;", "findAllInheritors", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "findCommonAncestor", "paths", "", "findPathsToUpload", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "mavenGeneralSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "mavenRunnerSettings", "Lorg/jetbrains/idea/maven/execution/MavenRunnerSettings;", "provideEnvironment", "environment", "progressIndicator", "setupCommandLine", "setupEventListener", "", "setupExePath", "setupMavenExtClassPath", "setupTargetEnvironmentVariables", "setupTargetJavaRuntime", "runnerSettings", "setupTargetProjectDirectories", "upload", "uploadRoot", "uploadPathString", "uploadRelativePath", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenCommandLineSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCommandLineSetup.kt\norg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1#2:293\n478#3,7:294\n215#4,2:301\n215#4,2:303\n1747#5,3:305\n*S KotlinDebug\n*F\n+ 1 MavenCommandLineSetup.kt\norg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup\n*L\n132#1:294,7\n133#1:301,2\n180#1:303,2\n268#1:305,3\n*E\n"})
public final class MavenCommandLineSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final TargetEnvironmentRequest request;
    @NotNull
    private final TargetedCommandLineBuilder commandLine;
    @NotNull
    private final Platform platform;
    @Nullable
    private final MavenRuntimeTargetConfiguration defaultMavenRuntimeConfiguration;
    @Nullable
    private final JavaLanguageRuntimeConfiguration defaultJavaRuntimeConfiguration;
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    @NotNull
    private static final Key<MavenCommandLineSetup> setupKey;

    public MavenCommandLineSetup(@NotNull Project project2, @NotNull String name, @NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project2;
        this.name = name;
        this.request = request;
        this.commandLine = new TargetedCommandLineBuilder(this.request);
        Platform platform = this.request.getTargetPlatform().getPlatform();
        Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
        this.platform = platform;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        this.defaultMavenRuntimeConfiguration = targetEnvironmentConfiguration != null && (targetEnvironmentConfiguration = targetEnvironmentConfiguration.getRuntimes()) != null ? (MavenRuntimeTargetConfiguration)targetEnvironmentConfiguration.findByType(MavenRuntimeTargetConfiguration.class) : null;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = this.request.getConfiguration();
        this.defaultJavaRuntimeConfiguration = targetEnvironmentConfiguration2 != null && (targetEnvironmentConfiguration2 = targetEnvironmentConfiguration2.getRuntimes()) != null ? (JavaLanguageRuntimeConfiguration)targetEnvironmentConfiguration2.findByType(JavaLanguageRuntimeConfiguration.class) : null;
        this.environmentPromise = new AsyncPromise();
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.commandLine.putUserData(setupKey, (Object)this);
    }

    @NotNull
    public final TargetedCommandLineBuilder getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings, boolean setupEventListener) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        List mavenOptsValues = new ArrayList();
        this.setupExePath();
        this.setupTargetJavaRuntime(this.mavenRunnerSettings(settings));
        this.setupTargetProjectDirectories(settings);
        if (setupEventListener) {
            this.setupMavenExtClassPath();
        }
        this.addMavenParameters(settings, mavenOptsValues);
        this.setupTargetEnvironmentVariables(settings, mavenOptsValues);
        return this;
    }

    public static /* synthetic */ MavenCommandLineSetup setupCommandLine$default(MavenCommandLineSetup mavenCommandLineSetup, MavenRunConfiguration.MavenSettings mavenSettings, boolean bl, int n, Object object) throws CantRunException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return mavenCommandLineSetup.setupCommandLine(mavenSettings, bl);
    }

    public final void provideEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)progressIndicator));
        for (Promise<Unit> promise2 : this.dependingOnEnvironmentPromise) {
            promise2.blockingGet(0);
        }
    }

    private final void setupExePath() throws CantRunException {
        if (this.defaultMavenRuntimeConfiguration == null) {
            this.commandLine.setExePath("mvn");
            return;
        }
        String homePath = this.defaultMavenRuntimeConfiguration.getHomePath();
        if (StringUtil.isEmptyOrSpaces((String)homePath)) {
            this.commandLine.setExePath("mvn");
            return;
        }
        this.commandLine.addEnvironmentVariable("MAVEN_HOME", homePath);
        this.commandLine.addEnvironmentVariable("M2_HOME", homePath);
        String[] stringArray = new String[]{homePath, "bin", "mvn"};
        this.commandLine.setExePath(this.joinPath(stringArray));
    }

    private final void setupTargetJavaRuntime(MavenRunnerSettings runnerSettings) {
        block0: {
            Object object;
            String string;
            String string2 = !Intrinsics.areEqual((Object)runnerSettings.getJreName(), (Object)"#USE_PROJECT_JDK") ? runnerSettings.getJreName() : (string = ((object = this.defaultJavaRuntimeConfiguration) != null && (object = object.getHomePath()) != null ? !StringsKt.isBlank((CharSequence)((CharSequence)object)) : false) ? this.defaultJavaRuntimeConfiguration.getHomePath() : null);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.commandLine.addEnvironmentVariable("JAVA_HOME", it);
        }
    }

    private final void setupMavenExtClassPath() {
        File mavenEventListener = MavenServerManager.Companion.getInstance().getMavenEventListener();
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)mavenEventListener.getPath()), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeTypeConstants.getMAVEN_EXT_CLASS_PATH_VOLUME();
        Path path2 = uploadPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, path2);
        ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
        TargetValue<String> targetValue2 = this.upload(uploadRoot, ((Object)uploadPath).toString(), ((Object)uploadPath.getFileName()).toString());
        TargetValue targetValue3 = TargetValue.map(targetValue2, arg_0 -> MavenCommandLineSetup.setupMavenExtClassPath$lambda$1(setupMavenExtClassPath.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue3, (String)"map(...)");
        this.commandLine.addParameter(targetValue3);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMavenParameters(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        block17: {
            String string;
            CharSequence charSequence;
            Object object;
            void $this$forEach$iv;
            Map $this$filterKeys$iv;
            MavenGeneralSettings generalSettings = this.mavenGeneralSettings(settings);
            MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
            if (runnerSettings.isSkipTests()) {
                this.commandLine.addParameter("-DskipTests=true");
            }
            TargetValue targetValue2 = TargetValue.fixed((Object)("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess()));
            Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"fixed(...)");
            mavenOptsValues.add((TargetValue<String>)targetValue2);
            String string2 = runnerSettings.getVmOptions();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVmOptions(...)");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                TargetValue targetValue3 = TargetValue.fixed((Object)runnerSettings.getVmOptions());
                Intrinsics.checkNotNullExpressionValue((Object)targetValue3, (String)"fixed(...)");
                mavenOptsValues.add((TargetValue<String>)targetValue3);
            }
            ParametersList mavenPropertiesList = new ParametersList();
            Map<String, String> map = runnerSettings.getMavenProperties();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getMavenProperties(...)");
            Map<String, String> map2 = map;
            boolean $i$f$filterKeys = false;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                linkedHashMap.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterKeys$iv = linkedHashMap;
            boolean $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                object = entry;
                boolean bl = false;
                String key = (String)object.getKey();
                String value = (String)object.getValue();
                mavenPropertiesList.addProperty(key, value);
            }
            List list = mavenPropertiesList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            this.commandLine.addParameters(list);
            MavenRunnerParameters mavenRunnerParameters = settings.myRunnerParameters;
            if (mavenRunnerParameters == null) {
                mavenRunnerParameters = new MavenRunnerParameters();
            }
            MavenRunnerParameters runnerParameters = mavenRunnerParameters;
            for (String string3 : runnerParameters.getGoals()) {
                Intrinsics.checkNotNull((Object)string3);
                this.commandLine.addParameter(string3);
            }
            if (runnerParameters.getPomFileName() != null && !FileUtil.namesEqual((String)"pom.xml", (String)runnerParameters.getPomFileName())) {
                this.commandLine.addParameter("-f");
                String string4 = runnerParameters.getPomFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPomFileName(...)");
                this.commandLine.addParameter(string4);
            }
            String encodeProfiles = MavenExternalParameters.encodeProfiles(runnerParameters.getProfilesMap());
            Intrinsics.checkNotNull((Object)encodeProfiles);
            if (((CharSequence)encodeProfiles).length() > 0) {
                String[] stringArray = new String[]{"-P", encodeProfiles};
                this.commandLine.addParameters(stringArray);
            }
            if (generalSettings.isWorkOffline()) {
                this.commandLine.addParameter("--offline");
            }
            if (generalSettings.getOutputLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
                this.commandLine.addParameter("--debug");
            }
            if (generalSettings.isNonRecursive()) {
                this.commandLine.addParameter("--non-recursive");
            }
            if (generalSettings.isPrintErrorStackTraces()) {
                this.commandLine.addParameter("--errors");
            }
            if (generalSettings.isAlwaysUpdateSnapshots()) {
                this.commandLine.addParameter("--update-snapshots");
            }
            if (!((charSequence = (CharSequence)(string = generalSettings.getThreads())) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String[] stringArray = new String[]{"-T", string};
                this.commandLine.addParameters(stringArray);
            }
            String string5 = StringKt.nullize((String)generalSettings.getFailureBehavior().getCommandLineOption(), (boolean)true);
            if (string5 != null) {
                Object it = object = string5;
                boolean bl = false;
                this.commandLine.addParameter((String)it);
            }
            String string6 = StringKt.nullize((String)generalSettings.getChecksumPolicy().getCommandLineOption(), (boolean)true);
            if (string6 != null) {
                Object it = object = string6;
                boolean bl = false;
                this.commandLine.addParameter((String)it);
            }
            String string7 = generalSettings.getUserSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getUserSettingsFile(...)");
            if (!StringsKt.isBlank((CharSequence)string7)) {
                String[] stringArray = new String[2];
                stringArray[0] = "-s";
                Intrinsics.checkNotNullExpressionValue((Object)generalSettings.getUserSettingsFile(), (String)"getUserSettingsFile(...)");
                this.commandLine.addParameters(stringArray);
            }
            String string8 = StringKt.nullize((String)generalSettings.getLocalRepository(), (boolean)true);
            if (string8 == null) break block17;
            Object it = object = string8;
            boolean bl = false;
            this.commandLine.addParameter("-Dmaven.repo.local=" + (String)it);
        }
    }

    private final void setupTargetEnvironmentVariables(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
        Map<String, String> map = runnerSettings.getEnvironmentProperties();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEnvironmentProperties(...)");
        Map<String, String> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            if (Intrinsics.areEqual((Object)"MAVEN_OPTS", (Object)name)) {
                TargetValue targetValue2 = TargetValue.fixed((Object)value);
                Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"fixed(...)");
                mavenOptsValues.add((TargetValue<String>)targetValue2);
                continue;
            }
            Intrinsics.checkNotNull((Object)name);
            this.commandLine.addEnvironmentVariable(name, value);
        }
        TargetValue targetValue3 = TargetValue.composite((Collection)mavenOptsValues, arg_0 -> MavenCommandLineSetup.setupTargetEnvironmentVariables$lambda$8(setupTargetEnvironmentVariables.targetValue.1.INSTANCE, arg_0));
        this.commandLine.addEnvironmentVariable("MAVEN_OPTS", targetValue3);
    }

    private final MavenGeneralSettings mavenGeneralSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenGeneralSettings mavenGeneralSettings = settings.myGeneralSettings;
        if (mavenGeneralSettings == null) {
            MavenGeneralSettings mavenGeneralSettings2 = MavenProjectsManager.getInstance(this.project).getGeneralSettings();
            mavenGeneralSettings = mavenGeneralSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings2, (String)"getGeneralSettings(...)");
        }
        return mavenGeneralSettings;
    }

    private final MavenRunnerSettings mavenRunnerSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenRunnerSettings mavenRunnerSettings = settings.myRunnerSettings;
        if (mavenRunnerSettings == null) {
            MavenRunnerSettings mavenRunnerSettings2 = MavenRunner.getInstance(this.project).getState();
            mavenRunnerSettings = mavenRunnerSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings2, (String)"getState(...)");
        }
        return mavenRunnerSettings;
    }

    private final TargetValue<String> upload(TargetEnvironment.UploadRoot uploadRoot, String uploadPathString, String uploadRelativePath) {
        DeferredTargetValue result2 = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> MavenCommandLineSetup.upload$lambda$9((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>(uploadRoot, uploadRelativePath, (DeferredTargetValue<String>)result2){
            final /* synthetic */ TargetEnvironment.UploadRoot $uploadRoot;
            final /* synthetic */ String $uploadRelativePath;
            final /* synthetic */ DeferredTargetValue<String> $result;
            {
                this.$uploadRoot = $uploadRoot;
                this.$uploadRelativePath = $uploadRelativePath;
                this.$result = $result;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                TargetProgressIndicator progress = (TargetProgressIndicator)pair.component2();
                TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)this.$uploadRoot);
                String resolvedTargetPath = volume.resolveTargetPath(this.$uploadRelativePath);
                volume.upload(this.$uploadRelativePath, progress);
                this.$result.resolve((Object)resolvedTargetPath);
            }
        }, arg_0)));
        return (TargetValue)result2;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(LanguageRuntimeType.VolumeDescriptor volumeDescriptor, Path localRootPath) {
        return MavenRuntimeTargetConfiguration.Companion.createUploadRoot(this.defaultMavenRuntimeConfiguration, this.request, volumeDescriptor, localRootPath);
    }

    private final void setupTargetProjectDirectories(MavenRunConfiguration.MavenSettings settings) {
        String commonAncestor;
        MavenRunnerParameters mavenRunnerParameters;
        MavenProjectsManager mavenProjectsManager;
        block9: {
            block8: {
                mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
                mavenRunnerParameters = settings.myRunnerParameters;
                if (mavenRunnerParameters == null) break block8;
                MavenRunnerParameters it = mavenRunnerParameters;
                boolean bl = false;
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)it.getWorkingDirFile(), (boolean)false);
                mavenRunnerParameters = virtualFile;
                if (virtualFile != null) break block9;
            }
            Object[] objectArray = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.use.working.directory", objectArray));
        }
        MavenRunnerParameters file = mavenRunnerParameters;
        Module module2 = (Module)ReadAction.compute(() -> MavenCommandLineSetup.setupTargetProjectDirectories$lambda$11(this, (VirtualFile)file));
        if (module2 == null) {
            Object[] objectArray = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", objectArray));
        }
        Module module3 = module2;
        MavenProject mavenProject2 = mavenProjectsManager.findProject(module3);
        if (mavenProject2 == null) {
            Object[] objectArray = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", objectArray));
        }
        MavenProject mavenProject3 = mavenProject2;
        String string = FileUtil.toSystemDependentName((String)mavenProject3.getDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String mavenProjectDirectory = string;
        Intrinsics.checkNotNull((Object)mavenProjectsManager);
        Set<String> pathsToUpload = this.findPathsToUpload(mavenProjectsManager, mavenProject3);
        String string2 = commonAncestor = this.findCommonAncestor(pathsToUpload);
        Intrinsics.checkNotNull((Object)string2);
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)string2), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeTypeConstants.getPROJECT_FOLDER_VOLUME();
        Intrinsics.checkNotNull((Object)uploadPath);
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, uploadPath);
        ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
        char targetFileSeparator = this.request.getTargetPlatform().getPlatform().fileSeparator;
        TargetValue targetWorkingDirectory = null;
        for (String path2 : pathsToUpload) {
            String string3;
            String workingDirRelativePath;
            String relativePath;
            String string4 = relativePath = FileUtil.getRelativePath((String)commonAncestor, (String)path2, (char)File.separatorChar);
            Intrinsics.checkNotNull((Object)string4);
            TargetValue<String> targetValue2 = this.upload(uploadRoot, path2, string4);
            if (targetWorkingDirectory != null || !FileUtil.isAncestor((String)path2, (String)mavenProjectDirectory, (boolean)false)) continue;
            Intrinsics.checkNotNull((Object)FileUtil.getRelativePath((String)path2, (String)mavenProjectDirectory, (char)File.separatorChar));
            if (Intrinsics.areEqual((Object)workingDirRelativePath, (Object)".")) {
                string3 = "";
            } else {
                String string5 = FileUtil.toSystemDependentName((String)workingDirRelativePath, (char)targetFileSeparator);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemDependentName(...)");
            }
            String targetWorkingDirRelativePath = string3;
            targetWorkingDirectory = TargetValue.map(targetValue2, arg_0 -> MavenCommandLineSetup.setupTargetProjectDirectories$lambda$12((Function1)new Function1<String, String>(targetFileSeparator, targetWorkingDirRelativePath){
                final /* synthetic */ char $targetFileSeparator;
                final /* synthetic */ String $targetWorkingDirRelativePath;
                {
                    this.$targetFileSeparator = $targetFileSeparator;
                    this.$targetWorkingDirRelativePath = $targetWorkingDirRelativePath;
                    super(1);
                }

                public final String invoke(String it) {
                    return it + this.$targetFileSeparator + this.$targetWorkingDirRelativePath;
                }
            }, arg_0));
        }
        TargetValue targetValue3 = targetWorkingDirectory;
        Intrinsics.checkNotNull(targetValue3);
        this.commandLine.setWorkingDirectory(targetValue3);
    }

    private final String findCommonAncestor(Set<String> paths) {
        boolean bl;
        File commonRoot = null;
        for (String path2 : paths) {
            File file = commonRoot;
            commonRoot = file == null ? new File(path2) : FileUtil.findAncestor((File)file, (File)new File(path2));
            if (commonRoot != null) continue;
            boolean bl2 = false;
            String string = "no common root found";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = commonRoot != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        File file = commonRoot;
        Intrinsics.checkNotNull(file);
        return file.getPath();
    }

    private final Set<String> findPathsToUpload(MavenProjectsManager mavenProjectsManager, MavenProject project2) {
        MavenProject mavenProject2 = mavenProjectsManager.findRootProject(project2);
        if (mavenProject2 == null) {
            return SetsKt.emptySet();
        }
        MavenProject rootProject = mavenProject2;
        LinkedList projects2 = new LinkedList();
        ((Collection)projects2).add(rootProject);
        projects2.addAll(this.findAllInheritors(mavenProjectsManager, rootProject));
        Set paths = new HashSet();
        while (!((Collection)projects2).isEmpty()) {
            String projectDirectory2;
            boolean bl;
            block5: {
                MavenProject mavenProject3;
                MavenProject mavenProject4 = mavenProject3 = (MavenProject)projects2.pop();
                Intrinsics.checkNotNull((Object)mavenProject4);
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemDependentName((String)mavenProject4.getDirectory()), (String)"toSystemDependentName(...)");
                Iterable $this$any$iv = paths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!FileUtil.isAncestor((String)it, (String)projectDirectory2, (boolean)false)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            paths.removeIf(arg_0 -> MavenCommandLineSetup.findPathsToUpload$lambda$15((Function1)new Function1<String, Boolean>(projectDirectory2){
                final /* synthetic */ String $projectDirectory;
                {
                    this.$projectDirectory = $projectDirectory;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FileUtil.isAncestor((String)this.$projectDirectory, (String)it, (boolean)false);
                }
            }, arg_0));
            paths.add(projectDirectory2);
        }
        return paths;
    }

    private final List<MavenProject> findAllInheritors(MavenProjectsManager mavenProjectsManager, MavenProject project2) {
        Collection<MavenProject> collection = mavenProjectsManager.findInheritors(project2);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findInheritors(...)");
        Collection<MavenProject> inheritors = collection;
        ArrayList<MavenProject> result2 = new ArrayList<MavenProject>(inheritors);
        for (MavenProject inheritor : inheritors) {
            Collection collection2 = result2;
            Intrinsics.checkNotNull((Object)inheritor);
            CollectionsKt.addAll((Collection)collection2, (Iterable)this.findAllInheritors(mavenProjectsManager, inheritor));
        }
        return result2;
    }

    private final String joinPath(String[] segments) {
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.platform.fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return MavenCommandLineSetup.setupCommandLine$default(this, settings, false, 2, null);
    }

    private static final String setupMavenExtClassPath$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String setupTargetEnvironmentVariables$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit upload$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Module setupTargetProjectDirectories$lambda$11(MavenCommandLineSetup this$0, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return ProjectFileIndex.getInstance((Project)this$0.project).getModuleForFile($file);
    }

    private static final String setupTargetProjectDirectories$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean findPathsToUpload$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Key<MavenCommandLineSetup> getSetupKey() {
        return Companion.getSetupKey();
    }

    static {
        Key key = Key.create((String)"org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        setupKey = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup$Companion;", "", "()V", "setupKey", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSetupKey$annotations", "getSetupKey", "()Lcom/intellij/openapi/util/Key;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MavenCommandLineSetup> getSetupKey() {
            return setupKey;
        }

        @JvmStatic
        public static /* synthetic */ void getSetupKey$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

