/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesVersionConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter;", "()V", "doGetVariants", "", "", "id", "Lorg/jetbrains/idea/maven/model/MavenId;", "searchService", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "doIsValid", "", "manager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "context", "Lcom/intellij/util/xml/ConvertContext;", "fromString", "s", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenArtifactCoordinatesVersionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenArtifactCoordinatesVersionConverter.kt\norg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesVersionConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class MavenArtifactCoordinatesVersionConverter
extends MavenArtifactCoordinatesConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern MAGIC_VERSION_PATTERN = Pattern.compile("\\s*(?:LATEST|RELEASE|[(\\[].*|.*-20\\d{6}\\.[0-2]\\d{5}-\\d+)\\s*");

    @Override
    @Nullable
    public String fromString(@Nullable String s, @NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (s != null) {
            return super.fromString(s, context2);
        }
        if (MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(context2)) {
            return MavenConsumerPomUtil.getAutomaticParentVersion(context2);
        }
        return null;
    }

    @Override
    protected boolean doIsValid(@NotNull MavenId id, @NotNull MavenIndicesManager manager, @NotNull ConvertContext context2) {
        MavenProject mavenProject2;
        VirtualFile projectFile;
        String mavenVersion;
        String string;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
                    return false;
                }
                PsiDirectory psiDirectory = context2.getFile().getContainingDirectory();
                String path2 = psiDirectory != null && (psiDirectory = psiDirectory.getVirtualFile()) != null ? psiDirectory.getPath() : null;
                string = path2;
                if (string == null) break block11;
                String it = string;
                boolean bl = false;
                String string2 = MavenUtil.getMavenVersion(context2.getProject(), it);
                string = string2;
                if (string2 != null) break block12;
            }
            string = MavenDistributionsCache.getInstance(context2.getProject()).getSettingsDistribution().getVersion();
        }
        if (VersionComparatorUtil.compare((String)(mavenVersion = string), (String)"3.6.3") <= 0 && id.getVersion() == null) {
            return false;
        }
        if (id.getVersion() == null) {
            return MavenConsumerPomUtil.getAutomaticParentVersion(context2) != null;
        }
        String string3 = id.getVersion();
        Intrinsics.checkNotNull((Object)string3);
        if (StringsKt.isBlank((CharSequence)string3)) {
            return false;
        }
        String string4 = id.getVersion();
        Intrinsics.checkNotNull((Object)string4);
        if (MAGIC_VERSION_PATTERN.matcher(string4).matches()) {
            return true;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
        if (projectsManager.findProject(id) != null) {
            return true;
        }
        VirtualFile virtualFile = projectFile = this.getMavenProjectFile(context2);
        MavenProject mavenProject3 = mavenProject2 = virtualFile == null ? null : projectsManager.findProject(virtualFile);
        if (mavenProject2 != null) {
            for (MavenArtifact artifact : mavenProject2.findDependencies(id)) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        boolean hasLocalVersion = manager.hasLocalVersion(id.getGroupId(), id.getArtifactId(), id.getVersion());
        return hasLocalVersion;
    }

    @Override
    @NotNull
    protected Set<String> doGetVariants(@NotNull MavenId id, @NotNull DependencySearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        return SetsKt.emptySet();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesVersionConverter$Companion;", "", "()V", "MAGIC_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

