/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsoleBase;
import org.jetbrains.idea.maven.execution.MavenConsoleBundle;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011J&\u0010\u0015\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011H\u0002J$\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenDownloadConsole;", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsoleBase;", "myProject", "Lcom/intellij/openapi/project/Project;", "downloadSources", "", "downloadDocs", "(Lcom/intellij/openapi/project/Project;ZZ)V", "message", "", "getMessage", "()Ljava/lang/String;", "title", "getTitle", "finishDownloadTask", "", "projects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "artifacts", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "getStringRepresentation", "startDownloadTask", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenConsoles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenConsoles.kt\norg/jetbrains/idea/maven/buildtool/MavenDownloadConsole\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1549#2:215\n1620#2,3:216\n1549#2:219\n1620#2,3:220\n*S KotlinDebug\n*F\n+ 1 MavenConsoles.kt\norg/jetbrains/idea/maven/buildtool/MavenDownloadConsole\n*L\n193#1:215\n193#1:216,3\n194#1:219\n194#1:220,3\n*E\n"})
public final class MavenDownloadConsole
extends MavenSyncConsoleBase {
    @NotNull
    private final String title;
    @NotNull
    private final String message;

    public MavenDownloadConsole(@NotNull Project myProject, boolean downloadSources, boolean downloadDocs) {
        String string;
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        super(myProject);
        String string2 = MavenConsoleBundle.message("maven.download.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.title = string2;
        if (downloadSources) {
            String string3 = downloadDocs ? MavenConsoleBundle.message("maven.download.sources.and.docs", new Object[0]) : MavenConsoleBundle.message("maven.download.sources", new Object[0]);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = MavenConsoleBundle.message("maven.download.docs", new Object[0]);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        this.message = string;
    }

    @Override
    @NotNull
    protected String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    public final void startDownloadTask(@NotNull Collection<? extends MavenProject> projects2, @Nullable Collection<? extends MavenArtifact> artifacts) {
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        this.startTask(this.getStringRepresentation(projects2, artifacts));
    }

    public final void finishDownloadTask(@NotNull Collection<? extends MavenProject> projects2, @Nullable Collection<? extends MavenArtifact> artifacts) {
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        this.completeTask(this.getStringRepresentation(projects2, artifacts), (EventResult)new SuccessResultImpl());
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringRepresentation(Collection<? extends MavenProject> projects2, Collection<? extends MavenArtifact> artifacts) {
        String string;
        String artifactNames;
        Iterable<MavenId> iterable;
        Iterable<MavenId> destination$iv$iv;
        Object[] objectArray;
        String string2;
        if (projects2.isEmpty()) {
            string2 = "-";
        } else {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv = (Object[])projects2;
            boolean $i$f$map = false;
            objectArray = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MavenProject mavenProject2 = (MavenProject)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add(it.getMavenId());
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
        }
        String projectNames = string2;
        Collection<? extends MavenArtifact> $i$f$map = artifacts;
        if ($i$f$map == null || $i$f$map.isEmpty()) {
            v1 = "";
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = artifacts;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MavenArtifact bl = (MavenArtifact)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl2 = false;
                iterable.add((MavenId)it.getMavenId());
            }
            v1 = artifactNames = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), null, null, null, (int)0, null, null, (int)63, null);
        }
        if (((CharSequence)artifactNames).length() == 0) {
            objectArray = new Object[]{projectNames};
            String string3 = MavenConsoleBundle.message("maven.download.projects", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            objectArray = new Object[]{projectNames, artifactNames};
            String string4 = MavenConsoleBundle.message("maven.download.projects.and.artifacts", objectArray);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        return string;
    }
}

